/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.sh.codeInsight.ShFunctionReference;
import com.intellij.sh.psi.ShLiteral;
import com.intellij.sh.psi.ShString;
import com.intellij.sh.psi.ShVariable;
import com.intellij.sh.run.ShRunConfiguration;
import com.intellij.sh.run.ShRunConfigurationProfileState;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ShSupport {
    public static ShSupport getInstance() {
        return (ShSupport)ServiceManager.getService(ShSupport.class);
    }

    public boolean isExternalFormatterEnabled();

    public boolean isRenameEnabled();

    @NotNull
    public RunProfileState createRunProfileState(@NotNull Executor var1, @NotNull ExecutionEnvironment var2, @NotNull ShRunConfiguration var3);

    public PsiReference @NotNull [] getVariableReferences(@NotNull ShVariable var1);

    public PsiReference @NotNull [] getLiteralReferences(@NotNull ShLiteral var1);

    @Nullable
    public String getName(@NotNull ShLiteral var1);

    @Nullable
    public PsiElement getNameIdentifier(@NotNull ShLiteral var1);

    public static class Impl
    implements ShSupport {
        @Override
        public boolean isExternalFormatterEnabled() {
            return true;
        }

        @Override
        public boolean isRenameEnabled() {
            return true;
        }

        @Override
        @NotNull
        public RunProfileState createRunProfileState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment, @NotNull ShRunConfiguration configuration) {
            if (executor == null) {
                Impl.$$$reportNull$$$0(0);
            }
            if (environment == null) {
                Impl.$$$reportNull$$$0(1);
            }
            if (configuration == null) {
                Impl.$$$reportNull$$$0(2);
            }
            return new ShRunConfigurationProfileState(environment.getProject(), configuration);
        }

        @Override
        public PsiReference @NotNull [] getVariableReferences(@NotNull ShVariable v) {
            if (v == null) {
                Impl.$$$reportNull$$$0(3);
            }
            if (PsiReference.EMPTY_ARRAY == null) {
                Impl.$$$reportNull$$$0(4);
            }
            return PsiReference.EMPTY_ARRAY;
        }

        @Override
        public PsiReference @NotNull [] getLiteralReferences(@NotNull ShLiteral o) {
            if (o == null) {
                Impl.$$$reportNull$$$0(5);
            }
            PsiReference[] psiReferenceArray = o instanceof ShString || o.getWord() != null ? (PsiReference[])ArrayUtil.prepend((Object)((Object)new ShFunctionReference(o)), (Object[])ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)o)) : PsiReference.EMPTY_ARRAY;
            if (psiReferenceArray == null) {
                Impl.$$$reportNull$$$0(6);
            }
            return psiReferenceArray;
        }

        @Override
        @Nullable
        public String getName(@NotNull ShLiteral l) {
            if (l == null) {
                Impl.$$$reportNull$$$0(7);
            }
            return null;
        }

        @Override
        @Nullable
        public PsiElement getNameIdentifier(@NotNull ShLiteral l) {
            if (l == null) {
                Impl.$$$reportNull$$$0(8);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "environment";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sh/ShSupport$Impl";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "l";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sh/ShSupport$Impl";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariableReferences";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLiteralReferences";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createRunProfileState";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getVariableReferences";
                    break;
                }
                case 4: 
                case 6: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getLiteralReferences";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getName";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getNameIdentifier";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

