/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stats.completion;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.lookup.impl.PrefixChangeListener;
import com.intellij.ide.ui.UISettings;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.stats.completion.LookupFinishListener;
import com.intellij.stats.completion.LookupTracker;
import com.intellij.stats.storage.factors.LookupStorage;
import com.intellij.stats.storage.factors.MutableLookupStorage;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \n2\u00020\u0001:\u0003\n\u000b\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0014J\u0018\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\r"}, d2={"Lcom/intellij/stats/completion/CompletionQualityTracker;", "Lcom/intellij/stats/completion/LookupTracker;", "()V", "lookupClosed", "", "lookupCreated", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "storage", "Lcom/intellij/stats/storage/factors/MutableLookupStorage;", "Companion", "CompletionQualityListener", "QueryTracker", "intellij.statsCollector"})
public final class CompletionQualityTracker
extends LookupTracker {
    private static final String GROUP_ID = "completion";
    public static final Companion Companion = new Companion(null);

    @Override
    protected void lookupCreated(@NotNull LookupImpl lookup, @NotNull MutableLookupStorage storage) {
        Intrinsics.checkParameterIsNotNull((Object)lookup, (String)"lookup");
        Intrinsics.checkParameterIsNotNull((Object)storage, (String)"storage");
        QueryTracker queryTracker = new QueryTracker(DumbService.isDumb((Project)lookup.getProject()));
        lookup.addPrefixChangeListener((PrefixChangeListener)queryTracker, (Disposable)lookup);
        lookup.addLookupListener((LookupListener)new CompletionQualityListener(storage, queryTracker));
    }

    @Override
    protected void lookupClosed() {
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0016R\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\t\u00a8\u0006\u0013"}, d2={"Lcom/intellij/stats/completion/CompletionQualityTracker$QueryTracker;", "Lcom/intellij/codeInsight/lookup/impl/PrefixChangeListener;", "dumbStart", "", "(Z)V", "<set-?>", "", "backspaceActionsCount", "getBackspaceActionsCount", "()I", "getDumbStart", "()Z", "typingActionsCount", "getTypingActionsCount", "beforeAppend", "", "c", "", "beforeTruncate", "intellij.statsCollector"})
    private static final class QueryTracker
    implements PrefixChangeListener {
        private int typingActionsCount;
        private int backspaceActionsCount;
        private final boolean dumbStart;

        public final int getTypingActionsCount() {
            return this.typingActionsCount;
        }

        public final int getBackspaceActionsCount() {
            return this.backspaceActionsCount;
        }

        public void beforeTruncate() {
            ++this.backspaceActionsCount;
        }

        public void beforeAppend(char c) {
            ++this.typingActionsCount;
        }

        public final boolean getDumbStart() {
            return this.dumbStart;
        }

        public QueryTracker(boolean dumbStart) {
            this.dumbStart = dumbStart;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001:\u0001%B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J$\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\u001eH\u0002J\u0010\u0010#\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010$\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/stats/completion/CompletionQualityTracker$CompletionQualityListener;", "Lcom/intellij/stats/completion/LookupFinishListener;", "storage", "Lcom/intellij/stats/storage/factors/LookupStorage;", "queryTracker", "Lcom/intellij/stats/completion/CompletionQualityTracker$QueryTracker;", "(Lcom/intellij/stats/storage/factors/LookupStorage;Lcom/intellij/stats/completion/CompletionQualityTracker$QueryTracker;)V", "selectionChangesCount", "", "getSelectionChangesCount", "()I", "setSelectionChangesCount", "(I)V", "shownTimestamp", "", "getShownTimestamp", "()J", "setShownTimestamp", "(J)V", "cancelled", "", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "canceledExplicitly", "", "currentItemChanged", "event", "Lcom/intellij/codeInsight/lookup/LookupEvent;", "explicitSelect", "element", "Lcom/intellij/codeInsight/lookup/LookupElement;", "logDetails", "finishType", "Lcom/intellij/stats/completion/CompletionQualityTracker$CompletionQualityListener$FinishType;", "currentItem", "lookupShown", "typedSelect", "FinishType", "intellij.statsCollector"})
    private static final class CompletionQualityListener
    extends LookupFinishListener {
        private long shownTimestamp;
        private int selectionChangesCount;
        private final LookupStorage storage;
        private final QueryTracker queryTracker;

        public final long getShownTimestamp() {
            return this.shownTimestamp;
        }

        public final void setShownTimestamp(long l) {
            this.shownTimestamp = l;
        }

        public final int getSelectionChangesCount() {
            return this.selectionChangesCount;
        }

        public final void setSelectionChangesCount(int n) {
            this.selectionChangesCount = n;
        }

        public void lookupShown(@NotNull LookupEvent event) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            this.shownTimestamp = System.currentTimeMillis();
        }

        public void currentItemChanged(@NotNull LookupEvent event) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            ++this.selectionChangesCount;
        }

        @Override
        public void cancelled(@NotNull LookupImpl lookup, boolean canceledExplicitly) {
            Intrinsics.checkParameterIsNotNull((Object)lookup, (String)"lookup");
            CompletionQualityListener.logDetails$default(this, lookup, canceledExplicitly ? FinishType.CANCELED_EXPLICITLY : FinishType.CANCELED_BY_TYPING, null, 4, null);
        }

        @Override
        public void explicitSelect(@NotNull LookupImpl lookup, @NotNull LookupElement element) {
            Intrinsics.checkParameterIsNotNull((Object)lookup, (String)"lookup");
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            this.logDetails(lookup, FinishType.EXPLICIT, element);
        }

        @Override
        public void typedSelect(@NotNull LookupImpl lookup, @NotNull LookupElement element) {
            Intrinsics.checkParameterIsNotNull((Object)lookup, (String)"lookup");
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            this.logDetails(lookup, FinishType.TYPED, element);
        }

        private final void logDetails(LookupImpl lookup, FinishType finishType, LookupElement currentItem) {
            FeatureUsageData featureUsageData = new FeatureUsageData();
            boolean bl = false;
            boolean bl2 = false;
            FeatureUsageData $this$apply = featureUsageData;
            boolean bl3 = false;
            $this$apply.addLanguage(this.storage.getLanguage());
            $this$apply.addData("alphabetically", UISettings.Companion.getInstance().getSortLookupElementsLexicographically());
            $this$apply.addData("ml_used", this.storage.mlUsed());
            Object object = this.storage.getModel();
            if (object == null || (object = object.version()) == null) {
                object = "unknown";
            }
            $this$apply.addData("version", (String)object);
            Object object2 = currentItem;
            $this$apply.addData("token_length", object2 != null && (object2 = object2.getLookupString()) != null ? ((String)object2).length() : -1);
            $this$apply.addData("query_length", currentItem == null ? -1 : lookup.itemPattern(currentItem).length());
            $this$apply.addData("selected_index", lookup.getSelectedIndex());
            $this$apply.addData("finish_type", finishType.toString());
            $this$apply.addData("duration", System.currentTimeMillis() - this.storage.getStartedTimestamp());
            $this$apply.addData("selection_changed", this.selectionChangesCount);
            $this$apply.addData("typing", this.queryTracker.getTypingActionsCount());
            $this$apply.addData("backspaces", this.queryTracker.getBackspaceActionsCount());
            $this$apply.addData("total_ml_time", this.storage.getPerformanceTracker().totalMLTimeContribution());
            $this$apply.addData("time_to_show", this.shownTimestamp == -1L ? -1L : this.shownTimestamp - this.storage.getStartedTimestamp());
            $this$apply.addData("dumb_start", this.queryTracker.getDumbStart());
            $this$apply.addData("dumb_finish", DumbService.isDumb((Project)lookup.getProject()));
            FeatureUsageData data = featureUsageData;
            FUCounterUsageLogger.getInstance().logEvent(CompletionQualityTracker.GROUP_ID, "finished", data);
        }

        static /* synthetic */ void logDetails$default(CompletionQualityListener completionQualityListener, LookupImpl lookupImpl, FinishType finishType, LookupElement lookupElement, int n, Object object) {
            if ((n & 4) != 0) {
                lookupElement = null;
            }
            completionQualityListener.logDetails(lookupImpl, finishType, lookupElement);
        }

        public CompletionQualityListener(@NotNull LookupStorage storage, @NotNull QueryTracker queryTracker) {
            Intrinsics.checkParameterIsNotNull((Object)storage, (String)"storage");
            Intrinsics.checkParameterIsNotNull((Object)queryTracker, (String)"queryTracker");
            this.storage = storage;
            this.queryTracker = queryTracker;
            this.shownTimestamp = -1L;
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/stats/completion/CompletionQualityTracker$CompletionQualityListener$FinishType;", "", "(Ljava/lang/String;I)V", "TYPED", "EXPLICIT", "CANCELED_EXPLICITLY", "CANCELED_BY_TYPING", "intellij.statsCollector"})
        private static final class FinishType
        extends Enum<FinishType> {
            public static final /* enum */ FinishType TYPED;
            public static final /* enum */ FinishType EXPLICIT;
            public static final /* enum */ FinishType CANCELED_EXPLICITLY;
            public static final /* enum */ FinishType CANCELED_BY_TYPING;
            private static final /* synthetic */ FinishType[] $VALUES;

            static {
                FinishType[] finishTypeArray = new FinishType[4];
                FinishType[] finishTypeArray2 = finishTypeArray;
                finishTypeArray[0] = TYPED = new FinishType();
                finishTypeArray[1] = EXPLICIT = new FinishType();
                finishTypeArray[2] = CANCELED_EXPLICITLY = new FinishType();
                finishTypeArray[3] = CANCELED_BY_TYPING = new FinishType();
                $VALUES = finishTypeArray;
            }

            public static FinishType[] values() {
                return (FinishType[])$VALUES.clone();
            }

            public static FinishType valueOf(String string) {
                return Enum.valueOf(FinishType.class, string);
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/stats/completion/CompletionQualityTracker$Companion;", "", "()V", "GROUP_ID", "", "intellij.statsCollector"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

