/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml;

import com.intellij.codeInsight.completion.ml.MLFeatureValue;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/intellij/completion/ml/MLFeaturesUtil;", "", "()V", "getClassNameSafe", "", "feature", "Lcom/intellij/codeInsight/completion/ml/MLFeatureValue$ClassNameValue;", "valueAsString", "featureValue", "Lcom/intellij/codeInsight/completion/ml/MLFeatureValue;", "intellij.statsCollector"})
public final class MLFeaturesUtil {
    public static final MLFeaturesUtil INSTANCE;

    @NotNull
    public final String valueAsString(@NotNull MLFeatureValue featureValue) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)featureValue, (String)"featureValue");
        MLFeatureValue mLFeatureValue = featureValue;
        if (mLFeatureValue instanceof MLFeatureValue.BinaryValue) {
            string = ((MLFeatureValue.BinaryValue)featureValue).getValue().booleanValue() ? "1" : "0";
        } else if (mLFeatureValue instanceof MLFeatureValue.FloatValue) {
            string = String.valueOf(((MLFeatureValue.FloatValue)featureValue).getValue());
        } else if (mLFeatureValue instanceof MLFeatureValue.CategoricalValue) {
            string = ((MLFeatureValue.CategoricalValue)featureValue).getValue();
        } else if (mLFeatureValue instanceof MLFeatureValue.ClassNameValue) {
            string = this.getClassNameSafe((MLFeatureValue.ClassNameValue)featureValue);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private final String getClassNameSafe(MLFeatureValue.ClassNameValue feature) {
        String string;
        Class clazz = feature.getValue();
        if (PluginInfoDetectorKt.getPluginInfo((Class)clazz).isSafeToReport()) {
            String string2 = clazz.getName();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"clazz.name");
        } else {
            string = "third.party";
        }
        return string;
    }

    private MLFeaturesUtil() {
    }

    static {
        MLFeaturesUtil mLFeaturesUtil;
        INSTANCE = mLFeaturesUtil = new MLFeaturesUtil();
    }
}

