/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serialization;

import com.intellij.serialization.ArrayBinding;
import com.intellij.serialization.BeanBinding;
import com.intellij.serialization.Binding;
import com.intellij.serialization.BindingInitializationContext;
import com.intellij.serialization.BindingProducer;
import com.intellij.serialization.ClassUtil;
import com.intellij.serialization.CollectionBinding;
import com.intellij.serialization.EnumBinding;
import com.intellij.serialization.InterfacePropertyBinding;
import com.intellij.serialization.IonBindingProducer;
import com.intellij.serialization.MapBinding;
import com.intellij.serialization.MutableAccessor;
import com.intellij.serialization.NumberAsObjectBinding;
import com.intellij.serialization.PolymorphicBinding;
import com.intellij.serialization.PrimitiveBindingsKt;
import com.intellij.serialization.Property;
import com.intellij.serialization.PropertyAnnotationUtil;
import com.intellij.serialization.PropertyCollector;
import com.intellij.serialization.SerializationException;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.TObjectObjectProcedure;
import java.io.File;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/intellij/serialization/IonBindingProducer;", "Lcom/intellij/serialization/BindingProducer;", "propertyCollector", "Lcom/intellij/serialization/PropertyCollector;", "(Lcom/intellij/serialization/PropertyCollector;)V", "getPropertyCollector", "()Lcom/intellij/serialization/PropertyCollector;", "createRootBinding", "Lcom/intellij/serialization/Binding;", "aClass", "Ljava/lang/Class;", "type", "Ljava/lang/reflect/Type;", "getNestedBinding", "accessor", "Lcom/intellij/serialization/MutableAccessor;", "Companion", "intellij.platform.objectSerializer"})
public final class IonBindingProducer
extends BindingProducer {
    @NotNull
    private final PropertyCollector propertyCollector;
    private static final THashMap<Class<?>, Function1<MutableAccessor, Binding>> classToNestedBindingFactory;
    private static final THashMap<Class<?>, Function0<Binding>> classToRootBindingFactory;
    public static final Companion Companion;

    @Override
    @NotNull
    protected Binding createRootBinding(@Nullable Class<?> aClass, @NotNull Type type) {
        Binding binding;
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Function0 customFactory = (Function0)classToRootBindingFactory.get(aClass);
        if (customFactory != null) {
            return (Binding)customFactory.invoke();
        }
        if (aClass == null) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            Type type2 = genericArrayType.getGenericComponentType();
            if (type2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.reflect.TypeVariable<*>");
            }
            TypeVariable typeVariable = (TypeVariable)type2;
            Type type3 = typeVariable.getBounds()[0];
            if (type3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<*>");
            }
            return new ArrayBinding((Class)type3, (BindingInitializationContext)this);
        }
        if (Collection.class.isAssignableFrom(aClass)) {
            binding = new CollectionBinding((ParameterizedType)type, (BindingInitializationContext)this);
        } else if (Map.class.isAssignableFrom(aClass)) {
            Type[] typeArguments = ((ParameterizedType)type).getActualTypeArguments();
            Type type4 = typeArguments[0];
            Intrinsics.checkExpressionValueIsNotNull((Object)type4, (String)"typeArguments[0]");
            Type type5 = typeArguments[1];
            Intrinsics.checkExpressionValueIsNotNull((Object)type5, (String)"typeArguments[1]");
            binding = new MapBinding(type4, type5, this);
        } else if (aClass.isArray()) {
            Class<?> clazz = aClass.getComponentType();
            Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"aClass.componentType");
            binding = new ArrayBinding(clazz, (BindingInitializationContext)this);
        } else if (aClass.isEnum()) {
            binding = new EnumBinding(aClass);
        } else if (aClass.isInterface() || Modifier.isAbstract(aClass.getModifiers()) || Intrinsics.areEqual(aClass, Object.class)) {
            binding = new PolymorphicBinding(aClass);
        } else if (Number.class.isAssignableFrom(aClass)) {
            binding = new NumberAsObjectBinding();
        } else {
            if (aClass instanceof Proxy) {
                throw (Throwable)new SerializationException(aClass + " class is not supported");
            }
            if (Intrinsics.areEqual(aClass, Class.class)) {
                throw (Throwable)new SerializationException(aClass + " class is not supported");
            }
            binding = new BeanBinding(aClass);
        }
        return binding;
    }

    @Override
    @NotNull
    public Binding getNestedBinding(@NotNull MutableAccessor accessor) {
        Binding binding;
        Intrinsics.checkParameterIsNotNull((Object)accessor, (String)"accessor");
        Type type = accessor.getGenericType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"accessor.genericType");
        Type type2 = type;
        boolean isGenericArray = type2 instanceof GenericArrayType;
        if (isGenericArray) {
            return this.getRootBinding(null, type2);
        }
        Class clazz = ClassUtil.typeToClass((Type)type2);
        Intrinsics.checkExpressionValueIsNotNull((Object)clazz, (String)"ClassUtil.typeToClass(type)");
        Class aClass = clazz;
        Function1 function1 = (Function1)classToNestedBindingFactory.get((Object)aClass);
        if (function1 != null) {
            Function1 function12 = function1;
            boolean bl = false;
            boolean bl2 = false;
            Function1 it = function12;
            boolean bl3 = false;
            return (Binding)it.invoke((Object)accessor);
        }
        if (aClass.isInterface() || Modifier.isAbstract(aClass.getModifiers()) || Intrinsics.areEqual((Object)aClass, Object.class)) {
            Property annotation = (Property)accessor.getAnnotation(Property.class);
            if (annotation == null) {
                return this.getRootBinding(aClass, type2);
            }
            Class<?>[] allowedTypes = PropertyAnnotationUtil.getAllowedClass(annotation);
            Intrinsics.checkExpressionValueIsNotNull(allowedTypes, (String)"allowedTypes");
            Class<?>[] classArray = allowedTypes;
            boolean bl = false;
            if (classArray.length == 0) {
                throw (Throwable)new SerializationException("Allowed types list is empty", (Map)MapsKt.linkedMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"accessor", (Object)accessor)}));
            }
            binding = new InterfacePropertyBinding(allowedTypes);
        } else {
            binding = this.getRootBinding(aClass, type2);
        }
        return binding;
    }

    @Override
    @NotNull
    public PropertyCollector getPropertyCollector() {
        return this.propertyCollector;
    }

    public IonBindingProducer(@NotNull PropertyCollector propertyCollector) {
        Intrinsics.checkParameterIsNotNull((Object)propertyCollector, (String)"propertyCollector");
        this.propertyCollector = propertyCollector;
    }

    static {
        Companion = new Companion(null);
        classToNestedBindingFactory = new THashMap(32, ContainerUtil.identityStrategy());
        classToRootBindingFactory = new THashMap(32, ContainerUtil.identityStrategy());
        classToRootBindingFactory.put(File.class, (Object)Companion.1.INSTANCE);
        classToRootBindingFactory.put(Path.class, (Object)Companion.2.INSTANCE);
        classToRootBindingFactory.put(Date.class, (Object)Companion.3.INSTANCE);
        classToRootBindingFactory.put(byte[].class, (Object)Companion.4.INSTANCE);
        Companion.numberFactory.1 numberFactory2 = Companion.numberFactory.1.INSTANCE;
        classToRootBindingFactory.put(Short.class, (Object)numberFactory2);
        classToRootBindingFactory.put(Integer.class, (Object)numberFactory2);
        classToRootBindingFactory.put(Long.class, (Object)numberFactory2);
        PrimitiveBindingsKt.registerPrimitiveBindings((Map)classToRootBindingFactory, (Map)classToNestedBindingFactory);
        classToRootBindingFactory.forEachEntry((TObjectObjectProcedure)Companion.5.INSTANCE);
    }

    public static final /* synthetic */ THashMap access$getClassToNestedBindingFactory$cp() {
        return classToNestedBindingFactory;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R=\u0010\u0003\u001a1\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012#\u0012!\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0006j\u0002`\f0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\r\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u000b0\u000ej\u0002`\u000f0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/serialization/IonBindingProducer$Companion;", "", "()V", "classToNestedBindingFactory", "Lgnu/trove/THashMap;", "Ljava/lang/Class;", "Lkotlin/Function1;", "Lcom/intellij/serialization/MutableAccessor;", "Lkotlin/ParameterName;", "name", "accessor", "Lcom/intellij/serialization/Binding;", "Lcom/intellij/serialization/NestedBindingFactory;", "classToRootBindingFactory", "Lkotlin/Function0;", "Lcom/intellij/serialization/RootBindingFactory;", "intellij.platform.objectSerializer"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

