/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.startUpPerformanceReporter;

import com.fasterxml.jackson.core.JsonGenerator;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.ActivityImpl;
import com.intellij.diagnostic.startUpPerformanceReporter.ServiceReporterKt;
import com.intellij.diagnostic.startUpPerformanceReporter.StartUpPerformanceReporter;
import com.intellij.diagnostic.startUpPerformanceReporter.ThreadNameManager;
import com.intellij.ide.plugins.ContainerDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.containers.ObjectLongHashMap;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0002\u001a\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a8\u0006\u000f"}, d2={"computeOwnTime", "Lcom/intellij/util/containers/ObjectLongHashMap;", "Lcom/intellij/diagnostic/ActivityImpl;", "allEvents", "", "threadNameManager", "Lcom/intellij/diagnostic/startUpPerformanceReporter/ThreadNameManager;", "isInclusive", "", "otherItem", "item", "writeServiceStats", "", "writer", "Lcom/fasterxml/jackson/core/JsonGenerator;", "intellij.platform.diagnostic"})
public final class ServiceReporterKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ObjectLongHashMap<ActivityImpl> computeOwnTime(@NotNull List<ActivityImpl> allEvents, @NotNull ThreadNameManager threadNameManager) {
        Intrinsics.checkParameterIsNotNull(allEvents, (String)"allEvents");
        Intrinsics.checkParameterIsNotNull((Object)threadNameManager, (String)"threadNameManager");
        ObjectLongHashMap ownDurations = new ObjectLongHashMap();
        THashMap threadToList = new THashMap();
        for (ActivityImpl event : allEvents) {
            Object object;
            void $this$getOrPut$iv;
            Map map = (Map)threadToList;
            String key$iv = threadNameManager.getThreadName(event);
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                boolean bl2 = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((List)object).add(event);
        }
        boolean bl = false;
        List respectedItems = new ArrayList();
        for (List list : threadToList.values()) {
            boolean key$iv = false;
            List list2 = list;
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"list");
            for (ActivityImpl item : (Iterable)list2) {
                void index;
                if (item.getCategory() != ActivityCategory.SERVICE_WAITING) {
                    void i;
                    ActivityImpl otherItem;
                    long totalDuration;
                    long ownDuration = totalDuration = item.getEnd() - item.getStart();
                    respectedItems.clear();
                    if (index > 0 && ((ActivityImpl)list.get((int)(index - true))).getStart() > item.getStart()) {
                        StartUpPerformanceReporter.Companion.getLOG$intellij_platform_diagnostic().error("prev " + ((ActivityImpl)list.get((int)(index - true))).getName() + " start > " + item.getName());
                    }
                    void var14_19 = index + true;
                    int n = list.size();
                    while (var14_19 < n && (otherItem = (ActivityImpl)list.get((int)i)).getEnd() <= item.getEnd()) {
                        if (ServiceReporterKt.isInclusive(otherItem, item)) {
                            boolean bl3;
                            block14: {
                                Iterable $this$any$iv = respectedItems;
                                boolean $i$f$any = false;
                                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                    bl3 = false;
                                } else {
                                    for (Object element$iv : $this$any$iv) {
                                        ActivityImpl it = (ActivityImpl)element$iv;
                                        boolean bl4 = false;
                                        if (!ServiceReporterKt.isInclusive(otherItem, it)) continue;
                                        bl3 = true;
                                        break block14;
                                    }
                                    bl3 = false;
                                }
                            }
                            if (!bl3) {
                                ownDuration -= otherItem.getEnd() - otherItem.getStart();
                                respectedItems.add(otherItem);
                            }
                        }
                        ++i;
                    }
                    if (totalDuration != ownDuration) {
                        ownDurations.put((Object)item, ownDuration);
                    }
                }
                ++index;
            }
        }
        return ownDurations;
    }

    private static final boolean isInclusive(ActivityImpl otherItem, ActivityImpl item) {
        return otherItem.getStart() >= item.getStart() && otherItem.getEnd() <= item.getEnd();
    }

    /*
     * WARNING - void declaration
     */
    public static final void writeServiceStats(@NotNull JsonGenerator writer) {
        void $this$obj$iv;
        Object statItem8;
        void $this$obj$iv2;
        JsonGenerator plugin2;
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\r*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\b\"\u0004\b\u0012\u0010\n\u00a8\u0006\u0013"}, d2={"com/intellij/diagnostic/startUpPerformanceReporter/ServiceReporterKt$writeServiceStats$StatItem", "", "name", "", "(Ljava/lang/String;)V", "app", "", "getApp", "()I", "setApp", "(I)V", "module", "getModule", "setModule", "getName", "()Ljava/lang/String;", "project", "getProject", "setProject", "intellij.platform.diagnostic"})
        public final class StatItem {
            private int app;
            private int project;
            private int module;
            @NotNull
            private final String name;

            public final int getApp() {
                return this.app;
            }

            public final void setApp(int n) {
                this.app = n;
            }

            public final int getProject() {
                return this.project;
            }

            public final void setProject(int n) {
                this.project = n;
            }

            public final int getModule() {
                return this.module;
            }

            public final void setModule(int n) {
                this.module = n;
            }

            @NotNull
            public final String getName() {
                return this.name;
            }

            public StatItem(@NotNull String name) {
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                this.name = name;
            }
        }
        StatItem component = new StatItem("component");
        StatItem service = new StatItem("service");
        List list = PluginManagerCore.getLoadedPlugins();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"PluginManagerCore.getLoadedPlugins()");
        List plugins = list;
        for (JsonGenerator plugin2 : plugins) {
            StatItem statItem2 = service;
            int n = statItem2.getApp();
            JsonGenerator jsonGenerator = plugin2;
            if (jsonGenerator == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.ide.plugins.IdeaPluginDescriptorImpl");
            }
            ContainerDescriptor containerDescriptor = ((IdeaPluginDescriptorImpl)jsonGenerator).getApp();
            Intrinsics.checkExpressionValueIsNotNull((Object)containerDescriptor, (String)"(plugin as IdeaPluginDescriptorImpl).app");
            statItem2.setApp(n + containerDescriptor.getServices().size());
            StatItem statItem3 = service;
            int n2 = statItem3.getProject();
            ContainerDescriptor containerDescriptor2 = ((IdeaPluginDescriptorImpl)plugin2).getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)containerDescriptor2, (String)"plugin.project");
            statItem3.setProject(n2 + containerDescriptor2.getServices().size());
            StatItem statItem4 = service;
            int n3 = statItem4.getModule();
            ContainerDescriptor containerDescriptor3 = ((IdeaPluginDescriptorImpl)plugin2).getModule();
            Intrinsics.checkExpressionValueIsNotNull((Object)containerDescriptor3, (String)"plugin.module");
            statItem4.setModule(n3 + containerDescriptor3.getServices().size());
            StatItem statItem5 = component;
            int n4 = statItem5.getApp();
            ContainerDescriptor containerDescriptor4 = ((IdeaPluginDescriptorImpl)plugin2).getApp();
            Intrinsics.checkExpressionValueIsNotNull((Object)containerDescriptor4, (String)"plugin.app");
            statItem5.setApp(n4 + containerDescriptor4.getComponents().size());
            StatItem statItem6 = component;
            int n5 = statItem6.getProject();
            ContainerDescriptor containerDescriptor5 = ((IdeaPluginDescriptorImpl)plugin2).getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)containerDescriptor5, (String)"plugin.project");
            statItem6.setProject(n5 + containerDescriptor5.getComponents().size());
            StatItem statItem7 = component;
            int n6 = statItem7.getModule();
            ContainerDescriptor containerDescriptor6 = ((IdeaPluginDescriptorImpl)plugin2).getModule();
            Intrinsics.checkExpressionValueIsNotNull((Object)containerDescriptor6, (String)"plugin.module");
            statItem7.setModule(n6 + containerDescriptor6.getComponents().size());
        }
        plugin2 = writer;
        String fieldName$iv = "stats";
        boolean $i$f$obj = false;
        String string = fieldName$iv;
        boolean bl = false;
        boolean bl2 = false;
        String it$iv = string;
        boolean bl3 = false;
        $this$obj$iv2.writeFieldName(it$iv);
        $this$obj$iv2.writeStartObject();
        boolean bl4 = false;
        writer.writeNumberField("plugin", plugins.size());
        for (Object statItem8 : CollectionsKt.listOf((Object[])new StatItem[]{component, service})) {
            void $this$obj$iv3;
            JsonGenerator jsonGenerator = writer;
            String fieldName$iv2 = ((StatItem)statItem8).getName();
            boolean $i$f$obj2 = false;
            if (fieldName$iv2 != null) {
                String string2;
                boolean bl5 = false;
                boolean bl6 = false;
                String it$iv2 = string2;
                $i$a$-let-JacksonKt$obj$1$iv = false;
                $this$obj$iv3.writeFieldName(it$iv2);
            }
            $this$obj$iv3.writeStartObject();
            boolean bl7 = false;
            writer.writeNumberField("app", ((StatItem)statItem8).getApp());
            writer.writeNumberField("project", ((StatItem)statItem8).getProject());
            writer.writeNumberField("module", ((StatItem)statItem8).getModule());
            $this$obj$iv3.writeEndObject();
        }
        statItem8 = writer;
        String fieldName$iv3 = "loadedClasses";
        boolean $i$f$obj3 = false;
        String string3 = fieldName$iv3;
        boolean bl8 = false;
        boolean bl9 = false;
        String it$iv3 = string3;
        $i$a$-let-JacksonKt$obj$1$iv = false;
        $this$obj$iv.writeFieldName(it$iv3);
        $this$obj$iv.writeStartObject();
        boolean bl10 = false;
        Iterator iterator = plugins.iterator();
        while (iterator.hasNext()) {
            PluginClassLoader classLoader;
            IdeaPluginDescriptor plugin3;
            IdeaPluginDescriptor ideaPluginDescriptor = plugin3 = (IdeaPluginDescriptor)iterator.next();
            if (ideaPluginDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.ide.plugins.IdeaPluginDescriptorImpl");
            }
            ClassLoader classLoader2 = ((IdeaPluginDescriptorImpl)ideaPluginDescriptor).getPluginClassLoader();
            if (!(classLoader2 instanceof PluginClassLoader)) {
                classLoader2 = null;
            }
            if ((PluginClassLoader)classLoader2 == null) {
                continue;
            }
            long classCount = classLoader.getLoadedClassCount();
            if (classCount <= 0L) continue;
            PluginId pluginId = ((IdeaPluginDescriptorImpl)plugin3).getPluginId();
            Intrinsics.checkExpressionValueIsNotNull((Object)pluginId, (String)"plugin.pluginId");
            writer.writeNumberField(pluginId.getIdString(), classCount);
        }
        $this$obj$iv.writeEndObject();
        $this$obj$iv2.writeEndObject();
    }
}

