/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.index;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.SingleEntryIndexer;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.intellij.images.fileTypes.impl.SvgFileType;
import org.intellij.images.util.ImageInfo;
import org.intellij.images.util.ImageInfoReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImageInfoIndex
extends SingleEntryFileBasedIndexExtension<ImageInfo> {
    private static final long ourMaxImageSize = (long)(Registry.get((String)"ide.index.image.max.size").asDouble() * 1024.0 * 1024.0);
    public static final ID<Integer, ImageInfo> INDEX_ID = ID.create((String)"ImageFileInfoIndex");
    private final DataExternalizer<ImageInfo> myValueExternalizer = new DataExternalizer<ImageInfo>(){

        public void save(@NotNull DataOutput out, ImageInfo info) throws IOException {
            if (out == null) {
                1.$$$reportNull$$$0(0);
            }
            DataInputOutputUtil.writeINT((DataOutput)out, (int)info.width);
            DataInputOutputUtil.writeINT((DataOutput)out, (int)info.height);
            DataInputOutputUtil.writeINT((DataOutput)out, (int)info.bpp);
        }

        public ImageInfo read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                1.$$$reportNull$$$0(1);
            }
            return new ImageInfo(DataInputOutputUtil.readINT((DataInput)in), DataInputOutputUtil.readINT((DataInput)in), DataInputOutputUtil.readINT((DataInput)in));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "org/intellij/images/index/ImageInfoIndex$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private final SingleEntryIndexer<ImageInfo> myDataIndexer = new SingleEntryIndexer<ImageInfo>(false){

        protected ImageInfo computeValue(@NotNull FileContent inputData) {
            ImageInfoReader.Info info;
            if (inputData == null) {
                2.$$$reportNull$$$0(0);
            }
            return (info = ImageInfoReader.getInfo(inputData.getContent(), inputData.getFileName())) != null ? new ImageInfo(info.width, info.height, info.bpp) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "org/intellij/images/index/ImageInfoIndex$2", "computeValue"));
        }
    };

    @NotNull
    public ID<Integer, ImageInfo> getName() {
        ID<Integer, ImageInfo> iD = INDEX_ID;
        if (iD == null) {
            ImageInfoIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public SingleEntryIndexer<ImageInfo> getIndexer() {
        SingleEntryIndexer<ImageInfo> singleEntryIndexer = this.myDataIndexer;
        if (singleEntryIndexer == null) {
            ImageInfoIndex.$$$reportNull$$$0(1);
        }
        return singleEntryIndexer;
    }

    @Nullable
    public static ImageInfo getInfo(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            ImageInfoIndex.$$$reportNull$$$0(2);
        }
        if (project == null) {
            ImageInfoIndex.$$$reportNull$$$0(3);
        }
        return (ImageInfo)ContainerUtil.getFirstItem(FileBasedIndex.getInstance().getFileData(INDEX_ID, file, project).values());
    }

    @NotNull
    public DataExternalizer<ImageInfo> getValueExternalizer() {
        DataExternalizer<ImageInfo> dataExternalizer = this.myValueExternalizer;
        if (dataExternalizer == null) {
            ImageInfoIndex.$$$reportNull$$$0(4);
        }
        return dataExternalizer;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return new DefaultFileTypeSpecificInputFilter(new FileType[]{ImageFileTypeManager.getInstance().getImageFileType(), SvgFileType.INSTANCE}){

            public boolean acceptInput(@NotNull VirtualFile file) {
                if (file == null) {
                    3.$$$reportNull$$$0(0);
                }
                return file.isInLocalFileSystem() && file.getLength() < ourMaxImageSize;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/intellij/images/index/ImageInfoIndex$3", "acceptInput"));
            }
        };
    }

    public int getVersion() {
        return 8;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/images/index/ImageInfoIndex";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/images/index/ImageInfoIndex";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

