/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.update;

import com.intellij.DynamicBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.FilePathUtil;
import org.jetbrains.idea.svn.NestedCopyType;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.branchConfig.SelectBranchPopup;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationManager;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.dialogs.SelectLocationDialog;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnRepositoryLocation;
import org.jetbrains.idea.svn.update.SvnPanel;
import org.jetbrains.idea.svn.update.SvnSelectRevisionUtil;
import org.jetbrains.idea.svn.update.UpdateRootInfo;

public class SvnUpdateRootOptionsPanel
implements SvnPanel {
    private static final Logger LOG = Logger.getInstance(SvnUpdateRootOptionsPanel.class);
    private TextFieldWithBrowseButton myURLText;
    private JCheckBox myRevisionBox;
    private TextFieldWithBrowseButton myRevisionText;
    private final SvnVcs myVcs;
    private JPanel myPanel;
    private final FilePath myRoot;
    private JCheckBox myUpdateToSpecificUrl;
    private TextFieldWithBrowseButton myBranchField;
    private JLabel myBranchLabel;
    private JLabel myUrlLabel;
    private JLabel myCopyType;
    @Nullable
    private Url mySourceUrl;

    public SvnUpdateRootOptionsPanel(FilePath root, SvnVcs vcs, Collection<FilePath> roots) {
        this.myRoot = root;
        this.myVcs = vcs;
        this.$$$setupUI$$$();
        this.myURLText.setEditable(true);
        this.myURLText.addActionListener(e -> this.chooseUrl());
        this.myBranchField.setEditable(false);
        this.myBranchField.addActionListener(e -> this.chooseBranch());
        this.myBranchLabel.setLabelFor((Component)this.myBranchField);
        this.myUrlLabel.setLabelFor((Component)this.myURLText);
        this.myUpdateToSpecificUrl.addActionListener(e -> {
            if (this.myUpdateToSpecificUrl.isSelected()) {
                this.myURLText.setEnabled(true);
                this.myBranchField.setEnabled(this.mySourceUrl != null);
            } else {
                this.myURLText.setEnabled(false);
                this.myBranchField.setEnabled(false);
            }
        });
        this.myRevisionBox.addActionListener(e -> {
            if (e.getSource() == this.myRevisionBox) {
                this.myRevisionText.setEnabled(this.myRevisionBox.isSelected());
                if (this.myRevisionBox.isSelected()) {
                    if (this.myRevisionText.getText().trim().isEmpty()) {
                        this.myRevisionText.setText("HEAD");
                    }
                    this.myRevisionText.getTextField().selectAll();
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myRevisionText, true));
                }
            }
        });
        this.myRevisionText.addActionListener(e -> {
            try {
                SvnRepositoryLocation location = new SvnRepositoryLocation(SvnUtil.createUrl(this.myURLText.getText(), false));
                SvnChangeList repositoryVersion = SvnSelectRevisionUtil.chooseCommittedChangeList(vcs.getProject(), location, this.myRoot.getVirtualFile());
                if (repositoryVersion != null) {
                    this.myRevisionText.setText(String.valueOf(repositoryVersion.getNumber()));
                }
            }
            catch (SvnBindException ex) {
                Messages.showErrorDialog((Project)this.myVcs.getProject(), (String)ex.getMessage(), (String)SvnBundle.message("error.cannot.load.revisions", new Object[0]));
            }
        });
        this.myRevisionText.setText(Revision.HEAD.toString());
        this.myRevisionText.getTextField().selectAll();
        this.myRevisionText.setEnabled(this.myRevisionBox.isSelected());
        this.myURLText.setEnabled(this.myUpdateToSpecificUrl.isSelected());
        this.myBranchField.setEnabled(this.myUpdateToSpecificUrl.isSelected() && this.mySourceUrl != null);
        boolean revisionCanBeSpecifiedForRoot = !FilePathUtil.isNested(roots, this.myRoot) || this.isRevisionCanBeSpecifiedForRoot();
        this.myRevisionBox.setEnabled(revisionCanBeSpecifiedForRoot);
        this.myRevisionText.setEnabled(revisionCanBeSpecifiedForRoot);
        this.myCopyType.setVisible(!revisionCanBeSpecifiedForRoot);
        this.myCopyType.setFont(this.myCopyType.getFont().deriveFont(2));
        this.myUpdateToSpecificUrl.setEnabled(revisionCanBeSpecifiedForRoot);
    }

    private boolean isRevisionCanBeSpecifiedForRoot() {
        RootUrlInfo info2 = this.myVcs.getSvnFileUrlMapping().getWcRootForFilePath(this.myRoot);
        if (info2 != null) {
            boolean isExternalOrSwitched;
            boolean bl = isExternalOrSwitched = NestedCopyType.external.equals((Object)info2.getType()) || NestedCopyType.switched.equals((Object)info2.getType());
            if (isExternalOrSwitched) {
                this.myCopyType.setText(info2.getType().getName() + " copy");
            }
            return !isExternalOrSwitched;
        }
        return true;
    }

    private void chooseBranch() {
        if (this.mySourceUrl == null) {
            this.myBranchField.setEnabled(false);
            return;
        }
        SelectBranchPopup.show(this.myVcs.getProject(), this.myRoot.getVirtualFile(), (project, configuration, url, revision) -> {
            String branchRelativeUrl;
            SvnBranchConfigurationNew branchConfiguration = this.getBranchConfiguration();
            String string = branchRelativeUrl = branchConfiguration != null ? branchConfiguration.getRelativeUrl(this.mySourceUrl) : null;
            if (this.mySourceUrl == null || branchRelativeUrl == null) {
                this.myBranchField.setText("");
            } else {
                try {
                    this.myURLText.setText(url.appendPath(branchRelativeUrl, false).toDecodedString());
                }
                catch (SvnBindException e) {
                    LOG.error((Throwable)((Object)e));
                }
                this.myBranchField.setText(url.getTail());
            }
        }, SvnBundle.message("select.branch.popup.general.title", new Object[0]), this.myPanel);
    }

    private void chooseUrl() {
        try {
            Url url = SvnUtil.createUrl(this.myURLText.getText(), false);
            Url selected = SelectLocationDialog.selectLocation(this.myVcs.getProject(), url);
            if (selected != null) {
                this.myURLText.setText(selected.toDecodedString());
            }
        }
        catch (SvnBindException e) {
            Messages.showErrorDialog((Project)this.myVcs.getProject(), (String)e.getMessage(), (String)SvnBundle.message("dialog.title.select.repository.location", new Object[0]));
        }
    }

    @Override
    public JPanel getPanel() {
        return this.myPanel;
    }

    @Nullable
    private Url getBranchForUrl(@Nullable Url url) {
        RootUrlInfo rootInfo = this.myVcs.getSvnFileUrlMapping().getWcRootForFilePath(this.myRoot);
        return rootInfo != null && url != null ? SvnUtil.getBranchForUrl(this.myVcs, rootInfo.getVirtualFile(), url) : null;
    }

    @Nullable
    private SvnBranchConfigurationNew getBranchConfiguration() {
        RootUrlInfo rootInfo = this.myVcs.getSvnFileUrlMapping().getWcRootForFilePath(this.myRoot);
        return rootInfo != null ? SvnBranchConfigurationManager.getInstance(this.myVcs.getProject()).get(rootInfo.getVirtualFile()) : null;
    }

    @Override
    public void reset(SvnConfiguration configuration) {
        UpdateRootInfo rootInfo = configuration.getUpdateRootInfo(this.myRoot.getIOFile(), this.myVcs);
        this.mySourceUrl = rootInfo.getUrl();
        Url branchUrl = this.getBranchForUrl(this.mySourceUrl);
        if (branchUrl != null) {
            this.myBranchField.setText(branchUrl.getTail());
        }
        this.myURLText.setText(this.mySourceUrl != null ? this.mySourceUrl.toDecodedString() : "");
        this.myRevisionBox.setSelected(rootInfo.isUpdateToRevision());
        this.myRevisionText.setText(rootInfo.getRevision().toString());
        this.myUpdateToSpecificUrl.setSelected(false);
        this.myRevisionText.setEnabled(this.myRevisionBox.isSelected());
        this.myURLText.setEnabled(this.myUpdateToSpecificUrl.isSelected());
        this.myBranchField.setEnabled(this.myUpdateToSpecificUrl.isSelected() && this.mySourceUrl != null);
    }

    @Override
    public void apply(SvnConfiguration configuration) throws ConfigurationException {
        UpdateRootInfo rootInfo = configuration.getUpdateRootInfo(this.myRoot.getIOFile(), this.myVcs);
        if (this.myUpdateToSpecificUrl.isSelected()) {
            try {
                rootInfo.setUrl(SvnUtil.createUrl(this.myURLText.getText(), false));
            }
            catch (SvnBindException e) {
                throw new ConfigurationException("Invalid url: " + this.myURLText.getText());
            }
        }
        rootInfo.setUpdateToRevision(this.myRevisionBox.isSelected());
        Revision revision = Revision.parse(this.myRevisionText.getText());
        if (!revision.isValid()) {
            throw new ConfigurationException(SvnBundle.message("invalid.svn.revision.error.message", this.myRevisionText.getText()));
        }
        rootInfo.setRevision(revision);
    }

    @Override
    public boolean canApply() {
        return true;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JCheckBox jCheckBox;
        JLabel jLabel;
        JLabel jLabel2;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        TextFieldWithBrowseButton textFieldWithBrowseButton3;
        JLabel jLabel3;
        JCheckBox jCheckBox2;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myUpdateToSpecificUrl = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/SvnBundle", SvnUpdateRootOptionsPanel.class).getString("update.configuration.specific.url"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCopyType = jLabel3 = new JLabel();
        jLabel3.setText("");
        jPanel2.add((Component)jLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myURLText = textFieldWithBrowseButton3 = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton3, new GridConstraints(1, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myBranchField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myUrlLabel = jLabel2 = new JLabel();
        jLabel2.setText("URL:");
        jPanel3.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.myBranchLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/SvnBundle", SvnUpdateRootOptionsPanel.class).getString("update.switch.to.branch.text"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myRevisionBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/SvnBundle", SvnUpdateRootOptionsPanel.class).getString("checkbox.update.switch.configurable.to.specific.revision"));
        jPanel4.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myRevisionText = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel4.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, new Dimension(100, -1), new Dimension(100, -1), null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

