/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.diff;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.ClientFactory;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.diff.ElementWithBranchComparer;

public class DirectoryWithBranchComparer
extends ElementWithBranchComparer {
    @NotNull
    private final StringBuilder titleBuilder;
    @NotNull
    private final List<Change> changes;

    public DirectoryWithBranchComparer(@NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull Url branchUrl, long branchRevision) {
        if (project == null) {
            DirectoryWithBranchComparer.$$$reportNull$$$0(0);
        }
        if (virtualFile == null) {
            DirectoryWithBranchComparer.$$$reportNull$$$0(1);
        }
        if (branchUrl == null) {
            DirectoryWithBranchComparer.$$$reportNull$$$0(2);
        }
        super(project, virtualFile, branchUrl, branchRevision);
        this.titleBuilder = new StringBuilder();
        this.changes = new ArrayList<Change>();
    }

    @Override
    protected void compare() throws VcsException {
        this.titleBuilder.append(SvnBundle.message("repository.browser.compare.title", this.myElementUrl.toDecodedString(), FileUtil.toSystemDependentName((String)this.myVirtualFile.getPresentableUrl())));
        Target target1 = Target.on(this.myElementUrl);
        Target target2 = Target.on(VfsUtilCore.virtualToIoFile((VirtualFile)this.myVirtualFile));
        this.changes.addAll(this.getClientFactory().createDiffClient().compare(target1, target2));
    }

    @NotNull
    private ClientFactory getClientFactory() {
        return DirectoryWithBranchComparer.getClientFactory(this.myVcs, VfsUtilCore.virtualToIoFile((VirtualFile)this.myVirtualFile));
    }

    @NotNull
    public static ClientFactory getClientFactory(@NotNull SvnVcs vcs, @NotNull File file) {
        if (vcs == null) {
            DirectoryWithBranchComparer.$$$reportNull$$$0(3);
        }
        if (file == null) {
            DirectoryWithBranchComparer.$$$reportNull$$$0(4);
        }
        ClientFactory clientFactory = vcs.getFactory(file);
        if (clientFactory == null) {
            DirectoryWithBranchComparer.$$$reportNull$$$0(5);
        }
        return clientFactory;
    }

    @Override
    protected void showResult() {
        AbstractVcsHelper.getInstance((Project)this.myProject).showWhatDiffersBrowser(this.changes, this.titleBuilder.toString());
    }

    @Override
    public String getTitle() {
        return SvnBundle.message("progress.computing.difference", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchUrl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/diff/DirectoryWithBranchComparer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/diff/DirectoryWithBranchComparer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getClientFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getClientFactory";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

