/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.auth;

import com.intellij.openapi.project.Project;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.auth.AcceptResult;
import org.jetbrains.idea.svn.auth.AuthenticationData;
import org.jetbrains.idea.svn.auth.AuthenticationProvider;
import org.jetbrains.idea.svn.auth.SvnAuthenticationManager;
import org.jetbrains.idea.svn.auth.SvnAuthenticationNotifier;

public class SvnAuthenticationProvider
implements AuthenticationProvider {
    private final Project myProject;
    private final SvnAuthenticationNotifier myAuthenticationNotifier;
    private final AuthenticationProvider mySvnInteractiveAuthenticationProvider;
    private final SvnAuthenticationManager myAuthenticationManager;

    public SvnAuthenticationProvider(SvnVcs svnVcs, AuthenticationProvider provider, SvnAuthenticationManager authenticationManager) {
        this.myAuthenticationManager = authenticationManager;
        this.myProject = svnVcs.getProject();
        this.myAuthenticationNotifier = svnVcs.getAuthNotifier();
        this.mySvnInteractiveAuthenticationProvider = provider;
    }

    @Override
    public AuthenticationData requestClientAuthentication(String kind, Url url, String realm, boolean canCache) {
        SvnAuthenticationNotifier.AuthenticationRequest obj = new SvnAuthenticationNotifier.AuthenticationRequest(this.myProject, kind, url, realm);
        Url wcUrl = this.myAuthenticationNotifier.getWcUrl(obj);
        if (wcUrl == null) {
            return this.mySvnInteractiveAuthenticationProvider.requestClientAuthentication(kind, url, realm, canCache);
        }
        if (this.myAuthenticationNotifier.ensureNotify(obj)) {
            return this.myAuthenticationManager.requestFromCache(kind, realm);
        }
        return null;
    }

    @Override
    public AcceptResult acceptServerAuthentication(Url url, String realm, Object certificate, boolean canCache) {
        return this.mySvnInteractiveAuthenticationProvider.acceptServerAuthentication(url, realm, certificate, canCache);
    }
}

