/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.VcsAnnotationRefresher;
import com.intellij.util.messages.Topic;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.IdeaSVNConfigFile;
import org.jetbrains.idea.svn.SvnConfigurationState;
import org.jetbrains.idea.svn.SvnServerFileManager;
import org.jetbrains.idea.svn.SvnServerFileManagerImpl;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.auth.AcceptResult;
import org.jetbrains.idea.svn.auth.AuthenticationData;
import org.jetbrains.idea.svn.auth.AuthenticationProvider;
import org.jetbrains.idea.svn.auth.SvnAuthenticationManager;
import org.jetbrains.idea.svn.auth.SvnAuthenticationProvider;
import org.jetbrains.idea.svn.auth.SvnInteractiveAuthenticationProvider;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationManager;
import org.jetbrains.idea.svn.diff.DiffOptions;
import org.jetbrains.idea.svn.update.MergeRootInfo;
import org.jetbrains.idea.svn.update.UpdateRootInfo;

@State(name="SvnConfiguration", storages={@Storage(value="$WORKSPACE_FILE$")})
public class SvnConfiguration
implements PersistentStateComponent<SvnConfigurationState> {
    public static final int ourMaxAnnotateRevisionsDefault = 500;
    private static final long UPGRADE_TO_15_VERSION_ASKED = 123L;
    private static final long CHANGELIST_SUPPORT = 124L;
    private static final long UPGRADE_TO_16_VERSION_ASKED = 125L;
    private final Project myProject;
    @NotNull
    private SvnConfigurationState myState = new SvnConfigurationState();
    private SvnAuthenticationManager myAuthManager;
    private SvnAuthenticationManager myPassiveAuthManager;
    private SvnAuthenticationManager myInteractiveManager;
    public static final AuthStorage RUNTIME_AUTH_CACHE = new AuthStorage();
    private final Map<File, MergeRootInfo> myMergeRootInfos = new HashMap<File, MergeRootInfo>();
    private final Map<File, UpdateRootInfo> myUpdateRootInfos = new HashMap<File, UpdateRootInfo>();
    private SvnInteractiveAuthenticationProvider myInteractiveProvider;
    private IdeaSVNConfigFile myServersFile;
    private IdeaSVNConfigFile myConfigFile;

    @Deprecated
    public boolean isCommandLine() {
        return true;
    }

    @NotNull
    public SvnConfigurationState getState() {
        SvnConfigurationState svnConfigurationState = this.myState;
        if (svnConfigurationState == null) {
            SvnConfiguration.$$$reportNull$$$0(0);
        }
        return svnConfigurationState;
    }

    public void loadState(@NotNull SvnConfigurationState state) {
        if (state == null) {
            SvnConfiguration.$$$reportNull$$$0(1);
        }
        this.myState = state;
    }

    public long getHttpTimeout() {
        String timeout = this.getServersFile().getDefaultGroup().getTimeout();
        try {
            return Long.parseLong(timeout) * 1000L;
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    @NotNull
    public DiffOptions getMergeOptions() {
        return new DiffOptions(this.isIgnoreSpacesInMerge(), this.isIgnoreSpacesInMerge(), this.isIgnoreSpacesInMerge());
    }

    @NotNull
    private IdeaSVNConfigFile getServersFile() {
        if (this.myServersFile == null) {
            this.myServersFile = new IdeaSVNConfigFile(this.getConfigurationPath().resolve("servers"));
        }
        this.myServersFile.updateGroups();
        IdeaSVNConfigFile ideaSVNConfigFile = this.myServersFile;
        if (ideaSVNConfigFile == null) {
            SvnConfiguration.$$$reportNull$$$0(2);
        }
        return ideaSVNConfigFile;
    }

    @NotNull
    public IdeaSVNConfigFile getConfigFile() {
        if (this.myConfigFile == null) {
            this.myConfigFile = new IdeaSVNConfigFile(this.getConfigurationPath().resolve("config"));
        }
        IdeaSVNConfigFile ideaSVNConfigFile = this.myConfigFile;
        if (ideaSVNConfigFile == null) {
            SvnConfiguration.$$$reportNull$$$0(3);
        }
        return ideaSVNConfigFile;
    }

    @NotNull
    public String getSshTunnelSetting() {
        String string = StringUtil.notNullize((String)this.getConfigFile().getValue("tunnels", "ssh"));
        if (string == null) {
            SvnConfiguration.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void setSshTunnelSetting(@Nullable String value) {
        this.getConfigFile().setValue("tunnels", "ssh", value);
        this.getConfigFile().save();
    }

    public void setHttpTimeout(long value) {
        long cut = value / 1000L;
        this.getServersFile().setValue("global", "http-timeout", String.valueOf(cut));
        this.getServersFile().save();
    }

    public static SvnConfiguration getInstance(Project project) {
        return (SvnConfiguration)ServiceManager.getService((Project)project, SvnConfiguration.class);
    }

    public SvnConfiguration(Project project) {
        this.myProject = project;
    }

    public void setIgnoreSpacesInAnnotate(boolean value) {
        boolean changed = this.myState.IGNORE_SPACES_IN_ANNOTATE != value;
        this.myState.IGNORE_SPACES_IN_ANNOTATE = value;
        if (changed) {
            ((VcsAnnotationRefresher)BackgroundTaskUtil.syncPublisher((Project)this.getProject(), (Topic)VcsAnnotationRefresher.LOCAL_CHANGES_CHANGED)).configurationChanged(SvnVcs.getKey());
        }
    }

    public long getSshConnectionTimeout() {
        return this.myState.sshConnectionTimeout;
    }

    public void setSshConnectionTimeout(long sshConnectionTimeout) {
        this.myState.sshConnectionTimeout = sshConnectionTimeout;
    }

    public long getSshReadTimeout() {
        return this.myState.sshReadTimeout;
    }

    public void setSshReadTimeout(long sshReadTimeout) {
        this.myState.sshReadTimeout = sshReadTimeout;
    }

    public Project getProject() {
        return this.myProject;
    }

    public Boolean isKeepNewFilesAsIsForTreeConflictMerge() {
        return this.myState.keepNewFilesAsIsForTreeConflictMerge;
    }

    public void setKeepNewFilesAsIsForTreeConflictMerge(Boolean keepNewFilesAsIsForTreeConflictMerge) {
        this.myState.keepNewFilesAsIsForTreeConflictMerge = keepNewFilesAsIsForTreeConflictMerge;
    }

    public SSLProtocols getSslProtocols() {
        return this.myState.sslProtocols;
    }

    public void setSslProtocols(SSLProtocols sslProtocols) {
        this.myState.sslProtocols = sslProtocols;
    }

    public Depth getUpdateDepth() {
        return this.myState.UPDATE_DEPTH;
    }

    public void setUpdateDepth(Depth updateDepth) {
        this.myState.UPDATE_DEPTH = updateDepth;
    }

    public boolean isRunUnderTerminal() {
        return this.myState.runUnderTerminal;
    }

    public void setRunUnderTerminal(boolean value) {
        this.myState.runUnderTerminal = value;
    }

    public boolean isIgnoreExternals() {
        return this.myState.IGNORE_EXTERNALS;
    }

    public void setIgnoreExternals(boolean ignoreExternals) {
        this.myState.IGNORE_EXTERNALS = ignoreExternals;
    }

    public boolean isMergeDryRun() {
        return this.myState.MERGE_DRY_RUN;
    }

    public void setMergeDryRun(boolean mergeDryRun) {
        this.myState.MERGE_DRY_RUN = mergeDryRun;
    }

    public boolean isMergeDiffUseAncestry() {
        return this.myState.MERGE_DIFF_USE_ANCESTRY;
    }

    public void setMergeDiffUseAncestry(boolean mergeDiffUseAncestry) {
        this.myState.MERGE_DIFF_USE_ANCESTRY = mergeDiffUseAncestry;
    }

    public boolean isIgnoreSpacesInMerge() {
        return this.myState.IGNORE_SPACES_IN_MERGE;
    }

    public void setIgnoreSpacesInMerge(boolean ignoreSpacesInMerge) {
        this.myState.IGNORE_SPACES_IN_MERGE = ignoreSpacesInMerge;
    }

    public boolean isCheckNestedForQuickMerge() {
        return this.myState.CHECK_NESTED_FOR_QUICK_MERGE;
    }

    public void setCheckNestedForQuickMerge(boolean checkNestedForQuickMerge) {
        this.myState.CHECK_NESTED_FOR_QUICK_MERGE = checkNestedForQuickMerge;
    }

    public boolean isIgnoreSpacesInAnnotate() {
        return this.myState.IGNORE_SPACES_IN_ANNOTATE;
    }

    public boolean isShowMergeSourcesInAnnotate() {
        return this.myState.SHOW_MERGE_SOURCES_IN_ANNOTATE;
    }

    public void setShowMergeSourcesInAnnotate(boolean showMergeSourcesInAnnotate) {
        this.myState.SHOW_MERGE_SOURCES_IN_ANNOTATE = showMergeSourcesInAnnotate;
    }

    public boolean isForceUpdate() {
        return this.myState.FORCE_UPDATE;
    }

    public void setForceUpdate(boolean forceUpdate) {
        this.myState.FORCE_UPDATE = forceUpdate;
    }

    private static Long fixSupportedVersion(Long version) {
        return version == null || version < 124L ? 123L : version;
    }

    public boolean changeListsSynchronized() {
        this.ensureSupportedVersion();
        return this.myState.supportedVersion != null && this.myState.supportedVersion >= 124L;
    }

    public void upgrade() {
        this.myState.supportedVersion = 125L;
    }

    private void ensureSupportedVersion() {
        if (this.myState.supportedVersion == null) {
            this.myState.supportedVersion = SvnConfiguration.fixSupportedVersion(SvnBranchConfigurationManager.getInstance(this.myProject).getSupportValue());
        }
    }

    public String getConfigurationDirectory() {
        if (this.myState.directory.path == null || this.isUseDefaultConfiguration()) {
            this.myState.directory.path = ((Path)SvnUtil.USER_CONFIGURATION_PATH.getValue()).toString();
        }
        return this.myState.directory.path;
    }

    @NotNull
    public Path getConfigurationPath() {
        Path path = Paths.get(this.getConfigurationDirectory(), new String[0]);
        if (path == null) {
            SvnConfiguration.$$$reportNull$$$0(5);
        }
        return path;
    }

    public boolean isUseDefaultConfiguration() {
        return this.myState.directory.useDefault;
    }

    public void setConfigurationDirParameters(boolean newUseDefault, String newConfigurationDirectory) {
        boolean usageChanged;
        boolean directoryChanged;
        String defaultPath = ((Path)SvnUtil.USER_CONFIGURATION_PATH.getValue()).toString();
        String oldEffectivePath = this.isUseDefaultConfiguration() ? defaultPath : this.getConfigurationDirectory();
        String newEffectivePath = newUseDefault ? defaultPath : newConfigurationDirectory;
        boolean bl = directoryChanged = !Comparing.equal((String)this.getConfigurationDirectory(), (String)newConfigurationDirectory);
        if (directoryChanged) {
            this.myState.directory.path = newConfigurationDirectory;
        }
        boolean bl2 = usageChanged = this.isUseDefaultConfiguration() != newUseDefault;
        if (usageChanged) {
            this.setUseDefaultConfiguration(newUseDefault);
        }
        if ((directoryChanged || usageChanged) && !Comparing.equal((String)oldEffectivePath, (String)newEffectivePath)) {
            this.clear();
        }
    }

    public void clear() {
        this.myAuthManager = null;
        this.myPassiveAuthManager = null;
        this.myInteractiveManager = null;
        this.myInteractiveProvider = null;
        RUNTIME_AUTH_CACHE.clear();
    }

    private void setUseDefaultConfiguration(boolean useDefault) {
        this.myState.directory.useDefault = useDefault;
    }

    public SvnAuthenticationManager getAuthenticationManager(@NotNull SvnVcs svnVcs) {
        if (svnVcs == null) {
            SvnConfiguration.$$$reportNull$$$0(6);
        }
        if (this.myAuthManager == null) {
            this.myAuthManager = new SvnAuthenticationManager(svnVcs, this.getConfigurationPath());
            Disposer.register((Disposable)svnVcs.getProject(), () -> {
                this.myAuthManager = null;
            });
            this.getInteractiveManager(svnVcs);
            this.myAuthManager.setAuthenticationProvider(new SvnAuthenticationProvider(svnVcs, this.myInteractiveProvider, this.myAuthManager));
        }
        return this.myAuthManager;
    }

    public SvnAuthenticationManager getPassiveAuthenticationManager(@NotNull SvnVcs svnVcs) {
        if (svnVcs == null) {
            SvnConfiguration.$$$reportNull$$$0(7);
        }
        if (this.myPassiveAuthManager == null) {
            this.myPassiveAuthManager = new SvnAuthenticationManager(svnVcs, this.getConfigurationPath());
            this.myPassiveAuthManager.setAuthenticationProvider(new AuthenticationProvider(){

                @Override
                public AuthenticationData requestClientAuthentication(String kind, Url url, String realm, boolean canCache) {
                    return null;
                }

                @Override
                public AcceptResult acceptServerAuthentication(Url url, String realm, Object certificate, boolean canCache) {
                    return AcceptResult.REJECTED;
                }
            });
        }
        return this.myPassiveAuthManager;
    }

    public SvnAuthenticationManager getInteractiveManager(@NotNull SvnVcs svnVcs) {
        if (svnVcs == null) {
            SvnConfiguration.$$$reportNull$$$0(8);
        }
        if (this.myInteractiveManager == null) {
            this.myInteractiveManager = new SvnAuthenticationManager(svnVcs, this.getConfigurationPath());
            this.myInteractiveProvider = new SvnInteractiveAuthenticationProvider(svnVcs, this.myInteractiveManager);
            this.myInteractiveManager.setAuthenticationProvider(this.myInteractiveProvider);
        }
        return this.myInteractiveManager;
    }

    public void getServerFilesManagers(Ref<SvnServerFileManager> systemManager, Ref<SvnServerFileManager> userManager) {
        systemManager.set((Object)new SvnServerFileManagerImpl(new IdeaSVNConfigFile(((Path)SvnUtil.SYSTEM_CONFIGURATION_PATH.getValue()).resolve("servers"))));
        userManager.set((Object)new SvnServerFileManagerImpl(this.getServersFile()));
    }

    public boolean isAutoUpdateAfterCommit() {
        return this.myState.autoUpdateAfterCommit;
    }

    public void setAutoUpdateAfterCommit(boolean autoUpdateAfterCommit) {
        this.myState.autoUpdateAfterCommit = autoUpdateAfterCommit;
    }

    public boolean isKeepLocks() {
        return this.myState.keepLocks;
    }

    public void setKeepLocks(boolean keepLocks) {
        this.myState.keepLocks = keepLocks;
    }

    public boolean isUseDefaultProxy() {
        return this.myState.useDefaultProxy;
    }

    public void setUseDefaultProxy(boolean isUseDefaultProxy) {
        this.myState.useDefaultProxy = isUseDefaultProxy;
    }

    @NotNull
    public MergeRootInfo getMergeRootInfo(File file, SvnVcs svnVcs) {
        if (!this.myMergeRootInfos.containsKey(file)) {
            this.myMergeRootInfos.put(file, new MergeRootInfo(file, svnVcs));
        }
        MergeRootInfo mergeRootInfo = this.myMergeRootInfos.get(file);
        if (mergeRootInfo == null) {
            SvnConfiguration.$$$reportNull$$$0(9);
        }
        return mergeRootInfo;
    }

    public UpdateRootInfo getUpdateRootInfo(File file, SvnVcs svnVcs) {
        if (!this.myUpdateRootInfos.containsKey(file)) {
            this.myUpdateRootInfos.put(file, new UpdateRootInfo(file, svnVcs));
        }
        return this.myUpdateRootInfos.get(file);
    }

    public Map<File, UpdateRootInfo> getUpdateInfosMap() {
        return Collections.unmodifiableMap(this.myUpdateRootInfos);
    }

    public void acknowledge(@NotNull String kind, @NotNull String realm, @Nullable Object object) {
        if (kind == null) {
            SvnConfiguration.$$$reportNull$$$0(10);
        }
        if (realm == null) {
            SvnConfiguration.$$$reportNull$$$0(11);
        }
        RUNTIME_AUTH_CACHE.putData(kind, realm, object);
    }

    public void clearCredentials(@NotNull String kind, @NotNull String realm) {
        if (kind == null) {
            SvnConfiguration.$$$reportNull$$$0(12);
        }
        if (realm == null) {
            SvnConfiguration.$$$reportNull$$$0(13);
        }
        RUNTIME_AUTH_CACHE.putData(kind, realm, null);
    }

    public void clearRuntimeStorage() {
        RUNTIME_AUTH_CACHE.clear();
    }

    public int getMaxAnnotateRevisions() {
        return this.myState.maxAnnotateRevisions;
    }

    public void setMaxAnnotateRevisions(int maxAnnotateRevisions) {
        this.myState.maxAnnotateRevisions = maxAnnotateRevisions;
    }

    public boolean isCleanupRun() {
        return this.myState.cleanupOnStartRun;
    }

    public void setCleanupRun(boolean cleanupRun) {
        this.myState.cleanupOnStartRun = cleanupRun;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/SvnConfiguration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "svnVcs";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "realm";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/SvnConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getServersFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSshTunnelSetting";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationPath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getMergeRootInfo";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAuthenticationManager";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPassiveAuthenticationManager";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getInteractiveManager";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "acknowledge";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "clearCredentials";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum SshConnectionType {
        PASSWORD,
        PRIVATE_KEY,
        SUBVERSION_CONFIG;

    }

    public static enum SSLProtocols {
        sslv3,
        tlsv1,
        all;

    }

    public static class AuthStorage {
        @NotNull
        private final TreeSet<String> myKeys = new TreeSet();
        @NotNull
        private final Map<String, Object> myStorage = new HashMap<String, Object>();

        @NotNull
        public static String getKey(@NotNull String type, @NotNull String realm) {
            if (type == null) {
                AuthStorage.$$$reportNull$$$0(0);
            }
            if (realm == null) {
                AuthStorage.$$$reportNull$$$0(1);
            }
            String string = type + "$" + realm;
            if (string == null) {
                AuthStorage.$$$reportNull$$$0(2);
            }
            return string;
        }

        public synchronized void clear() {
            this.myStorage.clear();
            this.myKeys.clear();
        }

        public synchronized void putData(@NotNull String kind, @NotNull String realm, @Nullable Object data) {
            if (kind == null) {
                AuthStorage.$$$reportNull$$$0(3);
            }
            if (realm == null) {
                AuthStorage.$$$reportNull$$$0(4);
            }
            String key = AuthStorage.getKey(kind, realm);
            if (data == null) {
                this.myStorage.remove(key);
                this.myKeys.remove(key);
            } else {
                this.myStorage.put(key, data);
                this.myKeys.add(key);
            }
        }

        @Nullable
        public synchronized Object getDataWithLowerCheck(@NotNull String kind, @NotNull String realm) {
            String lowerKey;
            String key;
            Object result;
            if (kind == null) {
                AuthStorage.$$$reportNull$$$0(5);
            }
            if (realm == null) {
                AuthStorage.$$$reportNull$$$0(6);
            }
            if ((result = this.myStorage.get(key = AuthStorage.getKey(kind, realm))) == null && (lowerKey = this.myKeys.lower(key)) != null && key.startsWith(lowerKey)) {
                result = this.myStorage.get(lowerKey);
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "realm";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/svn/SvnConfiguration$AuthStorage";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/svn/SvnConfiguration$AuthStorage";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getKey";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "putData";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getDataWithLowerCheck";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

