/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.UtilBundle;
import com.intellij.openapi.editor.impl.view.FontLayoutService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.changes.issueLinks.LinkMouseListenerBase;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.speedSearch.NameFilteringListModel;
import com.intellij.ui.speedSearch.SpeedSearch;
import com.intellij.util.ContentUtilEx;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.LafIconLookup;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GHLabel;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestRequestedReviewer;
import org.jetbrains.plugins.github.pullrequest.avatars.CachingGithubAvatarIconsProvider;
import org.jetbrains.plugins.github.util.CollectionDelta;
import org.jetbrains.plugins.github.util.GithubAsyncUtilKt;
import org.jetbrains.plugins.github.util.GithubUIUtil;
import org.jetbrains.plugins.github.util.GithubUIUtilKt$sam$com_intellij_openapi_util_Condition$0;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u000234B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u0016\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0018J\u000e\u0010 \u001a\u00020!2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#Jp\u0010%\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H(0'0&\"\u0004\b\u0000\u0010(2\u0006\u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020\u00182$\u0010+\u001a \u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H(0.0-\u0012\n\u0012\b\u0012\u0004\u0012\u0002H(0/0,2\f\u00100\u001a\b\u0012\u0004\u0012\u0002H(012\u0012\u00102\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H(010&R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u00065"}, d2={"Lorg/jetbrains/plugins/github/util/GithubUIUtil;", "", "()V", "avatarSize", "Lcom/intellij/util/ui/JBValue;", "Lorg/jetbrains/annotations/NotNull;", "getAvatarSize", "()Lcom/intellij/util/ui/JBValue;", "createIssueLabelLabel", "Lcom/intellij/ui/components/JBLabel;", "label", "Lorg/jetbrains/plugins/github/api/data/GHLabel;", "createNoteWithAction", "Lcom/intellij/ui/SimpleColoredComponent;", "action", "Lkotlin/Function0;", "", "findAndSelectGitHubContent", "project", "Lcom/intellij/openapi/project/Project;", "select", "", "focusPanel", "panel", "Ljavax/swing/JComponent;", "formatActionDate", "", "date", "Ljava/util/Date;", "getFontEM", "", "component", "getLabelBackground", "Lcom/intellij/ui/JBColor;", "getLabelForeground", "Ljava/awt/Color;", "bg", "showChooserPopup", "Ljava/util/concurrent/CompletableFuture;", "Lorg/jetbrains/plugins/github/util/CollectionDelta;", "T", "popupTitle", "parentComponent", "cellRendererFactory", "Lkotlin/Function1;", "Ljavax/swing/JList;", "Lorg/jetbrains/plugins/github/util/GithubUIUtil$SelectableWrapper;", "Lorg/jetbrains/plugins/github/util/GithubUIUtil$SelectionListCellRenderer;", "currentList", "", "availableListFuture", "SelectableWrapper", "SelectionListCellRenderer", "intellij.vcs.github"})
public final class GithubUIUtil {
    @NotNull
    private static final JBValue avatarSize;
    public static final GithubUIUtil INSTANCE;

    @NotNull
    public final JBValue getAvatarSize() {
        return avatarSize;
    }

    public final void focusPanel(@NotNull JComponent panel2) {
        Intrinsics.checkParameterIsNotNull((Object)panel2, (String)"panel");
        IdeFocusManager ideFocusManager = IdeFocusManager.findInstanceByComponent((Component)panel2);
        Intrinsics.checkExpressionValueIsNotNull((Object)ideFocusManager, (String)"IdeFocusManager.findInstanceByComponent(panel)");
        IdeFocusManager focusManager = ideFocusManager;
        JComponent jComponent = focusManager.getFocusTargetFor(panel2);
        if (jComponent == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)jComponent, (String)"focusManager.getFocusTargetFor(panel) ?: return");
        JComponent toFocus = jComponent;
        focusManager.doWhenFocusSettlesDown(new Runnable(focusManager, toFocus){
            final /* synthetic */ IdeFocusManager $focusManager;
            final /* synthetic */ JComponent $toFocus;

            public final void run() {
                this.$focusManager.requestFocus((Component)this.$toFocus, true);
            }
            {
                this.$focusManager = ideFocusManager;
                this.$toFocus = jComponent;
            }
        });
    }

    @NotNull
    public final JBLabel createIssueLabelLabel(@NotNull GHLabel label) {
        Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
        JBLabel jBLabel = new JBLabel(' ' + label.getName() + ' ', UIUtil.ComponentStyle.SMALL);
        boolean bl = false;
        boolean bl2 = false;
        JBLabel $this$apply = jBLabel;
        boolean bl3 = false;
        $this$apply.setBackground((Color)INSTANCE.getLabelBackground(label));
        Color color = $this$apply.getBackground();
        Intrinsics.checkExpressionValueIsNotNull((Object)color, (String)"background");
        $this$apply.setForeground(INSTANCE.getLabelForeground(color));
        JBLabel jBLabel2 = jBLabel.andOpaque();
        Intrinsics.checkExpressionValueIsNotNull((Object)jBLabel2, (String)"JBLabel(\" ${label.name} \u2026ckground)\n  }.andOpaque()");
        return jBLabel2;
    }

    @NotNull
    public final JBColor getLabelBackground(@NotNull GHLabel label) {
        Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
        Color color = ColorUtil.fromHex((String)label.getColor());
        Intrinsics.checkExpressionValueIsNotNull((Object)color, (String)"ColorUtil.fromHex(label.color)");
        Color apiColor = color;
        return new JBColor(apiColor, ColorUtil.darker((Color)apiColor, (int)3));
    }

    @NotNull
    public final Color getLabelForeground(@NotNull Color bg) {
        Color color;
        Intrinsics.checkParameterIsNotNull((Object)bg, (String)"bg");
        if (ColorUtil.isDark((Color)bg)) {
            Color color2 = Color.white;
            color = color2;
            Intrinsics.checkExpressionValueIsNotNull((Object)color2, (String)"Color.white");
        } else {
            Color color3 = Color.black;
            color = color3;
            Intrinsics.checkExpressionValueIsNotNull((Object)color3, (String)"Color.black");
        }
        return color;
    }

    public final float getFontEM(@NotNull JComponent component2) {
        Intrinsics.checkParameterIsNotNull((Object)component2, (String)"component");
        FontMetrics metrics = component2.getFontMetrics(component2.getFont());
        return FontLayoutService.getInstance().charWidth2D(metrics, 8212);
    }

    @NotNull
    public final String formatActionDate(@NotNull Date date) {
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        String string = DateFormatUtil.formatPrettyDate((Date)date);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"DateFormatUtil.formatPrettyDate(date)");
        String string2 = string;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        String prettyDate = string4;
        String datePrefix = StringsKt.equals((String)prettyDate, (String)UtilBundle.message((String)"date.format.today", (Object[])new Object[0]), (boolean)true) || StringsKt.equals((String)prettyDate, (String)UtilBundle.message((String)"date.format.yesterday", (Object[])new Object[0]), (boolean)true) ? "" : "on ";
        return datePrefix + prettyDate;
    }

    @NotNull
    public final SimpleColoredComponent createNoteWithAction(@NotNull Function0<Unit> action2) {
        Intrinsics.checkParameterIsNotNull(action2, (String)"action");
        SimpleColoredComponent simpleColoredComponent = new SimpleColoredComponent();
        boolean bl = false;
        boolean bl2 = false;
        SimpleColoredComponent $this$apply = simpleColoredComponent;
        boolean bl3 = false;
        $this$apply.setFocusable(true);
        $this$apply.setOpaque(false);
        LinkMouseListenerBase.installSingleTagOn((SimpleColoredComponent)$this$apply);
        $this$apply.registerKeyboardAction(new ActionListener(action2){
            final /* synthetic */ Function0 $action$inlined;
            {
                this.$action$inlined = function0;
            }

            public final void actionPerformed(ActionEvent it) {
                this.$action$inlined.invoke();
            }
        }, KeyStroke.getKeyStroke(10, 0), 0);
        return simpleColoredComponent;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> CompletableFuture<CollectionDelta<T>> showChooserPopup(@NotNull String popupTitle, @NotNull JComponent parentComponent, @NotNull Function1<? super JList<SelectableWrapper<T>>, ? extends SelectionListCellRenderer<T>> cellRendererFactory, @NotNull List<? extends T> currentList, @NotNull CompletableFuture<List<T>> availableListFuture) {
        Collection<SelectableWrapper<void>> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull((Object)popupTitle, (String)"popupTitle");
        Intrinsics.checkParameterIsNotNull((Object)parentComponent, (String)"parentComponent");
        Intrinsics.checkParameterIsNotNull(cellRendererFactory, (String)"cellRendererFactory");
        Intrinsics.checkParameterIsNotNull(currentList, (String)"currentList");
        Intrinsics.checkParameterIsNotNull(availableListFuture, (String)"availableListFuture");
        CollectionListModel listModel = new CollectionListModel((Object[])new SelectableWrapper[0]);
        JBList jBList = new JBList();
        boolean bl = false;
        boolean bl2 = false;
        JBList $this$apply = jBList;
        boolean $i$a$-apply-GithubUIUtil$showChooserPopup$list$22 = false;
        $this$apply.setVisibleRowCount(7);
        $this$apply.setFocusable(false);
        $this$apply.setSelectionMode(0);
        JBList list2 = jBList;
        SelectionListCellRenderer listCellRenderer = (SelectionListCellRenderer)cellRendererFactory.invoke((Object)list2);
        list2.setCellRenderer((ListCellRenderer)listCellRenderer);
        SpeedSearch speedSearch = new SpeedSearch();
        $this$apply = (Function1)new Function1<String, Boolean>(speedSearch){

            public final boolean invoke(String p1) {
                return ((SpeedSearch)this.receiver).shouldBeShowing(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(SpeedSearch.class);
            }

            public final String getName() {
                return "shouldBeShowing";
            }

            public final String getSignature() {
                return "shouldBeShowing(Ljava/lang/String;)Z";
            }
        };
        NameFilteringListModel filteringListModel2 = new NameFilteringListModel((ListModel)listModel, new com.intellij.util.Function<T, String>(listCellRenderer){
            final /* synthetic */ SelectionListCellRenderer $listCellRenderer;

            @NotNull
            public final String fun(SelectableWrapper<T> it) {
                return this.$listCellRenderer.getText(it.getValue());
            }
            {
                this.$listCellRenderer = selectionListCellRenderer;
            }
        }, (Condition)new GithubUIUtilKt$sam$com_intellij_openapi_util_Condition$0((Function1)$this$apply), (Computable)new Computable<String>(speedSearch){
            final /* synthetic */ SpeedSearch $speedSearch;

            @NotNull
            public final String compute() {
                String string = this.$speedSearch.getFilter();
                if (string == null) {
                    string = "";
                }
                return string;
            }
            {
                this.$speedSearch = speedSearch;
            }
        });
        list2.setModel((ListModel)filteringListModel2);
        speedSearch.addChangeListener(new PropertyChangeListener(list2, filteringListModel2, speedSearch){
            final /* synthetic */ JBList $list;
            final /* synthetic */ NameFilteringListModel $filteringListModel;
            final /* synthetic */ SpeedSearch $speedSearch;

            public final void propertyChange(PropertyChangeEvent it) {
                SelectableWrapper prevSelection = (SelectableWrapper)this.$list.getSelectedValue();
                this.$filteringListModel.refilter();
                if (this.$filteringListModel.getSize() > 0) {
                    int fullMatchIndex;
                    int n = fullMatchIndex = this.$speedSearch.isHoldingFilter() ? this.$filteringListModel.getClosestMatchIndex() : this.$filteringListModel.getElementIndex((Object)prevSelection);
                    if (fullMatchIndex != -1) {
                        this.$list.setSelectedIndex(fullMatchIndex);
                    }
                    if (this.$filteringListModel.getSize() <= this.$list.getSelectedIndex() || !this.$filteringListModel.contains(this.$list.getSelectedValue())) {
                        this.$list.setSelectedIndex(0);
                    }
                }
            }
            {
                this.$list = jBList;
                this.$filteringListModel = nameFilteringListModel;
                this.$speedSearch = speedSearch;
            }
        });
        JScrollPane $i$a$-apply-GithubUIUtil$showChooserPopup$list$22 = ScrollPaneFactory.createScrollPane((Component)((Component)list2), (boolean)true);
        boolean bl3 = false;
        boolean bl4 = false;
        JScrollPane $this$apply22 = $i$a$-apply-GithubUIUtil$showChooserPopup$list$22;
        boolean bl5 = false;
        JViewport jViewport = $this$apply22.getViewport();
        Intrinsics.checkExpressionValueIsNotNull((Object)jViewport, (String)"viewport");
        jViewport.setCursor(Cursor.getPredefinedCursor(12));
        $this$apply22.setFocusable(false);
        JScrollPane jScrollPane = $i$a$-apply-GithubUIUtil$showChooserPopup$list$22;
        Intrinsics.checkExpressionValueIsNotNull((Object)jScrollPane, (String)"ScrollPaneFactory.create\u2026isFocusable = false\n    }");
        JScrollPane scrollPane = jScrollPane;
        SearchTextField searchTextField = new SearchTextField(false);
        bl4 = false;
        boolean $this$apply22 = false;
        Object $this$apply3 = searchTextField;
        boolean bl6 = false;
        $this$apply3.setBorder(IdeBorderFactory.createBorder((int)8));
        UIUtil.setBackgroundRecursively((Component)((Component)$this$apply3), (Color)UIUtil.getListBackground());
        JBTextField jBTextField = $this$apply3.getTextEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)jBTextField, (String)"textEditor");
        jBTextField.setBorder((Border)JBUI.Borders.empty());
        $this$apply3.setFocusable(false);
        $this$apply3.addDocumentListener((DocumentListener)new DocumentAdapter((SearchTextField)$this$apply3, speedSearch){
            final /* synthetic */ SearchTextField $this_apply;
            final /* synthetic */ SpeedSearch $speedSearch$inlined;
            {
                this.$this_apply = $receiver;
                this.$speedSearch$inlined = speedSearch;
            }

            protected void textChanged(@NotNull DocumentEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                this.$speedSearch$inlined.updatePattern(this.$this_apply.getText());
            }
        });
        SearchTextField searchField2 = searchTextField;
        BorderLayoutPanel borderLayoutPanel = JBUI.Panels.simplePanel((Component)scrollPane).addToTop((Component)searchField2);
        Intrinsics.checkExpressionValueIsNotNull((Object)borderLayoutPanel, (String)"JBUI.Panels.simplePanel(\u2026ne).addToTop(searchField)");
        BorderLayoutPanel panel2 = borderLayoutPanel;
        ScrollingUtil.installActions((JList)((JList)list2), (JComponent)((JComponent)panel2));
        ListUtil.installAutoSelectOnMouseMove((JList)((JList)list2));
        Function0<Unit> $fun$toggleSelection$2 = new Function0<Unit>(list2){
            final /* synthetic */ JBList $list;

            public final void invoke() {
                Iterator<E> iterator = this.$list.getSelectedValuesList().iterator();
                while (iterator.hasNext()) {
                    SelectableWrapper item;
                    item.setSelected(!(item = (SelectableWrapper)iterator.next()).getSelected());
                }
                this.$list.repaint();
            }
            {
                this.$list = jBList;
                super(0);
            }
        };
        list2.addMouseListener((MouseListener)new MouseAdapter($fun$toggleSelection$2){
            final /* synthetic */ showChooserPopup.2 $toggleSelection$2;

            public void mouseReleased(@NotNull MouseEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                if (UIUtil.isActionClick((MouseEvent)e, (int)502) && !UIUtil.isSelectionButtonDown((MouseEvent)e) && !e.isConsumed()) {
                    this.$toggleSelection$2.invoke();
                }
            }
            {
                this.$toggleSelection$2 = $captured_local_variable$0;
            }
        });
        Set originalSelection = CollectionsKt.toHashSet((Iterable)currentList);
        $this$apply3 = currentList;
        CollectionListModel collectionListModel = listModel;
        boolean $i$f$map = false;
        void var18_27 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl7 = false;
            SelectableWrapper<void> selectableWrapper = new SelectableWrapper<void>(it, true);
            collection.add(selectableWrapper);
        }
        collection = (List)destination$iv$iv;
        collectionListModel.add((List)collection);
        CompletableFuture<CollectionDelta<T>> result = new CompletableFuture<CollectionDelta<T>>();
        JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel2, (JComponent)searchField2).setRequestFocus(true).setCancelOnClickOutside(true).setTitle(popupTitle).setResizable(true).setMovable(true).setKeyboardActions(CollectionsKt.listOf((Object)Pair.create((Object)new ActionListener($fun$toggleSelection$2){
            final /* synthetic */ showChooserPopup.2 $toggleSelection$2;

            public final void actionPerformed(ActionEvent it) {
                this.$toggleSelection$2.invoke();
            }
            {
                this.$toggleSelection$2 = var1_1;
            }
        }, (Object)KeyStroke.getKeyStroke(10, 0)))).addListener(new JBPopupListener(list2, availableListFuture, originalSelection, listCellRenderer, listModel, result){
            final /* synthetic */ JBList $list;
            final /* synthetic */ CompletableFuture $availableListFuture;
            final /* synthetic */ Set $originalSelection;
            final /* synthetic */ SelectionListCellRenderer $listCellRenderer;
            final /* synthetic */ CollectionListModel $listModel;
            final /* synthetic */ CompletableFuture $result;

            public void beforeShown(@NotNull LightweightWindowEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                this.$list.setPaintBusy(true);
                StatusText statusText2 = this.$list.getEmptyText();
                Intrinsics.checkExpressionValueIsNotNull((Object)statusText2, (String)"list.emptyText");
                statusText2.setText("Loading...");
                CompletionStage completionStage = this.$availableListFuture.thenApplyAsync(new Function<T, U>(this){
                    final /* synthetic */ showChooserPopup.6 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final List<SelectableWrapper<T>> apply(List<? extends T> available) {
                        void $this$mapTo$iv$iv;
                        List<? extends T> list2 = available;
                        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"available");
                        Iterable $this$map$iv = list2;
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        Iterator<T> iterator = $this$mapTo$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            void it;
                            T item$iv$iv;
                            T t = item$iv$iv = iterator.next();
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            SelectableWrapper<void> selectableWrapper = new SelectableWrapper<void>(it, this.this$0.$originalSelection.contains(it));
                            collection.add(selectableWrapper);
                        }
                        Iterable iterable2 = (List)destination$iv$iv;
                        Comparator<T> comparator = Comparator.comparing(showChooserPopup.beforeShown.2.INSTANCE).thenComparing(new Function<T, U>(this){
                            final /* synthetic */ showChooserPopup.beforeShown.1 this$0;

                            @NotNull
                            public final String apply(SelectableWrapper<T> it) {
                                return this.this$0.this$0.$listCellRenderer.getText(it.getValue());
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        }, showChooserPopup.beforeShown.4.INSTANCE);
                        Intrinsics.checkExpressionValueIsNotNull(comparator, (String)"Comparator.comparing<Sel\u2026til.compare(a, b, true) }");
                        return CollectionsKt.sortedWith((Iterable)iterable2, comparator);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                Intrinsics.checkExpressionValueIsNotNull((Object)completionStage, (String)"availableListFuture\n    \u2026b, true) })\n            }");
                GithubAsyncUtilKt.successOnEdt(completionStage, (Function1)new Function1<List<? extends SelectableWrapper<T>>, Unit>(this, event){
                    final /* synthetic */ showChooserPopup.6 this$0;
                    final /* synthetic */ LightweightWindowEvent $event;

                    public final void invoke(List<SelectableWrapper<T>> it) {
                        this.this$0.$listModel.replaceAll(it);
                        this.this$0.$list.setPaintBusy(false);
                        StatusText statusText2 = this.this$0.$list.getEmptyText();
                        Intrinsics.checkExpressionValueIsNotNull((Object)statusText2, (String)"list.emptyText");
                        statusText2.setText(UIBundle.message((String)"message.noMatchesFound", (Object[])new Object[0]));
                        this.$event.asPopup().pack(true, true);
                        if (this.this$0.$list.getSelectedIndex() == -1) {
                            this.this$0.$list.setSelectedIndex(0);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$event = lightweightWindowEvent;
                        super(1);
                    }
                });
            }

            /*
             * WARNING - void declaration
             */
            public void onClosed(@NotNull LightweightWindowEvent event) {
                void $this$mapTo$iv$iv;
                SelectableWrapper it;
                Iterable $this$filterTo$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                List list2 = this.$listModel.getItems();
                Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"listModel.items");
                Iterable $this$filter$iv = list2;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (SelectableWrapper)element$iv$iv;
                    boolean bl = false;
                    if (!it.getSelected()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    it = (SelectableWrapper)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    T t = it.getValue();
                    collection.add(t);
                }
                List selected = (List)destination$iv$iv;
                this.$result.complete(new CollectionDelta<T>(this.$originalSelection, selected));
            }
            {
                this.$list = $captured_local_variable$0;
                this.$availableListFuture = $captured_local_variable$1;
                this.$originalSelection = $captured_local_variable$2;
                this.$listCellRenderer = $captured_local_variable$3;
                this.$listModel = $captured_local_variable$4;
                this.$result = $captured_local_variable$5;
            }
        }).createPopup().showUnderneathOf((Component)parentComponent);
        return result;
    }

    public final void findAndSelectGitHubContent(@NotNull Project project, boolean select) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project).getToolWindow("Version Control");
        if (toolWindow == null) {
            return;
        }
        ToolWindow toolWindow2 = toolWindow;
        ContentManager contentManager2 = toolWindow2.getContentManager();
        Intrinsics.checkExpressionValueIsNotNull((Object)contentManager2, (String)"toolWindow.contentManager");
        ContentManager manager = contentManager2;
        JComponent jComponent = ContentUtilEx.findContentComponent((ContentManager)manager, (Condition)findAndSelectGitHubContent.component.1.INSTANCE);
        if (jComponent == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)jComponent, (String)"ContentUtilEx.findConten\u2026Component\n    } ?: return");
        JComponent component2 = jComponent;
        if (select) {
            if (!toolWindow2.isVisible()) {
                toolWindow2.activate(null);
            }
            ContentUtilEx.selectContent((ContentManager)manager, (JComponent)component2, (boolean)true);
        }
    }

    private GithubUIUtil() {
    }

    static {
        GithubUIUtil githubUIUtil;
        INSTANCE = githubUIUtil = new GithubUIUtil();
        JBValue jBValue = JBUI.uiIntValue((String)"Github.Avatar.Size", (int)20);
        Intrinsics.checkExpressionValueIsNotNull((Object)jBValue, (String)"JBUI.uiIntValue(\"Github.Avatar.Size\", 20)");
        avatarSize = jBValue;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000e\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\fJ\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J(\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0011J\u0013\u0010\u0012\u001a\u00020\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/github/util/GithubUIUtil$SelectableWrapper;", "T", "", "value", "selected", "", "(Ljava/lang/Object;Z)V", "getSelected", "()Z", "setSelected", "(Z)V", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "component1", "component2", "copy", "(Ljava/lang/Object;Z)Lorg/jetbrains/plugins/github/util/GithubUIUtil$SelectableWrapper;", "equals", "other", "hashCode", "", "toString", "", "intellij.vcs.github"})
    public static final class SelectableWrapper<T> {
        private final T value;
        private boolean selected;

        public final T getValue() {
            return this.value;
        }

        public final boolean getSelected() {
            return this.selected;
        }

        public final void setSelected(boolean bl) {
            this.selected = bl;
        }

        public SelectableWrapper(T value, boolean selected) {
            this.value = value;
            this.selected = selected;
        }

        public /* synthetic */ SelectableWrapper(Object object, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = false;
            }
            this(object, bl);
        }

        public final T component1() {
            return this.value;
        }

        public final boolean component2() {
            return this.selected;
        }

        @NotNull
        public final SelectableWrapper<T> copy(T value, boolean selected) {
            return new SelectableWrapper<T>(value, selected);
        }

        public static /* synthetic */ SelectableWrapper copy$default(SelectableWrapper selectableWrapper, Object object, boolean bl, int n, Object object2) {
            if ((n & 1) != 0) {
                object = selectableWrapper.value;
            }
            if ((n & 2) != 0) {
                bl = selectableWrapper.selected;
            }
            return selectableWrapper.copy(object, bl);
        }

        @NotNull
        public String toString() {
            return "SelectableWrapper(value=" + this.value + ", selected=" + this.selected + ")";
        }

        public int hashCode() {
            T t = this.value;
            int n = (t != null ? t.hashCode() : 0) * 31;
            int n2 = this.selected ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof SelectableWrapper)) break block3;
                    SelectableWrapper selectableWrapper = (SelectableWrapper)object;
                    if (!Intrinsics.areEqual(this.value, selectableWrapper.value) || this.selected != selectableWrapper.selected) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u00022\u00020\u0004:\u0003\u0019\u001a\u001bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0005J\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\fJD\u0010\r\u001a\u00020\u000e2\u0014\u0010\u000f\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030\u00102\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u0015\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0003\u001c\u001d\u001e\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/plugins/github/util/GithubUIUtil$SelectionListCellRenderer;", "T", "Ljavax/swing/ListCellRenderer;", "Lorg/jetbrains/plugins/github/util/GithubUIUtil$SelectableWrapper;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "()V", "checkIconLabel", "Ljavax/swing/JLabel;", "mainLabel", "getIcon", "Ljavax/swing/Icon;", "value", "(Ljava/lang/Object;)Ljavax/swing/Icon;", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "index", "", "isSelected", "", "cellHasFocus", "getText", "", "(Ljava/lang/Object;)Ljava/lang/String;", "Labels", "PRReviewers", "Users", "Lorg/jetbrains/plugins/github/util/GithubUIUtil$SelectionListCellRenderer$PRReviewers;", "Lorg/jetbrains/plugins/github/util/GithubUIUtil$SelectionListCellRenderer$Users;", "Lorg/jetbrains/plugins/github/util/GithubUIUtil$SelectionListCellRenderer$Labels;", "intellij.vcs.github"})
    public static abstract class SelectionListCellRenderer<T>
    extends BorderLayoutPanel
    implements ListCellRenderer<SelectableWrapper<T>> {
        private final JLabel mainLabel = new JLabel();
        private final JLabel checkIconLabel = new JLabel();

        @Override
        @NotNull
        public Component getListCellRendererComponent(@NotNull JList<? extends SelectableWrapper<T>> list2, @NotNull SelectableWrapper<T> value, int index, boolean isSelected, boolean cellHasFocus) {
            Intrinsics.checkParameterIsNotNull(list2, (String)"list");
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            this.setForeground(UIUtil.getListForeground((boolean)isSelected, (boolean)true));
            this.setBackground(UIUtil.getListBackground((boolean)isSelected, (boolean)true));
            this.mainLabel.setForeground(this.getForeground());
            this.mainLabel.setFont(this.getFont());
            this.mainLabel.setText(this.getText(value.getValue()));
            this.mainLabel.setIcon(this.getIcon(value.getValue()));
            Icon icon = LafIconLookup.getIcon$default((String)"checkmark", (boolean)isSelected, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (int)56, null);
            this.checkIconLabel.setIcon(value.getSelected() ? icon : (Icon)EmptyIcon.create((Icon)icon));
            return (Component)((Object)this);
        }

        @NotNull
        public abstract String getText(T var1);

        @NotNull
        public abstract Icon getIcon(T var1);

        private SelectionListCellRenderer() {
            this.checkIconLabel.setIconTextGap(JBUI.scale((int)4));
            this.checkIconLabel.setBorder((Border)JBUI.Borders.empty((int)0, (int)4));
            this.addToLeft(this.checkIconLabel);
            this.addToCenter(this.mainLabel);
            this.setBorder((Border)JBUI.Borders.empty((int)4, (int)0));
        }

        public /* synthetic */ SelectionListCellRenderer(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/util/GithubUIUtil$SelectionListCellRenderer$PRReviewers;", "Lorg/jetbrains/plugins/github/util/GithubUIUtil$SelectionListCellRenderer;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestRequestedReviewer;", "iconsProvider", "Lorg/jetbrains/plugins/github/pullrequest/avatars/CachingGithubAvatarIconsProvider;", "(Lorg/jetbrains/plugins/github/pullrequest/avatars/CachingGithubAvatarIconsProvider;)V", "getIcon", "Ljavax/swing/Icon;", "value", "getText", "", "intellij.vcs.github"})
        public static final class PRReviewers
        extends SelectionListCellRenderer<GHPullRequestRequestedReviewer> {
            private final CachingGithubAvatarIconsProvider iconsProvider;

            @Override
            @NotNull
            public String getText(@NotNull GHPullRequestRequestedReviewer value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return value.getShortName();
            }

            @Override
            @NotNull
            public Icon getIcon(@NotNull GHPullRequestRequestedReviewer value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return this.iconsProvider.getIcon(value.getAvatarUrl());
            }

            public PRReviewers(@NotNull CachingGithubAvatarIconsProvider iconsProvider) {
                Intrinsics.checkParameterIsNotNull((Object)iconsProvider, (String)"iconsProvider");
                super(null);
                this.iconsProvider = iconsProvider;
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/util/GithubUIUtil$SelectionListCellRenderer$Users;", "Lorg/jetbrains/plugins/github/util/GithubUIUtil$SelectionListCellRenderer;", "Lorg/jetbrains/plugins/github/api/data/GHUser;", "iconsProvider", "Lorg/jetbrains/plugins/github/pullrequest/avatars/CachingGithubAvatarIconsProvider;", "(Lorg/jetbrains/plugins/github/pullrequest/avatars/CachingGithubAvatarIconsProvider;)V", "getIcon", "Ljavax/swing/Icon;", "value", "getText", "", "intellij.vcs.github"})
        public static final class Users
        extends SelectionListCellRenderer<GHUser> {
            private final CachingGithubAvatarIconsProvider iconsProvider;

            @Override
            @NotNull
            public String getText(@NotNull GHUser value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return value.getLogin();
            }

            @Override
            @NotNull
            public Icon getIcon(@NotNull GHUser value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return this.iconsProvider.getIcon(value.getAvatarUrl());
            }

            public Users(@NotNull CachingGithubAvatarIconsProvider iconsProvider) {
                Intrinsics.checkParameterIsNotNull((Object)iconsProvider, (String)"iconsProvider");
                super(null);
                this.iconsProvider = iconsProvider;
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/github/util/GithubUIUtil$SelectionListCellRenderer$Labels;", "Lorg/jetbrains/plugins/github/util/GithubUIUtil$SelectionListCellRenderer;", "Lorg/jetbrains/plugins/github/api/data/GHLabel;", "()V", "getIcon", "Lcom/intellij/util/ui/ColorIcon;", "value", "getText", "", "intellij.vcs.github"})
        public static final class Labels
        extends SelectionListCellRenderer<GHLabel> {
            @Override
            @NotNull
            public String getText(@NotNull GHLabel value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return value.getName();
            }

            @NotNull
            public ColorIcon getIcon(@NotNull GHLabel value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return new ColorIcon(16, ColorUtil.fromHex((String)value.getColor()));
            }

            public Labels() {
                super(null);
            }
        }
    }
}

