/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.ThrowableComputable;
import git4idea.DialogManager;
import java.awt.Component;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccountManager;
import org.jetbrains.plugins.github.authentication.ui.GithubLoginDialog;
import org.jetbrains.plugins.github.util.GithubAccountsMigrationHelper$WhenMappings;
import org.jetbrains.plugins.github.util.GithubAuthData;
import org.jetbrains.plugins.github.util.GithubSettings;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0000\u00a2\u0006\u0002\b\bJ\b\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/github/util/GithubAccountsMigrationHelper;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getOldServer", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "getOldServer$intellij_vcs_github", "hasOldAccount", "", "migrate", "project", "Lcom/intellij/openapi/project/Project;", "parentComponent", "Ljava/awt/Component;", "registerAccount", "", "account", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "token", "", "registerFromDialog", "dialog", "Lorg/jetbrains/plugins/github/authentication/ui/GithubLoginDialog;", "Companion", "intellij.vcs.github"})
public final class GithubAccountsMigrationHelper {
    private final Logger LOG;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final GithubServerPath getOldServer$intellij_vcs_github() {
        try {
            if (this.hasOldAccount()) {
                GithubSettings githubSettings = GithubSettings.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)githubSettings, (String)"GithubSettings.getInstance()");
                String string = githubSettings.getHost();
                if (string == null) {
                    string = "github.com";
                }
                return GithubServerPath.from(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private final boolean hasOldAccount() {
        GithubSettings settings;
        GithubSettings githubSettings = settings = GithubSettings.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)githubSettings, (String)"settings");
        return githubSettings.getAuthType() == GithubAuthData.AuthType.BASIC && settings.getLogin() != null || settings.getAuthType() == GithubAuthData.AuthType.TOKEN;
    }

    @JvmOverloads
    public final boolean migrate(@NotNull Project project, @Nullable Component parentComponent) {
        boolean hasAnyInfo;
        GithubSettings settings;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.LOG.debug("Migrating old auth");
        GithubSettings githubSettings = settings = GithubSettings.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)githubSettings, (String)"settings");
        String login = githubSettings.getLogin();
        String host = settings.getHost();
        String password = PasswordSafe.Companion.getInstance().getPassword(CredentialAttributesKt.CredentialAttributes(GithubSettings.class, (String)"GITHUB_SETTINGS_PASSWORD_KEY"));
        GithubAuthData.AuthType authType = settings.getAuthType();
        this.LOG.debug("Old auth data: { login: " + login + ", host: " + host + ", authType: " + (Object)((Object)authType) + ", password null: " + (password == null) + " }");
        boolean bl = hasAnyInfo = login != null || host != null || authType != null || password != null;
        if (!hasAnyInfo) {
            return true;
        }
        boolean dialogCancelled = false;
        boolean $i$f$service = false;
        Object object = ApplicationManager.getApplication().getService(GithubAccountManager.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ApplicationManager.getAp\u2026getService(T::class.java)");
        if (((GithubAccountManager)object).getAccounts().isEmpty()) {
            String string = host;
            if (string == null) {
                string = "github.com";
            }
            String hostToUse = string;
            GithubAuthData.AuthType authType2 = authType;
            if (authType2 != null) {
                switch (GithubAccountsMigrationHelper$WhenMappings.$EnumSwitchMapping$0[authType2.ordinal()]) {
                    case 1: {
                        this.LOG.debug("Migrating token auth");
                        if (password == null) break;
                        GithubApiRequestExecutor.Factory executorFactory = GithubApiRequestExecutor.Factory.Companion.getInstance();
                        try {
                            String accountName2;
                            GithubServerPath githubServerPath = GithubServerPath.from(hostToUse);
                            Intrinsics.checkExpressionValueIsNotNull((Object)githubServerPath, (String)"GithubServerPath.from(hostToUse)");
                            GithubServerPath server = githubServerPath;
                            ProgressManager progressManager = ProgressManager.getInstance();
                            Intrinsics.checkExpressionValueIsNotNull((Object)progressManager, (String)"ProgressManager.getInstance()");
                            ProgressManager progressManager2 = progressManager;
                            String string2 = accountName2 = (String)progressManager2.runProcessWithProgressSynchronously((ThrowableComputable)new ThrowableComputable<String, IOException>(executorFactory, password, progressManager2, server){
                                final /* synthetic */ GithubApiRequestExecutor.Factory $executorFactory;
                                final /* synthetic */ String $password;
                                final /* synthetic */ ProgressManager $progressManager;
                                final /* synthetic */ GithubServerPath $server;

                                @NotNull
                                public final String compute() {
                                    GithubApiRequestExecutor.WithTokenAuth withTokenAuth = this.$executorFactory.create(this.$password);
                                    ProgressIndicator progressIndicator = this.$progressManager.getProgressIndicator();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)progressIndicator, (String)"progressManager.progressIndicator");
                                    return withTokenAuth.execute(progressIndicator, GithubApiRequests.CurrentUser.get(this.$server)).getLogin();
                                }
                                {
                                    this.$executorFactory = factory2;
                                    this.$password = string;
                                    this.$progressManager = progressManager;
                                    this.$server = githubServerPath;
                                }
                            }, "Accessing GitHub", true, project);
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"accountName");
                            GithubAccount account = GithubAccountManager.Companion.createAccount(string2, server);
                            this.registerAccount(account, password);
                        }
                        catch (Exception e) {
                            this.LOG.debug("Failed to migrate old token-based auth. Showing dialog.", (Throwable)e);
                            GithubLoginDialog dialog2 = new GithubLoginDialog(executorFactory, project, parentComponent, null, null, null, 56, null).withServer(hostToUse, false).withToken(password).withError(e);
                            dialogCancelled = !this.registerFromDialog(dialog2);
                        }
                        break;
                    }
                    case 2: {
                        this.LOG.debug("Migrating basic auth");
                        GithubLoginDialog dialog3 = GithubLoginDialog.withCredentials$default(new GithubLoginDialog(GithubApiRequestExecutor.Factory.Companion.getInstance(), project, parentComponent, null, null, "Password authentication is no longer supported for Github.\nPersonal access token can be acquired instead.", 24, null).withServer(hostToUse, false), login, password, false, 4, null);
                        dialogCancelled = !this.registerFromDialog(dialog3);
                        break;
                    }
                }
            }
        }
        return !dialogCancelled;
    }

    public static /* synthetic */ boolean migrate$default(GithubAccountsMigrationHelper githubAccountsMigrationHelper, Project project, Component component2, int n, Object object) {
        if ((n & 2) != 0) {
            component2 = null;
        }
        return githubAccountsMigrationHelper.migrate(project, component2);
    }

    @JvmOverloads
    public final boolean migrate(@NotNull Project project) {
        return GithubAccountsMigrationHelper.migrate$default(this, project, null, 2, null);
    }

    private final boolean registerFromDialog(GithubLoginDialog dialog2) {
        boolean bl;
        DialogManager.show((DialogWrapper)dialog2);
        if (dialog2.isOK()) {
            this.registerAccount(GithubAccountManager.Companion.createAccount(dialog2.getLogin(), dialog2.getServer()), dialog2.getToken());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final void registerAccount(GithubAccount account, String token) {
        GithubAccountManager accountManager;
        boolean $i$f$service = false;
        Object object = ApplicationManager.getApplication().getService(GithubAccountManager.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ApplicationManager.getAp\u2026getService(T::class.java)");
        GithubAccountManager githubAccountManager = accountManager = (GithubAccountManager)object;
        githubAccountManager.setAccounts(SetsKt.plus(githubAccountManager.getAccounts(), (Object)account));
        accountManager.updateAccountToken(account, token);
        this.LOG.debug("Registered account " + account);
    }

    public GithubAccountsMigrationHelper() {
        Logger logger;
        GithubAccountsMigrationHelper githubAccountsMigrationHelper = this;
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(GithubAccountsMigrationHelper.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"Logger.getInstance(T::class.java)");
        githubAccountsMigrationHelper.LOG = logger = logger2;
    }

    @JvmStatic
    @NotNull
    public static final GithubAccountsMigrationHelper getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/github/util/GithubAccountsMigrationHelper$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/plugins/github/util/GithubAccountsMigrationHelper;", "intellij.vcs.github"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final GithubAccountsMigrationHelper getInstance() {
            boolean $i$f$service = false;
            Object object = ApplicationManager.getApplication().getService(GithubAccountsMigrationHelper.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ApplicationManager.getAp\u2026getService(T::class.java)");
            return (GithubAccountsMigrationHelper)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

