/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.timeline;

import com.intellij.ide.BrowserUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.UI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import javax.swing.Box;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.data.GHActor;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequest;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestShort;
import org.jetbrains.plugins.github.pullrequest.avatars.CachingGithubAvatarIconsProvider;
import org.jetbrains.plugins.github.ui.util.HtmlEditorPane;
import org.jetbrains.plugins.github.ui.util.SingleValueModel;
import org.jetbrains.plugins.github.util.GithubUIUtil;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRHeaderPanel;", "Ljavax/swing/JPanel;", "model", "Lorg/jetbrains/plugins/github/ui/util/SingleValueModel;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestShort;", "avatarIconsProvider", "Lorg/jetbrains/plugins/github/pullrequest/avatars/CachingGithubAvatarIconsProvider;", "(Lorg/jetbrains/plugins/github/ui/util/SingleValueModel;Lorg/jetbrains/plugins/github/pullrequest/avatars/CachingGithubAvatarIconsProvider;)V", "authorAvatar", "Lcom/intellij/ui/components/labels/LinkLabel;", "", "createText", "Lorg/jetbrains/plugins/github/ui/util/HtmlEditorPane;", "descriptionPane", "number", "Lcom/intellij/ui/components/JBLabel;", "title", "Companion", "intellij.vcs.github"})
public final class GHPRHeaderPanel
extends JPanel {
    private final LinkLabel<Object> authorAvatar;
    private final HtmlEditorPane createText;
    private final JBLabel title;
    private final JBLabel number;
    private final HtmlEditorPane descriptionPane;
    private final SingleValueModel<GHPullRequestShort> model;
    public static final Companion Companion = new Companion(null);

    public GHPRHeaderPanel(@NotNull SingleValueModel<GHPullRequestShort> model2, @NotNull CachingGithubAvatarIconsProvider avatarIconsProvider) {
        HtmlEditorPane htmlEditorPane;
        Intrinsics.checkParameterIsNotNull(model2, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)avatarIconsProvider, (String)"avatarIconsProvider");
        this.model = model2;
        GHActor gHActor = this.model.getValue().getAuthor();
        this.authorAvatar = new LinkLabel("", avatarIconsProvider.getIcon(gHActor != null ? gHActor.getAvatarUrl() : null), (LinkListener)new LinkListener<Object>(this){
            final /* synthetic */ GHPRHeaderPanel this$0;

            public final void linkSelected(LinkLabel<Object> $noName_0, Object $noName_1) {
                block0: {
                    Object object = ((GHPullRequestShort)GHPRHeaderPanel.access$getModel$p(this.this$0).getValue()).getAuthor();
                    if (object == null || (object = object.getUrl()) == null) break block0;
                    Object object2 = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object it = object2;
                    boolean bl3 = false;
                    BrowserUtil.browse((String)it);
                }
            }
            {
                this.this$0 = gHPRHeaderPanel;
            }
        });
        GHActor gHActor2 = this.model.getValue().getAuthor();
        StringBuilder stringBuilder = new StringBuilder().append("<a href='").append(gHActor2 != null ? gHActor2.getUrl() : null).append("'>");
        Object object = this.model.getValue().getAuthor();
        if (object == null || (object = object.getLogin()) == null) {
            object = "unknown";
        }
        HtmlEditorPane htmlEditorPane2 = new HtmlEditorPane(stringBuilder.append((String)object).append("</a> ").append("created ").append(GithubUIUtil.INSTANCE.formatActionDate(this.model.getValue().getCreatedAt())).toString());
        GHPRHeaderPanel gHPRHeaderPanel = this;
        boolean bl = false;
        boolean bl2 = false;
        HtmlEditorPane $this$apply = htmlEditorPane2;
        boolean bl3 = false;
        $this$apply.setForeground(UIUtil.getContextHelpForeground());
        gHPRHeaderPanel.createText = htmlEditorPane = htmlEditorPane2;
        htmlEditorPane2 = new JBLabel(UIUtil.ComponentStyle.LARGE);
        gHPRHeaderPanel = this;
        bl = false;
        bl2 = false;
        $this$apply = htmlEditorPane2;
        boolean bl4 = false;
        Font font = $this$apply.getFont();
        Font font2 = $this$apply.getFont();
        Intrinsics.checkExpressionValueIsNotNull((Object)font2, (String)"font");
        $this$apply.setFont(font.deriveFont((float)((double)font2.getSize() * 1.5)));
        htmlEditorPane = htmlEditorPane2;
        gHPRHeaderPanel.title = htmlEditorPane;
        htmlEditorPane2 = new JBLabel(UIUtil.ComponentStyle.LARGE);
        gHPRHeaderPanel = this;
        bl = false;
        bl2 = false;
        $this$apply = htmlEditorPane2;
        boolean bl5 = false;
        Font font3 = $this$apply.getFont();
        Font font4 = $this$apply.getFont();
        Intrinsics.checkExpressionValueIsNotNull((Object)font4, (String)"font");
        $this$apply.setFont(font3.deriveFont((float)((double)font4.getSize() * 1.4)));
        $this$apply.setForeground(UIUtil.getContextHelpForeground());
        htmlEditorPane = htmlEditorPane2;
        gHPRHeaderPanel.number = htmlEditorPane;
        this.descriptionPane = new HtmlEditorPane();
        this.setOpaque(false);
        htmlEditorPane2 = new MigLayout(new LC().gridGap("0", "0").insets("0", "0", "0", "0").fill().noGrid());
        gHPRHeaderPanel = this;
        bl = false;
        bl2 = false;
        $this$apply = htmlEditorPane2;
        boolean bl6 = false;
        $this$apply.setRowConstraints("[]" + UI.scale((int)4) + "[]" + UI.scale((int)8) + "[]");
        htmlEditorPane = htmlEditorPane2;
        gHPRHeaderPanel.setLayout((LayoutManager)((Object)htmlEditorPane));
        this.add((Component)this.authorAvatar, GHPRHeaderPanel.Companion.noGap());
        this.add(Box.createRigidArea((Dimension)new JBDimension(5, 0)), GHPRHeaderPanel.Companion.noGap());
        this.add((Component)this.createText, GHPRHeaderPanel.Companion.noGap().wrap());
        this.add((Component)this.title, GHPRHeaderPanel.Companion.noGap());
        this.add(Box.createRigidArea((Dimension)new JBDimension(10, 0)), GHPRHeaderPanel.Companion.noGap());
        this.add((Component)this.number, GHPRHeaderPanel.Companion.noGap().wrap());
        this.add((Component)this.descriptionPane, new CC().grow().push().minWidth("0"));
        Function0<Unit> $fun$update$2 = new Function0<Unit>(){

            public final void invoke() {
                title.setText(((GHPullRequestShort)model.getValue()).getTitle());
                number.setText("#" + ((GHPullRequestShort)model.getValue()).getNumber());
                HtmlEditorPane htmlEditorPane = descriptionPane;
                Object t = model.getValue();
                if (!(t instanceof GHPullRequest)) {
                    t = null;
                }
                GHPullRequest gHPullRequest = (GHPullRequest)t;
                String string = gHPullRequest != null ? gHPullRequest.getBodyHTML() : null;
                HtmlEditorPane htmlEditorPane2 = htmlEditorPane;
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    string2 = "";
                }
                String string3 = string2;
                htmlEditorPane2.setBody(string3);
            }
        };
        this.model.addValueChangedListener((Function0<Unit>)((Function0)new Function0<Unit>($fun$update$2){
            final /* synthetic */ 2 $update$2;

            public final void invoke() {
                this.$update$2.invoke();
            }
            {
                this.$update$2 = var1_1;
                super(0);
            }
        }));
        $fun$update$2.invoke();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004H\u0002\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRHeaderPanel$Companion;", "", "()V", "noGap", "Lnet/miginfocom/layout/CC;", "kotlin.jvm.PlatformType", "intellij.vcs.github"})
    public static final class Companion {
        private final CC noGap() {
            return new CC().gap(new String[]{"0", "0", "0", "0"});
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

