/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.details.action;

import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.pullrequest.data.GHPRMergeabilityState;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRStateService;
import org.jetbrains.plugins.github.pullrequest.ui.details.action.GHPRMergeAction;
import org.jetbrains.plugins.github.ui.util.SingleValueModel;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B?\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u0004H\u0014J\u0018\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0016R\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/details/action/GHPRRebaseMergeAction;", "Lorg/jetbrains/plugins/github/pullrequest/ui/details/action/GHPRMergeAction;", "busyStateModel", "Lorg/jetbrains/plugins/github/ui/util/SingleValueModel;", "", "errorHandler", "Lkotlin/Function1;", "", "", "mergeabilityModel", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRMergeabilityState;", "stateService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRStateService;", "(Lorg/jetbrains/plugins/github/ui/util/SingleValueModel;Lkotlin/jvm/functions/Function1;Lorg/jetbrains/plugins/github/ui/util/SingleValueModel;Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRStateService;)V", "computeEnabled", "submitMergeTask", "Ljava/util/concurrent/CompletableFuture;", "mergeability", "intellij.vcs.github"})
public final class GHPRRebaseMergeAction
extends GHPRMergeAction {
    private final SingleValueModel<GHPRMergeabilityState> mergeabilityModel;
    private final GHPRStateService stateService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean computeEnabled() {
        if (!super.computeEnabled()) return false;
        GHPRMergeabilityState gHPRMergeabilityState = this.mergeabilityModel.getValue();
        if (gHPRMergeabilityState == null) return false;
        if (!gHPRMergeabilityState.getCanBeRebased()) return false;
        return true;
    }

    @Override
    @Nullable
    public CompletableFuture<Unit> submitMergeTask(@NotNull GHPRMergeabilityState mergeability) {
        Intrinsics.checkParameterIsNotNull((Object)mergeability, (String)"mergeability");
        return this.stateService.rebaseMerge((ProgressIndicator)new EmptyProgressIndicator(), mergeability.getNumber(), mergeability.getHeadRefOid());
    }

    public GHPRRebaseMergeAction(@NotNull SingleValueModel<Boolean> busyStateModel, @NotNull Function1<? super String, Unit> errorHandler, @NotNull SingleValueModel<GHPRMergeabilityState> mergeabilityModel, @NotNull GHPRStateService stateService) {
        Intrinsics.checkParameterIsNotNull(busyStateModel, (String)"busyStateModel");
        Intrinsics.checkParameterIsNotNull(errorHandler, (String)"errorHandler");
        Intrinsics.checkParameterIsNotNull(mergeabilityModel, (String)"mergeabilityModel");
        Intrinsics.checkParameterIsNotNull((Object)stateService, (String)"stateService");
        super("Rebase and Merge", busyStateModel, errorHandler, mergeabilityModel);
        this.mergeabilityModel = mergeabilityModel;
        this.stateService = stateService;
        this.update();
    }
}

