/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.comment.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ui.UI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import icons.GithubIcons;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Utilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestReviewComment;
import org.jetbrains.plugins.github.pullrequest.avatars.GHAvatarIconsProvider;
import org.jetbrains.plugins.github.pullrequest.comment.ui.GHPRReviewCommentComponent;
import org.jetbrains.plugins.github.pullrequest.comment.ui.GHPRReviewCommentModel;
import org.jetbrains.plugins.github.pullrequest.comment.ui.GHPRReviewThreadModel;
import org.jetbrains.plugins.github.pullrequest.comment.ui.GHPRSubmittableTextField;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRReviewServiceAdapter;
import org.jetbrains.plugins.github.ui.InlineIconButton;
import org.jetbrains.plugins.github.ui.util.HtmlEditorPane;
import org.jetbrains.plugins.github.util.GithubAsyncUtilKt;
import org.jetbrains.plugins.github.util.GithubUIUtil;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J \u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J(\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J*\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\b0\u00162\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GHPRReviewCommentComponent;", "", "()V", "calcLines", "", "textPane", "Ljavax/swing/JEditorPane;", "create", "Ljavax/swing/JComponent;", "reviewService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRReviewServiceAdapter;", "thread", "Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GHPRReviewThreadModel;", "comment", "Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GHPRReviewCommentModel;", "avatarIconsProvider", "Lorg/jetbrains/plugins/github/pullrequest/avatars/GHAvatarIconsProvider;", "createDeleteButton", "createEditButton", "editorWrapper", "Lcom/intellij/ui/components/panels/Wrapper;", "factory", "Lkotlin/Function1;", "intellij.vcs.github"})
public final class GHPRReviewCommentComponent {
    public static final GHPRReviewCommentComponent INSTANCE;

    @NotNull
    public final JComponent create(@NotNull GHPRReviewServiceAdapter reviewService, @NotNull GHPRReviewThreadModel thread, @NotNull GHPRReviewCommentModel comment, @NotNull GHAvatarIconsProvider avatarIconsProvider) {
        String string;
        boolean bl;
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)reviewService, (String)"reviewService");
        Intrinsics.checkParameterIsNotNull((Object)thread, (String)"thread");
        Intrinsics.checkParameterIsNotNull((Object)comment, (String)"comment");
        Intrinsics.checkParameterIsNotNull((Object)avatarIconsProvider, (String)"avatarIconsProvider");
        LinkLabel linkLabel = LinkLabel.create((String)"", (Runnable)new Runnable(comment){
            final /* synthetic */ GHPRReviewCommentModel $comment;

            public final void run() {
                block0: {
                    String string = this.$comment.getAuthorLinkUrl();
                    if (string == null) break block0;
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string2;
                    boolean bl3 = false;
                    BrowserUtil.browse((String)it);
                }
            }
            {
                this.$comment = gHPRReviewCommentModel;
            }
        });
        boolean bl2 = false;
        boolean bl3 = false;
        LinkLabel $this$apply2 = linkLabel;
        boolean bl4 = false;
        $this$apply2.setIcon(avatarIconsProvider.getIcon(comment.getAuthorAvatarUrl()));
        $this$apply2.setFocusable(true);
        $this$apply2.putClientProperty((Object)"AuxEditorComponent", (Object)true);
        LinkLabel linkLabel2 = linkLabel;
        Intrinsics.checkExpressionValueIsNotNull((Object)linkLabel2, (String)"LinkLabel.create(\"\") {\n \u2026EXT_PROPERTY, true)\n    }");
        LinkLabel avatarLabel2 = linkLabel2;
        String string3 = comment.getAuthorLinkUrl();
        if (string3 != null) {
            string2 = string3;
            bl3 = false;
            boolean $this$apply2 = false;
            String it22 = string2;
            bl = false;
            string = "href='" + it22 + '\'';
        } else {
            string = null;
        }
        string2 = string;
        bl3 = false;
        String string4 = string2;
        if (string4 == null) {
            string4 = "";
        }
        String href = string4;
        StringBuilder stringBuilder = new StringBuilder().append("<a ").append(href).append('>');
        String string5 = comment.getAuthorUsername();
        if (string5 == null) {
            string5 = "unknown";
        }
        String title = stringBuilder.append(string5).append("</a> commented ").append(GithubUIUtil.INSTANCE.formatActionDate(comment.getDateCreated())).toString();
        HtmlEditorPane $this$apply2 = new HtmlEditorPane(title);
        boolean it22 = false;
        bl = false;
        HtmlEditorPane $this$apply322 = $this$apply2;
        boolean bl5 = false;
        $this$apply322.setForeground(UIUtil.getContextHelpForeground());
        $this$apply322.putClientProperty("AuxEditorComponent", true);
        HtmlEditorPane titlePane = $this$apply2;
        HtmlEditorPane it22 = new HtmlEditorPane(comment.getBody());
        bl = false;
        boolean $this$apply322 = false;
        HtmlEditorPane $this$apply422 = it22;
        boolean bl6 = false;
        $this$apply422.putClientProperty("AuxEditorComponent", true);
        HtmlEditorPane textPane = it22;
        comment.addChangesListener((Function0<Unit>)((Function0)new Function0<Unit>(textPane, comment){
            final /* synthetic */ HtmlEditorPane $textPane;
            final /* synthetic */ GHPRReviewCommentModel $comment;

            public final void invoke() {
                this.$textPane.setBody(this.$comment.getBody());
            }
            {
                this.$textPane = htmlEditorPane;
                this.$comment = gHPRReviewCommentModel;
                super(0);
            }
        }));
        Wrapper editorWrapper = new Wrapper();
        JComponent $this$apply322 = this.createEditButton(reviewService, comment, editorWrapper, textPane);
        boolean $this$apply422 = false;
        boolean bl7 = false;
        JComponent $this$apply5 = $this$apply322;
        boolean bl8 = false;
        $this$apply5.setVisible(comment.getCanBeUpdated());
        JComponent editButton = $this$apply322;
        JComponent $this$apply422 = this.createDeleteButton(reviewService, thread, comment);
        bl7 = false;
        boolean bl9 = false;
        JComponent $this$apply6 = $this$apply422;
        boolean bl10 = false;
        $this$apply6.setVisible(comment.getCanBeDeleted());
        JComponent deleteButton = $this$apply422;
        BorderLayoutPanel borderLayoutPanel = ((BorderLayoutPanel)new BorderLayoutPanel().andTransparent()).addToCenter((Component)textPane).addToBottom((Component)editorWrapper);
        Intrinsics.checkExpressionValueIsNotNull((Object)borderLayoutPanel, (String)"BorderLayoutPanel().andT\u2026ddToBottom(editorWrapper)");
        BorderLayoutPanel contentPanel = borderLayoutPanel;
        JPanel jPanel = new JPanel(null);
        bl9 = false;
        boolean bl11 = false;
        JPanel $this$apply7 = jPanel;
        boolean bl12 = false;
        $this$apply7.setOpaque(false);
        $this$apply7.setLayout((LayoutManager)new MigLayout(new LC().gridGap("0", "0").insets("0", "0", "0", "0").fill(), new AC().gap(String.valueOf(UI.scale((int)8)))));
        $this$apply7.add((Component)avatarLabel2, new CC().pushY());
        $this$apply7.add((Component)titlePane, new CC().minWidth("0").split(3).alignX("left"));
        $this$apply7.add((Component)editButton, new CC().hideMode(3).gapBefore(String.valueOf(UI.scale((int)12))));
        $this$apply7.add((Component)deleteButton, new CC().hideMode(3).gapBefore(String.valueOf(UI.scale((int)8))));
        $this$apply7.add((Component)contentPanel, new CC().newline().skip().grow().push().minWidth("0").minHeight("0"));
        return jPanel;
    }

    private final JComponent createDeleteButton(GHPRReviewServiceAdapter reviewService, GHPRReviewThreadModel thread, GHPRReviewCommentModel comment) {
        Icon icon = GithubIcons.Delete;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"GithubIcons.Delete");
        Icon icon2 = icon;
        Icon icon3 = GithubIcons.DeleteHovered;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon3, (String)"GithubIcons.DeleteHovered");
        Icon hoverIcon = icon3;
        InlineIconButton inlineIconButton = new InlineIconButton(icon2, hoverIcon, null, "Delete", null, 20, null);
        boolean bl = false;
        boolean bl2 = false;
        InlineIconButton $this$apply = inlineIconButton;
        boolean bl3 = false;
        $this$apply.setActionListener(new ActionListener($this$apply, reviewService, comment, thread){
            final /* synthetic */ InlineIconButton $this_apply;
            final /* synthetic */ GHPRReviewServiceAdapter $reviewService$inlined;
            final /* synthetic */ GHPRReviewCommentModel $comment$inlined;
            final /* synthetic */ GHPRReviewThreadModel $thread$inlined;
            {
                this.$this_apply = inlineIconButton;
                this.$reviewService$inlined = gHPRReviewServiceAdapter;
                this.$comment$inlined = gHPRReviewCommentModel;
                this.$thread$inlined = gHPRReviewThreadModel;
            }

            public final void actionPerformed(ActionEvent it) {
                if (Messages.showConfirmationDialog((JComponent)this.$this_apply, (String)"Are you sure you want to delete this comment?", (String)"Delete Comment", (String)Messages.getYesButton(), (String)Messages.getNoButton()) == 0) {
                    this.$reviewService$inlined.deleteComment((ProgressIndicator)new EmptyProgressIndicator(), this.$comment$inlined.getId());
                    this.$thread$inlined.removeComment(this.$comment$inlined);
                }
            }
        });
        return inlineIconButton;
    }

    private final JComponent createEditButton(GHPRReviewServiceAdapter reviewService, GHPRReviewCommentModel comment, Wrapper editorWrapper, JEditorPane textPane) {
        ActionListener action2 = new ActionListener(textPane, reviewService, comment, editorWrapper){
            final /* synthetic */ JEditorPane $textPane;
            final /* synthetic */ GHPRReviewServiceAdapter $reviewService;
            final /* synthetic */ GHPRReviewCommentModel $comment;
            final /* synthetic */ Wrapper $editorWrapper;

            public final void actionPerformed(ActionEvent it) {
                int linesCount = GHPRReviewCommentComponent.access$calcLines(GHPRReviewCommentComponent.INSTANCE, this.$textPane);
                String string = StringUtil.repeatSymbol((char)'\n', (int)(linesCount - 1));
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtil.repeatSymbol('\\n', linesCount - 1)");
                String text = string;
                GHPRSubmittableTextField.Model model2 = new GHPRSubmittableTextField.Model((Function1)new Function1<String, CompletableFuture<Unit>>(this){
                    final /* synthetic */ createEditButton.action.1 this$0;

                    @NotNull
                    public final CompletableFuture<Unit> invoke(@NotNull String newText) {
                        Intrinsics.checkParameterIsNotNull((Object)newText, (String)"newText");
                        return GithubAsyncUtilKt.handleOnEdt(GithubAsyncUtilKt.successOnEdt(this.this$0.$reviewService.updateComment((ProgressIndicator)new EmptyProgressIndicator(), this.this$0.$comment.getId(), newText), (Function1)new Function1<GHPullRequestReviewComment, Boolean>(this){
                            final /* synthetic */ createEditButton.action.model.1 this$0;

                            public final boolean invoke(@NotNull GHPullRequestReviewComment it) {
                                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                return this.this$0.this$0.$comment.update(it);
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        }), (Function2)new Function2<Boolean, Throwable, Unit>(this){
                            final /* synthetic */ createEditButton.action.model.1 this$0;

                            public final void invoke(@Nullable Boolean $noName_0, @Nullable Throwable $noName_1) {
                                this.this$0.this$0.$editorWrapper.setContent(null);
                                this.this$0.this$0.$editorWrapper.revalidate();
                            }
                            {
                                this.this$0 = var1_1;
                                super(2);
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
                Document document = model2.getDocument();
                boolean bl = false;
                boolean bl2 = false;
                Document $this$with = document;
                boolean bl3 = false;
                boolean $i$f$runWriteAction = false;
                ApplicationManager.getApplication().runWriteAction((Computable)new Computable<T>($this$with, this, text){
                    final /* synthetic */ Document $this_with$inlined;
                    final /* synthetic */ createEditButton.action.1 this$0;
                    final /* synthetic */ String $text$inlined;
                    {
                        this.$this_with$inlined = document;
                        this.this$0 = var2_2;
                        this.$text$inlined = string;
                    }

                    public final T compute() {
                        boolean bl = false;
                        this.$this_with$inlined.setText((CharSequence)this.$text$inlined);
                        this.$this_with$inlined.setReadOnly(true);
                        return (T)Unit.INSTANCE;
                    }
                });
                GithubAsyncUtilKt.successOnEdt(this.$reviewService.getCommentMarkdownBody((ProgressIndicator)new EmptyProgressIndicator(), this.$comment.getId()), (Function1)new Function1<String, Unit>($this$with){
                    final /* synthetic */ Document $this_with;

                    public final void invoke(@NotNull String it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        boolean $i$f$runWriteAction = false;
                        ApplicationManager.getApplication().runWriteAction((Computable)new Computable<T>(this, it){
                            final /* synthetic */ createEditButton.action.1.2 this$0;
                            final /* synthetic */ String $it$inlined;
                            {
                                this.this$0 = var1_1;
                                this.$it$inlined = string;
                            }

                            public final T compute() {
                                boolean bl = false;
                                this.this$0.$this_with.setReadOnly(false);
                                this.this$0.$this_with.setText((CharSequence)this.$it$inlined);
                                return (T)Unit.INSTANCE;
                            }
                        });
                    }
                    {
                        this.$this_with = document;
                        super(1);
                    }
                });
                JComponent editor2 = GHPRSubmittableTextField.INSTANCE.create(model2, "Submit", (Function0<Unit>)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ createEditButton.action.1 this$0;

                    public final void invoke() {
                        this.this$0.$editorWrapper.setContent(null);
                        this.this$0.$editorWrapper.revalidate();
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }));
                this.$editorWrapper.setContent(editor2);
                GithubUIUtil.INSTANCE.focusPanel(editor2);
            }
            {
                this.$textPane = jEditorPane;
                this.$reviewService = gHPRReviewServiceAdapter;
                this.$comment = gHPRReviewCommentModel;
                this.$editorWrapper = wrapper;
            }
        };
        Icon icon = AllIcons.General.Inline_edit;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"AllIcons.General.Inline_edit");
        Icon icon2 = icon;
        Icon icon3 = AllIcons.General.Inline_edit_hovered;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon3, (String)"AllIcons.General.Inline_edit_hovered");
        Icon hoverIcon = icon3;
        InlineIconButton inlineIconButton = new InlineIconButton(icon2, hoverIcon, null, "Edit", null, 20, null);
        boolean bl = false;
        boolean bl2 = false;
        InlineIconButton $this$apply = inlineIconButton;
        boolean bl3 = false;
        $this$apply.setActionListener(action2);
        return inlineIconButton;
    }

    private final int calcLines(JEditorPane textPane) {
        int lineCount = 0;
        int offset = 0;
        while (true) {
            try {
                offset = Utilities.getRowEnd(textPane, offset) + 1;
                ++lineCount;
            }
            catch (BadLocationException e) {
                return lineCount;
            }
        }
    }

    @NotNull
    public final Function1<GHPRReviewCommentModel, JComponent> factory(@NotNull GHPRReviewThreadModel thread, @NotNull GHPRReviewServiceAdapter reviewService, @NotNull GHAvatarIconsProvider avatarIconsProvider) {
        Intrinsics.checkParameterIsNotNull((Object)thread, (String)"thread");
        Intrinsics.checkParameterIsNotNull((Object)reviewService, (String)"reviewService");
        Intrinsics.checkParameterIsNotNull((Object)avatarIconsProvider, (String)"avatarIconsProvider");
        return (Function1)new Function1<GHPRReviewCommentModel, JComponent>(reviewService, thread, avatarIconsProvider){
            final /* synthetic */ GHPRReviewServiceAdapter $reviewService;
            final /* synthetic */ GHPRReviewThreadModel $thread;
            final /* synthetic */ GHAvatarIconsProvider $avatarIconsProvider;

            @NotNull
            public final JComponent invoke(@NotNull GHPRReviewCommentModel comment) {
                Intrinsics.checkParameterIsNotNull((Object)comment, (String)"comment");
                return GHPRReviewCommentComponent.INSTANCE.create(this.$reviewService, this.$thread, comment, this.$avatarIconsProvider);
            }
            {
                this.$reviewService = gHPRReviewServiceAdapter;
                this.$thread = gHPRReviewThreadModel;
                this.$avatarIconsProvider = gHAvatarIconsProvider;
                super(1);
            }
        };
    }

    private GHPRReviewCommentComponent() {
    }

    static {
        GHPRReviewCommentComponent gHPRReviewCommentComponent;
        INSTANCE = gHPRReviewCommentComponent = new GHPRReviewCommentComponent();
    }

    public static final /* synthetic */ int access$calcLines(GHPRReviewCommentComponent $this, JEditorPane textPane) {
        return $this.calcLines(textPane);
    }
}

