/*
 * Decompiled with CFR 0.152.
 */
package org.fest.util;

import java.lang.reflect.Array;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.util.Arrays;
import org.fest.util.Preconditions;

public final class Objects {
    public static final int HASH_CODE_PRIME = 31;

    private Objects() {
    }

    public static boolean areEqual(@Nullable Object o1, @Nullable Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o1.equals(o2)) {
            return true;
        }
        return Objects.areEqualArrays(o1, o2);
    }

    private static boolean areEqualArrays(@Nullable Object o1, @Nullable Object o2) {
        if (!Arrays.isArray(o1) || !Arrays.isArray(o2)) {
            return false;
        }
        if (o1 == o2) {
            return true;
        }
        int size = Array.getLength(o1);
        if (Array.getLength(o2) != size) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            Object e2;
            Object e1 = Array.get(o1, i);
            if (Objects.areEqual(e1, e2 = Array.get(o2, i))) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public static String[] namesOf(Class<?> ... types) {
        Preconditions.checkNotNull(types);
        String[] names = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            names[i] = types[i].getName();
        }
        return names;
    }

    public static int hashCodeFor(@Nullable Object o) {
        return o != null ? o.hashCode() : 0;
    }

    @Nullable
    public static <T> T castIfBelongsToType(@Nonnull Object o, @Nonnull Class<T> type) {
        if (o != null && type.isAssignableFrom(o.getClass())) {
            return type.cast(o);
        }
        return null;
    }
}

