/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal.model;

import com.google.common.base.Preconditions;
import com.jediterm.terminal.model.LinesBuffer;
import com.jediterm.terminal.model.TerminalLine;
import com.jediterm.terminal.model.TerminalTextBuffer;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

class ChangeWidthOperation {
    private static final Logger LOG = Logger.getLogger(TerminalTextBuffer.class);
    private final TerminalTextBuffer myTextBuffer;
    private final int myNewWidth;
    private final int myNewHeight;
    private final Map<Point, Point> myTrackingPoints = new HashMap<Point, Point>();
    private final List<TerminalLine> myAllLines = new ArrayList<TerminalLine>();
    private TerminalLine myCurrentLine;
    private int myCurrentLineLength;

    ChangeWidthOperation(@NotNull TerminalTextBuffer textBuffer, int newWidth, int newHeight) {
        this.myTextBuffer = textBuffer;
        this.myNewWidth = newWidth;
        this.myNewHeight = newHeight;
    }

    void addPointToTrack(@NotNull Point original) {
        this.myTrackingPoints.put(new Point(original), null);
    }

    @NotNull
    Point getTrackedPoint(@NotNull Point original) {
        Point result = this.myTrackingPoints.get(new Point(original));
        if (result == null) {
            LOG.warn((Object)("Not tracked point: " + original));
            return original;
        }
        return result;
    }

    void run() {
        int newY;
        int newX;
        List<Point> points;
        int i;
        LinesBuffer historyBuffer = this.myTextBuffer.getHistoryBufferOrBackup();
        for (int i2 = 0; i2 < historyBuffer.getLineCount(); ++i2) {
            TerminalLine line = historyBuffer.getLine(i2);
            this.addLine(line);
        }
        int screenStartInd = this.myAllLines.size() - 1;
        if (this.myCurrentLine == null || this.myCurrentLineLength == this.myNewWidth) {
            ++screenStartInd;
        }
        Preconditions.checkState((screenStartInd >= 0 ? 1 : 0) != 0, (String)"screenStartInd < 0: %d", (int)screenStartInd);
        LinesBuffer screenBuffer = this.myTextBuffer.getScreenBufferOrBackup();
        if (screenBuffer.getLineCount() > this.myTextBuffer.getHeight()) {
            LOG.warn((Object)("Terminal height < screen buffer line count: " + this.myTextBuffer.getHeight() + " < " + screenBuffer.getLineCount()));
        }
        int oldScreenLineCount = Math.min(screenBuffer.getLineCount(), this.myTextBuffer.getHeight());
        for (i = 0; i < oldScreenLineCount; ++i) {
            points = this.findPointsAtY(i);
            for (Point point : points) {
                newX = (this.myCurrentLineLength + point.x) % this.myNewWidth;
                newY = this.myAllLines.size() + (this.myCurrentLineLength + point.x) / this.myNewWidth;
                if (this.myCurrentLine != null) {
                    --newY;
                }
                this.myTrackingPoints.put(point, new Point(newX, newY));
            }
            this.addLine(screenBuffer.getLine(i));
        }
        for (i = oldScreenLineCount; i < this.myTextBuffer.getHeight(); ++i) {
            points = this.findPointsAtY(i);
            for (Point point : points) {
                newX = point.x % this.myNewWidth;
                newY = i - oldScreenLineCount + this.myAllLines.size() + point.x / this.myNewWidth;
                this.myTrackingPoints.put(point, new Point(newX, newY));
            }
        }
        int emptyBottomLineCount = this.getEmptyBottomLineCount();
        screenStartInd = Math.max(screenStartInd, this.myAllLines.size() - Math.min(this.myAllLines.size(), this.myNewHeight) - emptyBottomLineCount);
        screenStartInd = Math.min(screenStartInd, this.myAllLines.size() - Math.min(this.myAllLines.size(), this.myNewHeight));
        historyBuffer.clearAll();
        historyBuffer.addLines(this.myAllLines.subList(0, screenStartInd));
        screenBuffer.clearAll();
        screenBuffer.addLines(this.myAllLines.subList(screenStartInd, Math.min(screenStartInd + this.myNewHeight, this.myAllLines.size())));
        for (Map.Entry<Point, Point> entry : this.myTrackingPoints.entrySet()) {
            Point p = entry.getValue();
            if (p != null) {
                p.y -= screenStartInd;
            } else {
                p = new Point(entry.getKey());
                entry.setValue(p);
            }
            p.x = Math.min(this.myNewWidth, Math.max(0, p.x));
            p.y = Math.min(this.myNewHeight, Math.max(0, p.y));
        }
    }

    private int getEmptyBottomLineCount() {
        int result;
        for (result = 0; result < this.myAllLines.size() && this.myAllLines.get(this.myAllLines.size() - result - 1).isNul(); ++result) {
        }
        return result;
    }

    @NotNull
    private List<Point> findPointsAtY(int y) {
        List<Point> result = Collections.emptyList();
        for (Point key : this.myTrackingPoints.keySet()) {
            if (key.y != y) continue;
            if (result.isEmpty()) {
                result = new ArrayList<Point>();
            }
            result.add(key);
        }
        return result;
    }

    private void addLine(@NotNull TerminalLine line) {
        if (line.isNul()) {
            if (this.myCurrentLine != null) {
                this.myCurrentLine = null;
                this.myCurrentLineLength = 0;
            }
            this.myAllLines.add(TerminalLine.createEmpty());
            return;
        }
        line.forEachEntry(entry -> {
            int len;
            if (entry.isNul()) {
                return;
            }
            for (int entryProcessedLength = 0; entryProcessedLength < entry.getLength(); entryProcessedLength += len) {
                if (this.myCurrentLine != null && this.myCurrentLineLength == this.myNewWidth) {
                    this.myCurrentLine.setWrapped(true);
                    this.myCurrentLine = null;
                    this.myCurrentLineLength = 0;
                }
                if (this.myCurrentLine == null) {
                    this.myCurrentLine = new TerminalLine();
                    this.myCurrentLineLength = 0;
                    this.myAllLines.add(this.myCurrentLine);
                }
                len = Math.min(this.myNewWidth - this.myCurrentLineLength, entry.getLength() - entryProcessedLength);
                TerminalLine.TextEntry newEntry = ChangeWidthOperation.subEntry(entry, entryProcessedLength, len);
                this.myCurrentLine.appendEntry(newEntry);
                this.myCurrentLineLength += len;
            }
        });
        if (!line.isWrapped()) {
            this.myCurrentLine = null;
            this.myCurrentLineLength = 0;
        }
    }

    @NotNull
    private static TerminalLine.TextEntry subEntry(@NotNull TerminalLine.TextEntry entry, int startInd, int count) {
        if (startInd == 0 && count == entry.getLength()) {
            return entry;
        }
        return new TerminalLine.TextEntry(entry.getStyle(), entry.getText().subBuffer(startInd, count));
    }
}

