/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.intellij.ide.BrowserUtil;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.PyCellUtil;
import com.jetbrains.python.PyCharmProfessionalAdvertiserSettings;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.util.Objects;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyCharmProfessionalAdvertiser
implements Annotator {
    @Language(value="HTML")
    private static final String NOTIFICATIONS_TEXT = "<a href=\"prof\">PyCharm Professional Edition</a> has special support for it.";
    private static final NotificationGroup BALLOON_NOTIFICATIONS = new NotificationGroup("PyCharm Professional Advertiser", NotificationDisplayType.STICKY_BALLOON, false);

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            PyCharmProfessionalAdvertiser.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            PyCharmProfessionalAdvertiser.$$$reportNull$$$0(1);
        }
        Project project = element.getProject();
        if (PyCharmProfessionalAdvertiser.getSettings((Project)project).shown) {
            return;
        }
        if (element instanceof PyFile) {
            PyFile pyFile = (PyFile)element;
            VirtualFile vFile = pyFile.getVirtualFile();
            if (vFile != null && FileIndexFacade.getInstance((Project)project).isInLibraryClasses(vFile)) {
                return;
            }
            if (PyCellUtil.hasCells((PsiFile)pyFile)) {
                PyCharmProfessionalAdvertiser.showInspectionAdvertisement(project, "code cells in the editor", "https://www.jetbrains.com/pycharm/features/scientific_tools.html", "codecells");
            }
            if (PyPsiUtils.containsImport((PyFile)pyFile, (String)"django")) {
                PyCharmProfessionalAdvertiser.showInspectionAdvertisement(project, "the Django Framework", "https://www.jetbrains.com/pycharm/features/web_development.html#django", "django");
            }
            if (PyPsiUtils.containsImport((PyFile)pyFile, (String)"flask")) {
                PyCharmProfessionalAdvertiser.showInspectionAdvertisement(project, "the Flask Framework", null, "flask");
            }
            if (PyPsiUtils.containsImport((PyFile)pyFile, (String)"pyramid")) {
                PyCharmProfessionalAdvertiser.showInspectionAdvertisement(project, "the Pyramid Framework", null, "pyramid");
            }
        }
        if (PyCharmProfessionalAdvertiser.isJupyterFile(element)) {
            PyCharmProfessionalAdvertiser.showInspectionAdvertisement(element.getProject(), "Jupyter notebook", "https://www.jetbrains.com/pycharm/features/scientific_tools.html", "jupyter");
        }
    }

    private static void showInspectionAdvertisement(@NotNull Project project, @NotNull String message, @Nullable String url, @NotNull String source) {
        if (project == null) {
            PyCharmProfessionalAdvertiser.$$$reportNull$$$0(2);
        }
        if (message == null) {
            PyCharmProfessionalAdvertiser.$$$reportNull$$$0(3);
        }
        if (source == null) {
            PyCharmProfessionalAdvertiser.$$$reportNull$$$0(4);
        }
        PyCharmProfessionalAdvertiser.showSingletonNotification(project, "You are using " + message, NOTIFICATIONS_TEXT, NotificationType.INFORMATION, (notification, event) -> {
            if ("prof".equals(event.getDescription())) {
                BrowserUtil.browse((String)((url != null ? url : "https://www.jetbrains.com/pycharm/features/editions_comparison_matrix.html") + "?utm_source=from_product&utm_medium=advertiser&utm_campaign=" + source));
            }
        });
    }

    private static boolean isJupyterFile(@NotNull PsiElement element) {
        if (element == null) {
            PyCharmProfessionalAdvertiser.$$$reportNull$$$0(5);
        }
        if (!(element instanceof PsiFile)) {
            return false;
        }
        VirtualFile virtualFile = ((PsiFile)element).getVirtualFile();
        return virtualFile != null && Objects.equals(virtualFile.getExtension(), "ipynb");
    }

    private static void showSingletonNotification(@NotNull Project project, @NotNull String title, @NotNull String htmlContent, @NotNull NotificationType type, @NotNull NotificationListener listener) {
        if (project == null) {
            PyCharmProfessionalAdvertiser.$$$reportNull$$$0(6);
        }
        if (title == null) {
            PyCharmProfessionalAdvertiser.$$$reportNull$$$0(7);
        }
        if (htmlContent == null) {
            PyCharmProfessionalAdvertiser.$$$reportNull$$$0(8);
        }
        if (type == null) {
            PyCharmProfessionalAdvertiser.$$$reportNull$$$0(9);
        }
        if (listener == null) {
            PyCharmProfessionalAdvertiser.$$$reportNull$$$0(10);
        }
        PyCharmProfessionalAdvertiser.getSettings((Project)project).shown = true;
        BALLOON_NOTIFICATIONS.createNotification(title, htmlContent, type, (notification, event) -> {
            try {
                listener.hyperlinkUpdate(notification, event);
            }
            finally {
                notification.expire();
            }
        }).notify(project);
    }

    @NotNull
    private static PyCharmProfessionalAdvertiserSettings getSettings(@NotNull Project project) {
        if (project == null) {
            PyCharmProfessionalAdvertiser.$$$reportNull$$$0(11);
        }
        PyCharmProfessionalAdvertiserSettings pyCharmProfessionalAdvertiserSettings = (PyCharmProfessionalAdvertiserSettings)ServiceManager.getService((Project)project, PyCharmProfessionalAdvertiserSettings.class);
        if (pyCharmProfessionalAdvertiserSettings == null) {
            PyCharmProfessionalAdvertiser.$$$reportNull$$$0(12);
        }
        return pyCharmProfessionalAdvertiserSettings;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "htmlContent";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/PyCharmProfessionalAdvertiser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/PyCharmProfessionalAdvertiser";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showInspectionAdvertisement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isJupyterFile";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "showSingletonNotification";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSettings";
                break;
            }
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

