/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.fest.util.Lists;
import org.fest.util.Preconditions;
import org.fest.util.Sets;

public final class ArrayInspection {
    private ArrayInspection() {
    }

    @Nonnull
    public static Object[] copy(@Nonnull Object array) {
        return ArrayInspection.copyToList(Preconditions.checkNotNull((Object)array)).toArray();
    }

    @Nonnull
    public static List<Object> copyToList(@Nonnull Object array) {
        return ArrayInspection.copy(Preconditions.checkNotNull((Object)array), Lists.newArrayList());
    }

    @Nonnull
    public static Set<Object> copyToSet(@Nonnull Object array) {
        return ArrayInspection.copy(Preconditions.checkNotNull((Object)array), Sets.newLinkedHashSet());
    }

    @Nonnull
    private static <T extends Collection<Object>> T copy(@Nonnull Object array, @Nonnull T destination) {
        int length = ArrayInspection.sizeOf(array);
        for (int i = 0; i < length; ++i) {
            destination.add((Object)Array.get(array, i));
        }
        return destination;
    }

    public static int sizeOf(@Nonnull Object array) {
        Preconditions.checkNotNull((Object)array);
        ArrayInspection.validateIsArray(array);
        return Array.getLength(array);
    }

    private static void validateIsArray(@Nonnull Object array) {
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException("The given object is not an array");
        }
    }
}

