/*
 * Decompiled with CFR 0.152.
 */
package git4idea.merge;

import com.intellij.diff.DiffEditorTitleCustomizer;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ui.ChangeListViewerDialog;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.util.Consumer;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.VcsCommitMetadataImpl;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.GitBranch;
import git4idea.GitCommit;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitRevisionNumber;
import git4idea.changes.GitChangeUtils;
import git4idea.changes.GitCommittedChangeList;
import git4idea.history.GitLogUtil;
import git4idea.merge.GitDefaultMergeDialogCustomizerKt;
import git4idea.merge.GitDefaultMergeDialogCustomizerKt$sam$java_lang_Runnable$0;
import git4idea.merge.MergeConflictMultipleCommitInfoDialog;
import git4idea.merge.RefInfo;
import git4idea.rebase.GitRebaseUtils;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000V\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a\u001c\u0010\u0003\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0000\u001a&\u0010\u0006\u001a\u00020\u00012\b\u0010\u0007\u001a\u0004\u0018\u00010\u00012\b\u0010\b\u001a\u0004\u0018\u00010\u00012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0000\u001a\u0018\u0010\t\u001a\u0004\u0018\u00010\u00012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0000\u001a\u0018\u0010\r\u001a\u0004\u0018\u00010\u00012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0000\u001a*\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0001H\u0000\u001a6\u0010\u0015\u001a\u00020\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0017H\u0000\u001a \u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010\u0010\u001a\u00020\u00012\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0000\u001a\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u0005H\u0002\u001a\u0012\u0010 \u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0011\u001a\u00020\fH\u0002\u001a\u0012\u0010!\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0011\u001a\u00020\fH\u0002\u001a\u0012\u0010\"\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0011\u001a\u00020\fH\u0002\u001a\u001a\u0010#\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010$\u001a\u00020\u0001H\u0002\u001a$\u0010%\u001a\u00020\u001c*\u00060&j\u0002`'2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00012\b\u0010\u001f\u001a\u0004\u0018\u00010\u0005H\u0002\u00a8\u0006("}, d2={"getDefaultLeftPanelTitleForBranch", "", "branchName", "getDefaultRightPanelTitleForBranch", "baseHash", "Lcom/intellij/vcs/log/Hash;", "getDescriptionForRebase", "rebasingBranch", "baseBranch", "getSingleCurrentBranchName", "roots", "", "Lgit4idea/repo/GitRepository;", "getSingleMergeBranchName", "getTitleWithCommitDetailsCustomizer", "Lcom/intellij/diff/DiffEditorTitleCustomizer;", "title", "repository", "file", "Lcom/intellij/openapi/vcs/FilePath;", "commit", "getTitleWithCommitsRangeDetailsCustomizer", "range", "Lkotlin/Pair;", "getTitleWithShowDetailsAction", "Ljavax/swing/JPanel;", "action", "Lkotlin/Function0;", "", "resolveBranchName", "Lgit4idea/merge/RefInfo;", "hash", "resolveMergeBranch", "resolveMergeBranchOrCherryPick", "resolveRebaseOntoBranch", "tryResolveRef", "ref", "appendBranchName", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "intellij.vcs.git"})
public final class GitDefaultMergeDialogCustomizerKt {
    @NotNull
    public static final String getDescriptionForRebase(@Nullable String rebasingBranch, @Nullable String baseBranch, @Nullable Hash baseHash) {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl4 = false;
        $this$buildString.append("<html>Rebasing ");
        if (rebasingBranch != null) {
            $this$buildString.append("branch <b>" + XmlStringUtil.escapeString((String)rebasingBranch) + "</b> ");
        }
        $this$buildString.append("onto ");
        GitDefaultMergeDialogCustomizerKt.appendBranchName($this$buildString, baseBranch, baseHash);
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public static final String getDefaultLeftPanelTitleForBranch(@NotNull String branchName) {
        Intrinsics.checkParameterIsNotNull((Object)branchName, (String)"branchName");
        return "<html>" + XmlStringUtil.escapeString((String)DiffBundle.message((String)"merge.version.title.our", (Object[])new Object[0])) + ", branch <b>" + XmlStringUtil.escapeString((String)branchName) + "</b>";
    }

    @NotNull
    public static final String getDefaultRightPanelTitleForBranch(@Nullable String branchName, @Nullable Hash baseHash) {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl4 = false;
        $this$buildString.append("<html>Changes from ");
        GitDefaultMergeDialogCustomizerKt.appendBranchName($this$buildString, branchName, baseHash);
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private static final void appendBranchName(@NotNull StringBuilder $this$appendBranchName, String branchName, Hash hash) {
        if (branchName != null) {
            $this$appendBranchName.append("branch <b>" + XmlStringUtil.escapeString((String)branchName) + "</b>");
            if (hash != null) {
                $this$appendBranchName.append(", revision " + hash.toShortString());
            }
        } else if (hash != null) {
            $this$appendBranchName.append("<b>" + hash.toShortString() + "</b>");
        } else {
            $this$appendBranchName.append("diverging branches");
        }
    }

    private static final String resolveMergeBranchOrCherryPick(GitRepository repository) {
        RefInfo mergeBranch = GitDefaultMergeDialogCustomizerKt.resolveMergeBranch(repository);
        if (mergeBranch != null) {
            return mergeBranch.getPresentable();
        }
        RefInfo rebaseOntoBranch = GitDefaultMergeDialogCustomizerKt.resolveRebaseOntoBranch(repository);
        if (rebaseOntoBranch != null) {
            return rebaseOntoBranch.getPresentable();
        }
        Hash cherryHead = GitDefaultMergeDialogCustomizerKt.tryResolveRef(repository, "CHERRY_PICK_HEAD");
        if (cherryHead != null) {
            return "cherry-pick";
        }
        return null;
    }

    private static final RefInfo resolveMergeBranch(GitRepository repository) {
        Hash hash = GitDefaultMergeDialogCustomizerKt.tryResolveRef(repository, "MERGE_HEAD");
        if (hash == null) {
            return null;
        }
        Hash mergeHead = hash;
        return GitDefaultMergeDialogCustomizerKt.resolveBranchName(repository, mergeHead);
    }

    private static final RefInfo resolveRebaseOntoBranch(GitRepository repository) {
        Hash hash = GitRebaseUtils.getOntoHash(repository.getProject(), repository.getRoot());
        if (hash == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)hash, (String)"GitRebaseUtils.getOntoHa\u2026tory.root) ?: return null");
        Hash ontoHash = hash;
        GitRepository gitRepository = (GitRepository)GitRepositoryManager.getInstance(repository.getProject()).getRepositoryForRoot(repository.getRoot());
        if (gitRepository == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)gitRepository, (String)"GitRepositoryManager.get\u2026tory.root) ?: return null");
        GitRepository repo = gitRepository;
        return GitDefaultMergeDialogCustomizerKt.resolveBranchName(repo, ontoHash);
    }

    private static final RefInfo resolveBranchName(GitRepository repository, Hash hash) {
        Collection<GitLocalBranch> collection = repository.getBranches().findLocalBranchesByHash(hash);
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"repository.branches.findLocalBranchesByHash(hash)");
        Collection<GitBranch> branches2 = collection;
        if (branches2.isEmpty()) {
            Collection<GitRemoteBranch> collection2 = repository.getBranches().findRemoteBranchesByHash(hash);
            Intrinsics.checkExpressionValueIsNotNull(collection2, (String)"repository.branches.findRemoteBranchesByHash(hash)");
            branches2 = collection2;
        }
        GitBranch gitBranch = (GitBranch)CollectionsKt.singleOrNull((Iterable)branches2);
        return new RefInfo(hash, gitBranch != null ? gitBranch.getName() : null);
    }

    private static final Hash tryResolveRef(GitRepository repository, String ref) {
        try {
            GitRevisionNumber gitRevisionNumber = GitRevisionNumber.resolve(repository.getProject(), repository.getRoot(), ref);
            Intrinsics.checkExpressionValueIsNotNull((Object)gitRevisionNumber, (String)"GitRevisionNumber.resolv\u2026ct, repository.root, ref)");
            GitRevisionNumber revision = gitRevisionNumber;
            return HashImpl.build((String)revision.asString());
        }
        catch (VcsException e) {
            return null;
        }
    }

    @Nullable
    public static final String getSingleMergeBranchName(@NotNull Collection<? extends GitRepository> roots) {
        Intrinsics.checkParameterIsNotNull(roots, (String)"roots");
        return (String)SequencesKt.singleOrNull((Sequence)SequencesKt.distinct((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)roots), (Function1)getSingleMergeBranchName.1.INSTANCE)));
    }

    @Nullable
    public static final String getSingleCurrentBranchName(@NotNull Collection<? extends GitRepository> roots) {
        Intrinsics.checkParameterIsNotNull(roots, (String)"roots");
        return (String)SequencesKt.singleOrNull((Sequence)SequencesKt.distinct((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)roots), (Function1)getSingleCurrentBranchName.1.INSTANCE)));
    }

    @NotNull
    public static final DiffEditorTitleCustomizer getTitleWithCommitDetailsCustomizer(@Nls @NotNull String title, @NotNull GitRepository repository, @NotNull FilePath file, @NotNull String commit2) {
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)commit2, (String)"commit");
        return new DiffEditorTitleCustomizer(title, repository, commit2, file){
            final /* synthetic */ String $title;
            final /* synthetic */ GitRepository $repository;
            final /* synthetic */ String $commit;
            final /* synthetic */ FilePath $file;

            @NotNull
            public final JPanel getLabel() {
                return GitDefaultMergeDialogCustomizerKt.getTitleWithShowDetailsAction(this.$title, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ getTitleWithCommitDetailsCustomizer.1 this$0;

                    public final void invoke() {
                        ChangeListViewerDialog dlg = new ChangeListViewerDialog(this.this$0.$repository.getProject());
                        dlg.loadChangesInBackground((ThrowableComputable)new ThrowableComputable<ChangeListViewerDialog.ChangelistData, VcsException>(this){
                            final /* synthetic */ getTitleWithCommitDetailsCustomizer.1 this$0;

                            @NotNull
                            public final ChangeListViewerDialog.ChangelistData compute() {
                                GitCommittedChangeList changeList = GitChangeUtils.getRevisionChanges(this.this$0.this$0.$repository.getProject(), this.this$0.this$0.$repository.getRoot(), this.this$0.this$0.$commit, true, false, false);
                                return new ChangeListViewerDialog.ChangelistData((CommittedChangeList)changeList, this.this$0.this$0.$file);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                        dlg.setTitle(StringUtil.stripHtml((String)this.this$0.$title, (boolean)false));
                        dlg.setModal(true);
                        dlg.show();
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }));
            }
            {
                this.$title = string;
                this.$repository = gitRepository;
                this.$commit = string2;
                this.$file = filePath;
            }
        };
    }

    @NotNull
    public static final DiffEditorTitleCustomizer getTitleWithCommitsRangeDetailsCustomizer(@Nls @NotNull String title, @NotNull GitRepository repository, @NotNull FilePath file, @NotNull Pair<String, String> range) {
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull(range, (String)"range");
        return new DiffEditorTitleCustomizer(title, repository, file, range){
            final /* synthetic */ String $title;
            final /* synthetic */ GitRepository $repository;
            final /* synthetic */ FilePath $file;
            final /* synthetic */ Pair $range;

            @NotNull
            public final JPanel getLabel() {
                return GitDefaultMergeDialogCustomizerKt.getTitleWithShowDetailsAction(this.$title, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ getTitleWithCommitsRangeDetailsCustomizer.1 this$0;

                    public final void invoke() {
                        boolean bl = false;
                        List details = new ArrayList<E>();
                        HashSet<E> filteredCommits = new HashSet<E>();
                        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(this, filteredCommits, details){
                            final /* synthetic */ getTitleWithCommitsRangeDetailsCustomizer.1 this$0;
                            final /* synthetic */ HashSet $filteredCommits;
                            final /* synthetic */ List $details;

                            public final void run() {
                                GitLogUtil.readFullDetails(this.this$0.this$0.$repository.getProject(), this.this$0.this$0.$repository.getRoot(), (Consumer<? super GitCommit>)((Consumer)new Consumer<GitCommit>(this){
                                    final /* synthetic */ getTitleWithCommitsRangeDetailsCustomizer.1 this$0;

                                    public final void consume(GitCommit commit2) {
                                        GitCommit gitCommit = commit2;
                                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)gitCommit), (String)"commit");
                                        VcsCommitMetadataImpl commitMetadata = new VcsCommitMetadataImpl(gitCommit.getId(), commit2.getParents(), commit2.getCommitTime(), commit2.getRoot(), commit2.getSubject(), commit2.getAuthor(), commit2.getFullMessage(), commit2.getCommitter(), commit2.getAuthorTime());
                                        if (commit2.getAffectedPaths().contains(this.this$0.this$0.this$0.$file)) {
                                            this.this$0.$filteredCommits.add(commitMetadata);
                                        }
                                        this.this$0.$details.add(commitMetadata);
                                    }
                                    {
                                        this.this$0 = var1_1;
                                    }
                                }), (String)this.this$0.this$0.$range.getFirst() + ".." + (String)this.this$0.this$0.$range.getSecond());
                            }
                            {
                                this.this$0 = var1_1;
                                this.$filteredCommits = hashSet;
                                this.$details = list;
                            }
                        }, "Collecting Commits Details...", true, this.this$0.$repository.getProject());
                        Project project = this.this$0.$repository.getProject();
                        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"repository.project");
                        VirtualFile virtualFile = this.this$0.$repository.getRoot();
                        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"repository.root");
                        MergeConflictMultipleCommitInfoDialog dlg = new MergeConflictMultipleCommitInfoDialog(project, virtualFile, details, (Set<? extends VcsCommitMetadata>)filteredCommits);
                        dlg.setTitle(StringUtil.stripHtml((String)this.this$0.$title, (boolean)false));
                        dlg.show();
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }));
            }
            {
                this.$title = string;
                this.$repository = gitRepository;
                this.$file = filePath;
                this.$range = pair;
            }
        };
    }

    @NotNull
    public static final JPanel getTitleWithShowDetailsAction(@Nls @NotNull String title, @NotNull Function0<Unit> action) {
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        Function0<Unit> function0 = action;
        BorderLayoutPanel borderLayoutPanel = new BorderLayoutPanel().addToCenter((Component)new JBLabel(title).setCopyable(true)).addToRight((Component)LinkLabel.create((String)"Show Details", (Runnable)new GitDefaultMergeDialogCustomizerKt$sam$java_lang_Runnable$0(function0)));
        Intrinsics.checkExpressionValueIsNotNull((Object)borderLayoutPanel, (String)"BorderLayoutPanel()\n    \u2026(\"Show Details\", action))");
        return (JPanel)borderLayoutPanel;
    }

    public static final /* synthetic */ RefInfo access$resolveMergeBranch(GitRepository repository) {
        return GitDefaultMergeDialogCustomizerKt.resolveMergeBranch(repository);
    }

    public static final /* synthetic */ RefInfo access$resolveRebaseOntoBranch(GitRepository repository) {
        return GitDefaultMergeDialogCustomizerKt.resolveRebaseOntoBranch(repository);
    }

    public static final /* synthetic */ Hash access$tryResolveRef(GitRepository repository, String ref) {
        return GitDefaultMergeDialogCustomizerKt.tryResolveRef(repository, ref);
    }

    public static final /* synthetic */ String access$resolveMergeBranchOrCherryPick(GitRepository repository) {
        return GitDefaultMergeDialogCustomizerKt.resolveMergeBranchOrCherryPick(repository);
    }
}

