/*
 * Decompiled with CFR 0.152.
 */
package git4idea.conflicts;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import git4idea.conflicts.GitConflictsPanel;
import git4idea.conflicts.GitMergeHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\u0017\u0018\u0019B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\n\u00a8\u0006\u001a"}, d2={"Lgit4idea/conflicts/GitConflictsView;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "mergeDialogCustomizer", "Lcom/intellij/openapi/vcs/merge/MergeDialogCustomizer;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/merge/MergeDialogCustomizer;)V", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "conflictsPanel", "Lgit4idea/conflicts/GitConflictsPanel;", "descriptionLabel", "Ljavax/swing/JLabel;", "mergeHandler", "Lgit4idea/conflicts/GitMergeHandler;", "panel", "Lcom/intellij/openapi/ui/SimpleToolWindowPanel;", "preferredFocusableComponent", "getPreferredFocusableComponent", "dispose", "", "AcceptSideAction", "ButtonAction", "ResolveAction", "intellij.vcs.git"})
public final class GitConflictsView
implements Disposable {
    private final GitMergeHandler mergeHandler;
    private final SimpleToolWindowPanel panel;
    private final JLabel descriptionLabel;
    private final GitConflictsPanel conflictsPanel;

    @NotNull
    public final JComponent getComponent() {
        return (JComponent)this.panel;
    }

    @NotNull
    public final JComponent getPreferredFocusableComponent() {
        return this.conflictsPanel.getPreferredFocusableComponent();
    }

    public void dispose() {
    }

    public GitConflictsView(@NotNull Project project, @NotNull MergeDialogCustomizer mergeDialogCustomizer) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)mergeDialogCustomizer, (String)"mergeDialogCustomizer");
        this.mergeHandler = new GitMergeHandler(project, mergeDialogCustomizer);
        this.conflictsPanel = new GitConflictsPanel(project, this.mergeHandler);
        Disposer.register((Disposable)this, (Disposable)this.conflictsPanel);
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup toolbarGroup = new DefaultActionGroup();
        toolbarGroup.addAction((AnAction)new ResolveAction());
        toolbarGroup.addAction((AnAction)new AcceptSideAction(false));
        toolbarGroup.addAction((AnAction)new AcceptSideAction(true));
        toolbarGroup.addAction((AnAction)Separator.getInstance());
        toolbarGroup.addAction(actionManager.getAction("ChangesView.GroupBy"));
        ActionToolbar actionToolbar = actionManager.createActionToolbar("GitConflictsView", (ActionGroup)toolbarGroup, false);
        Intrinsics.checkExpressionValueIsNotNull((Object)actionToolbar, (String)"actionManager.createActi\u2026ew\", toolbarGroup, false)");
        ActionToolbar toolbar = actionToolbar;
        toolbar.setTargetComponent(this.conflictsPanel.getComponent());
        JPanel mainPanel = new JPanel(new BorderLayout());
        this.descriptionLabel = new JLabel("Loading merge conflicts...");
        this.conflictsPanel.addListener(new GitConflictsPanel.Listener(){

            @Override
            public void onDescriptionChange(@NotNull String description) {
                Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
                descriptionLabel.setText(description);
            }
        });
        mainPanel.add((Component)this.descriptionLabel, "South");
        mainPanel.add((Component)this.conflictsPanel.getComponent(), "Center");
        this.descriptionLabel.setBorder((Border)JBUI.Borders.empty((int)2, (int)5));
        this.descriptionLabel.setForeground(UIUtil.getContextHelpForeground());
        this.descriptionLabel.setBackground(UIUtil.getTreeBackground());
        mainPanel.setBackground(UIUtil.getTreeBackground());
        this.panel = new SimpleToolWindowPanel(true, true);
        this.panel.setToolbar(toolbar.getComponent());
        this.panel.setContent((JComponent)mainPanel);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lgit4idea/conflicts/GitConflictsView$ResolveAction;", "Lgit4idea/conflicts/GitConflictsView$ButtonAction;", "(Lgit4idea/conflicts/GitConflictsView;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.vcs.git"})
    private final class ResolveAction
    extends ButtonAction {
        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            Presentation presentation = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
            presentation.setEnabled(GitConflictsView.this.conflictsPanel.canShowMergeWindowForSelection());
            this.updateButtonPresentation(e);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            GitConflictsView.this.conflictsPanel.showMergeWindowForSelection();
        }

        public ResolveAction() {
            super("Resolve");
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lgit4idea/conflicts/GitConflictsView$AcceptSideAction;", "Lgit4idea/conflicts/GitConflictsView$ButtonAction;", "takeTheirs", "", "(Lgit4idea/conflicts/GitConflictsView;Z)V", "getTakeTheirs", "()Z", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.vcs.git"})
    private final class AcceptSideAction
    extends ButtonAction {
        private final boolean takeTheirs;

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            Presentation presentation = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
            presentation.setEnabled(GitConflictsView.this.conflictsPanel.canAcceptConflictSideForSelection());
            this.updateButtonPresentation(e);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            GitConflictsView.this.conflictsPanel.acceptConflictSideForSelection(this.takeTheirs);
        }

        public final boolean getTakeTheirs() {
            return this.takeTheirs;
        }

        public AcceptSideAction(boolean takeTheirs) {
            super(takeTheirs ? "Accept Theirs" : "Accept Yours");
            this.takeTheirs = takeTheirs;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\"\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004H\u0016J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u0011"}, d2={"Lgit4idea/conflicts/GitConflictsView$ButtonAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/openapi/actionSystem/ex/CustomComponentAction;", "text", "", "(Ljava/lang/String;)V", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "updateButtonPresentation", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "button", "Ljavax/swing/JButton;", "intellij.vcs.git"})
    private static abstract class ButtonAction
    extends DumbAwareAction
    implements CustomComponentAction {
        @NotNull
        public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
            Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
            Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
            JButton button2 = new JButton(presentation.getText());
            button2.setFocusable(false);
            button2.addActionListener(new ActionListener(this, button2, place){
                final /* synthetic */ ButtonAction this$0;
                final /* synthetic */ JButton $button;
                final /* synthetic */ String $place;

                public final void actionPerformed(ActionEvent it) {
                    ActionToolbar toolbar = (ActionToolbar)ComponentUtil.getParentOfType(ActionToolbar.class, (Component)this.$button);
                    ActionToolbar actionToolbar = toolbar;
                    if (actionToolbar == null || (actionToolbar = actionToolbar.getToolbarDataContext()) == null) {
                        actionToolbar = DataManager.getInstance().getDataContext((Component)this.$button);
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)actionToolbar, (String)"toolbar?.toolbarDataCont\u2026().getDataContext(button)");
                    ActionToolbar dataContext = actionToolbar;
                    this.this$0.actionPerformed(AnActionEvent.createFromAnAction((AnAction)((AnAction)this.this$0), null, (String)this.$place, (DataContext)dataContext));
                }
                {
                    this.this$0 = buttonAction;
                    this.$button = jButton;
                    this.$place = string;
                }
            });
            this.updateButtonPresentation(button2, presentation);
            Insets buttonInsets = button2.getInsets();
            int leftRight = JBUI.scale((int)(SystemInfo.isWindows ? 4 : 6)) - (buttonInsets.left + buttonInsets.right) / 2;
            int topBottom = JBUI.scale((int)4) - (buttonInsets.top + buttonInsets.bottom) / 2;
            JBEmptyBorder border = new JBEmptyBorder((Insets)JBInsets.create((int)RangesKt.coerceAtLeast((int)topBottom, (int)0), (int)RangesKt.coerceAtLeast((int)leftRight, (int)0)));
            JBPanel jBPanel = JBUI.Panels.simplePanel((Component)button2).withBorder((Border)border);
            Intrinsics.checkExpressionValueIsNotNull((Object)jBPanel, (String)"JBUI.Panels.simplePanel(button).withBorder(border)");
            return (JComponent)jBPanel;
        }

        public final void updateButtonPresentation(@NotNull AnActionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            JButton button2 = (JButton)UIUtil.findComponentOfType((JComponent)((JComponent)e.getPresentation().getClientProperty(CustomComponentAction.COMPONENT_KEY)), JButton.class);
            if (button2 != null) {
                Presentation presentation = e.getPresentation();
                Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
                this.updateButtonPresentation(button2, presentation);
            }
        }

        public final void updateButtonPresentation(@NotNull JButton button2, @NotNull Presentation presentation) {
            Intrinsics.checkParameterIsNotNull((Object)button2, (String)"button");
            Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
            button2.setEnabled(presentation.isEnabled());
            button2.setVisible(presentation.isVisible());
        }

        public ButtonAction(@NotNull String text) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            super(text);
        }
    }
}

