/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.breadcrumbs;

import com.intellij.lang.Language;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.YAMLLanguage;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;

public class YAMLBreadcrumbsInfoProvider
implements BreadcrumbsProvider {
    private static final Language[] LANGUAGES = new Language[]{YAMLLanguage.INSTANCE};
    private static final int SCALAR_MAX_LENGTH = 20;

    public Language[] getLanguages() {
        return LANGUAGES;
    }

    public boolean acceptElement(@NotNull PsiElement e) {
        if (e == null) {
            YAMLBreadcrumbsInfoProvider.$$$reportNull$$$0(0);
        }
        return e instanceof YAMLScalar || e instanceof YAMLKeyValue || e instanceof YAMLSequenceItem || e instanceof YAMLDocument;
    }

    @NotNull
    public String getElementInfo(@NotNull PsiElement e) {
        if (e == null) {
            YAMLBreadcrumbsInfoProvider.$$$reportNull$$$0(1);
        }
        if (e instanceof YAMLDocument) {
            YAMLFile file = (YAMLFile)e.getContainingFile();
            if (file == null) {
                return "Document";
            }
            List<YAMLDocument> documents = file.getDocuments();
            String string = "Document " + YAMLBreadcrumbsInfoProvider.getIndexOf(documents, e);
            if (string == null) {
                YAMLBreadcrumbsInfoProvider.$$$reportNull$$$0(2);
            }
            return string;
        }
        if (e instanceof YAMLKeyValue) {
            String string = ((YAMLKeyValue)e).getKeyText() + ':';
            if (string == null) {
                YAMLBreadcrumbsInfoProvider.$$$reportNull$$$0(3);
            }
            return string;
        }
        if (e instanceof YAMLSequenceItem) {
            PsiElement parent = e.getParent();
            if (!(parent instanceof YAMLSequence)) {
                return "Item";
            }
            List<YAMLSequenceItem> items = ((YAMLSequence)parent).getItems();
            String string = "Item " + YAMLBreadcrumbsInfoProvider.getIndexOf(items, e);
            if (string == null) {
                YAMLBreadcrumbsInfoProvider.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (e instanceof YAMLScalar) {
            String string = StringUtil.first((String)((YAMLScalar)e).getTextValue(), (int)20, (boolean)true);
            if (string == null) {
                YAMLBreadcrumbsInfoProvider.$$$reportNull$$$0(5);
            }
            return string;
        }
        throw new IllegalArgumentException("This element should not pass #acceptElement");
    }

    @Nullable
    public String getElementTooltip(@NotNull PsiElement e) {
        if (e == null) {
            YAMLBreadcrumbsInfoProvider.$$$reportNull$$$0(6);
        }
        return null;
    }

    @NotNull
    public List<? extends Action> getContextActions(@NotNull PsiElement element) {
        if (element == null) {
            YAMLBreadcrumbsInfoProvider.$$$reportNull$$$0(7);
        }
        if (!(element instanceof YAMLKeyValue) && !(element instanceof YAMLSequenceItem)) {
            List list = Collections.emptyList();
            if (list == null) {
                YAMLBreadcrumbsInfoProvider.$$$reportNull$$$0(8);
            }
            return list;
        }
        final String configName = YAMLUtil.getConfigFullName((YAMLPsiElement)element);
        if (configName.isEmpty()) {
            List list = Collections.emptyList();
            if (list == null) {
                YAMLBreadcrumbsInfoProvider.$$$reportNull$$$0(9);
            }
            return list;
        }
        List<1> list = Collections.singletonList(new AbstractAction(YAMLBundle.message("YAMLBreadcrumbsInfoProvider.copy.key.to.clipboard", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent event) {
                CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(configName));
            }
        });
        if (list == null) {
            YAMLBreadcrumbsInfoProvider.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    private static String getIndexOf(@NotNull List<?> list, Object o) {
        if (list == null) {
            YAMLBreadcrumbsInfoProvider.$$$reportNull$$$0(11);
        }
        String string = String.valueOf(1 + list.indexOf(o)) + '/' + list.size();
        if (string == null) {
            YAMLBreadcrumbsInfoProvider.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/breadcrumbs/YAMLBreadcrumbsInfoProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/breadcrumbs/YAMLBreadcrumbsInfoProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementInfo";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextActions";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexOf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "acceptElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getElementInfo";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getElementTooltip";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getContextActions";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getIndexOf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

