/*
 * Decompiled with CFR 0.152.
 */
package org.cef.network;

import org.cef.network.CefPostDataElement_N;

public abstract class CefPostDataElement {
    CefPostDataElement() {
    }

    public static final CefPostDataElement create() {
        return CefPostDataElement_N.createNative();
    }

    public abstract boolean isReadOnly();

    public abstract void setToEmpty();

    public abstract void setToFile(String var1);

    public abstract void setToBytes(int var1, byte[] var2);

    public abstract Type getType();

    public abstract String getFile();

    public abstract int getBytesCount();

    public abstract int getBytes(int var1, byte[] var2);

    public String toString() {
        return this.toString(null);
    }

    public String toString(String mimeType) {
        int bytesCnt = this.getBytesCount();
        byte[] bytes = null;
        if (bytesCnt > 0) {
            bytes = new byte[bytesCnt];
        }
        boolean asText = false;
        if (mimeType != null) {
            if (mimeType.startsWith("text/")) {
                asText = true;
            } else if (mimeType.startsWith("application/xml")) {
                asText = true;
            } else if (mimeType.startsWith("application/xhtml")) {
                asText = true;
            } else if (mimeType.startsWith("application/x-www-form-urlencoded")) {
                asText = true;
            }
        }
        String returnValue = "";
        if (this.getType() == Type.PDE_TYPE_BYTES) {
            int setBytes = this.getBytes(bytes.length, bytes);
            returnValue = returnValue + "    Content-Length: " + bytesCnt + "\n";
            if (asText) {
                returnValue = returnValue + "\n    " + new String(bytes);
            } else {
                for (int i = 0; i < setBytes; ++i) {
                    if (i % 40 == 0) {
                        returnValue = returnValue + "\n    ";
                    }
                    returnValue = returnValue + String.format("%02X", bytes[i]) + " ";
                }
            }
            returnValue = returnValue + "\n";
        } else if (this.getType() == Type.PDE_TYPE_FILE) {
            returnValue = returnValue + "\n    Bytes of file: " + this.getFile() + "\n";
        }
        return returnValue;
    }

    public static enum Type {
        PDE_TYPE_EMPTY,
        PDE_TYPE_BYTES,
        PDE_TYPE_FILE;

    }
}

