/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.openapi.util.io.DataInputOutputUtilRt;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.lang.ClassPath;
import com.intellij.util.lang.ClasspathCache;
import com.intellij.util.lang.Loader;
import com.intellij.util.lang.Resource;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FileLoader
extends Loader {
    private final File myRootDir;
    private final String myRootDirAbsolutePath;
    private final ClassPath myConfiguration;
    private final DirEntry root;
    private static final AtomicInteger totalLoaders = new AtomicInteger();
    private static final AtomicLong totalScanning = new AtomicLong();
    private static final AtomicLong totalSaving = new AtomicLong();
    private static final AtomicLong totalReading = new AtomicLong();
    private static final Boolean doFsActivityLogging = false;
    private static final int ourVersion = 1;

    FileLoader(@NotNull URL url, int index, @NotNull ClassPath configuration) throws IOException {
        if (url == null) {
            FileLoader.$$$reportNull$$$0(0);
        }
        if (configuration == null) {
            FileLoader.$$$reportNull$$$0(1);
        }
        super(url, index);
        this.root = new DirEntry(0, "");
        try {
            this.myRootDir = new File(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        this.myRootDirAbsolutePath = this.myRootDir.getAbsolutePath();
        this.myConfiguration = configuration;
    }

    private void buildPackageCache(@NotNull File dir, @NotNull ClasspathCache.LoaderDataBuilder context) {
        if (dir == null) {
            FileLoader.$$$reportNull$$$0(2);
        }
        if (context == null) {
            FileLoader.$$$reportNull$$$0(3);
        }
        context.addResourcePackageFromName(this.getRelativeResourcePath(dir));
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        boolean containsClasses = false;
        for (File file : files) {
            boolean isClass = file.getPath().endsWith(".class");
            if (isClass) {
                if (!containsClasses) {
                    context.addClassPackageFromName(this.getRelativeResourcePath(file));
                    containsClasses = true;
                }
                context.addPossiblyDuplicateNameEntry(file.getName());
                continue;
            }
            context.addPossiblyDuplicateNameEntry(file.getName());
            this.buildPackageCache(file, context);
        }
    }

    @NotNull
    private String getRelativeResourcePath(@NotNull File file) {
        if (file == null) {
            FileLoader.$$$reportNull$$$0(4);
        }
        return this.getRelativeResourcePath(file.getAbsolutePath());
    }

    @NotNull
    private String getRelativeResourcePath(@NotNull String absFilePath) {
        if (absFilePath == null) {
            FileLoader.$$$reportNull$$$0(5);
        }
        String relativePath = absFilePath.substring(this.myRootDirAbsolutePath.length());
        String string = relativePath = (relativePath = relativePath.replace(File.separatorChar, '/')).startsWith("/") ? relativePath.substring(1) : relativePath;
        if (string == null) {
            FileLoader.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @Nullable
    Resource getResource(@NotNull String name) {
        if (name == null) {
            FileLoader.$$$reportNull$$$0(7);
        }
        try {
            URL url;
            if (this.myConfiguration.myLazyClassloadingCaches) {
                DirEntry lastEntry = this.root;
                int prevIndex = 0;
                int nextIndex = name.indexOf(47, prevIndex);
                while (true) {
                    int nameEnd;
                    int nameHash;
                    if (!this.nameHashIsPresentInChildren(lastEntry, name, prevIndex, nameHash = FileLoader.stringHashCodeInsensitive(name, prevIndex, nameEnd = nextIndex == -1 ? name.length() : nextIndex))) {
                        return null;
                    }
                    if (nextIndex == -1 || nextIndex == name.length() - 1) break;
                    lastEntry = FileLoader.findOrCreateNextDirEntry(lastEntry, name, prevIndex, nameEnd, nameHash);
                    prevIndex = nextIndex + 1;
                    nextIndex = name.indexOf(47, prevIndex);
                }
            }
            if (!(url = new URL(this.getBaseURL(), name)).getFile().startsWith(this.getBaseURL().getFile())) {
                return null;
            }
            File file = new File(this.myRootDir, name.replace('/', File.separatorChar));
            if (file.exists()) {
                return new MyResource(url, file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @NotNull
    private static DirEntry findOrCreateNextDirEntry(@NotNull DirEntry lastEntry, @NotNull String name, int prevIndex, int nameEnd, int nameHash) {
        if (lastEntry == null) {
            FileLoader.$$$reportNull$$$0(8);
        }
        if (name == null) {
            FileLoader.$$$reportNull$$$0(9);
        }
        DirEntry nextEntry = null;
        DirEntry[] directories = lastEntry.childrenDirectories;
        if (directories != null) {
            int len = directories.length;
            for (int index = 0; index < len; ++index) {
                DirEntry previouslyScannedDir = directories[index];
                if (previouslyScannedDir.nameHash != nameHash || !previouslyScannedDir.name.regionMatches(0, name, prevIndex, nameEnd - prevIndex)) continue;
                nextEntry = previouslyScannedDir;
                break;
            }
        }
        if (nextEntry == null) {
            DirEntry[] newChildrenDirectories;
            nextEntry = new DirEntry(nameHash, name.substring(prevIndex, nameEnd));
            if (directories != null) {
                newChildrenDirectories = new DirEntry[directories.length + 1];
                System.arraycopy(directories, 0, newChildrenDirectories, 0, directories.length);
                newChildrenDirectories[directories.length] = nextEntry;
            } else {
                newChildrenDirectories = new DirEntry[]{nextEntry};
            }
            lastEntry.childrenDirectories = newChildrenDirectories;
        }
        DirEntry dirEntry = lastEntry = nextEntry;
        if (dirEntry == null) {
            FileLoader.$$$reportNull$$$0(10);
        }
        return dirEntry;
    }

    private boolean nameHashIsPresentInChildren(@NotNull DirEntry lastEntry, @NotNull String name, int prevIndex, int nameHash) {
        int[] childrenNameHashes;
        if (lastEntry == null) {
            FileLoader.$$$reportNull$$$0(11);
        }
        if (name == null) {
            FileLoader.$$$reportNull$$$0(12);
        }
        if ((childrenNameHashes = lastEntry.childrenNameHashes) == null) {
            String[] list = (prevIndex != 0 ? new File(this.myRootDir, name.substring(0, prevIndex)) : this.myRootDir).list();
            if (list != null) {
                childrenNameHashes = new int[list.length];
                for (int i = 0; i < list.length; ++i) {
                    childrenNameHashes[i] = FileLoader.stringHashCodeInsensitive(list[i], 0, list[i].length());
                }
            } else {
                childrenNameHashes = DirEntry.empty;
            }
            lastEntry.childrenNameHashes = childrenNameHashes;
        }
        for (int childNameHash : childrenNameHashes) {
            if (childNameHash != nameHash) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClasspathCache.LoaderData tryReadFromIndex() {
        if (!this.myConfiguration.myCanHavePersistentIndex) {
            return null;
        }
        long started = System.nanoTime();
        File index = this.getIndexFileFile();
        FilterInputStream reader = null;
        boolean isOk = false;
        try {
            reader = new DataInputStream(new BufferedInputStream(new FileInputStream(index)));
            if (DataInputOutputUtilRt.readINT((DataInput)((Object)reader)) == 1) {
                ClasspathCache.LoaderData loaderData = new ClasspathCache.LoaderData((DataInput)((Object)reader));
                isOk = true;
                ClasspathCache.LoaderData loaderData2 = loaderData;
                return loaderData2;
            }
        }
        catch (FileNotFoundException ex) {
            isOk = true;
        }
        catch (IOException iOException) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            if (!isOk) {
                index.delete();
            }
            totalReading.addAndGet(System.nanoTime() - started);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trySaveToIndex(@NotNull ClasspathCache.LoaderData data) {
        if (data == null) {
            FileLoader.$$$reportNull$$$0(13);
        }
        if (!this.myConfiguration.myCanHavePersistentIndex) {
            return;
        }
        long started = System.nanoTime();
        File index = this.getIndexFileFile();
        UnsyncDataOutputStream writer = null;
        boolean isOk = false;
        try {
            writer = new UnsyncDataOutputStream(new BufferedOutputStream(new FileOutputStream(index)));
            DataInputOutputUtilRt.writeINT(writer, 1);
            data.save(writer);
            isOk = true;
        }
        catch (IOException iOException) {
        }
        finally {
            if (writer != null) {
                try {
                    ((OutputStream)writer).close();
                }
                catch (IOException iOException) {}
            }
            if (!isOk) {
                index.delete();
            }
            totalSaving.addAndGet(System.nanoTime() - started);
        }
    }

    @NotNull
    private File getIndexFileFile() {
        return new File(this.myRootDir, "classpath.index");
    }

    @Override
    @NotNull
    public ClasspathCache.LoaderData buildData() {
        long currentScanningTime;
        ClasspathCache.LoaderData loaderData = this.tryReadFromIndex();
        int nsMsFactor = 1000000;
        int currentLoaders = totalLoaders.incrementAndGet();
        if (loaderData == null) {
            long started = System.nanoTime();
            ClasspathCache.LoaderDataBuilder loaderDataBuilder = new ClasspathCache.LoaderDataBuilder();
            this.buildPackageCache(this.myRootDir, loaderDataBuilder);
            loaderData = loaderDataBuilder.build();
            long doneNanos = System.nanoTime() - started;
            currentScanningTime = totalScanning.addAndGet(doneNanos);
            if (doFsActivityLogging.booleanValue()) {
                System.out.println("Scanned: " + this.myRootDirAbsolutePath + " for " + doneNanos / 1000000L + "ms");
            }
            this.trySaveToIndex(loaderData);
        } else {
            currentScanningTime = totalScanning.get();
        }
        if (doFsActivityLogging.booleanValue()) {
            System.out.println("Scanning: " + currentScanningTime / 1000000L + "ms, saving: " + totalSaving.get() / 1000000L + "ms, loading:" + totalReading.get() / 1000000L + "ms for " + currentLoaders + " loaders");
        }
        ClasspathCache.LoaderData loaderData2 = loaderData;
        if (loaderData2 == null) {
            FileLoader.$$$reportNull$$$0(14);
        }
        return loaderData2;
    }

    public String toString() {
        return "FileLoader [" + this.myRootDir + "]";
    }

    private static int stringHashCodeInsensitive(@NotNull String s, int from, int to) {
        if (s == null) {
            FileLoader.$$$reportNull$$$0(15);
        }
        int h = 0;
        for (int off = from; off < to; ++off) {
            h = 31 * h + StringUtilRt.toLowerCase(s.charAt(off));
        }
        return h;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 10: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 10: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "absFilePath";
                break;
            }
            case 6: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/lang/FileLoader";
                break;
            }
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastEntry";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/lang/FileLoader";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativeResourcePath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateNextDirEntry";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "buildData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildPackageCache";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRelativeResourcePath";
                break;
            }
            case 6: 
            case 10: 
            case 14: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getResource";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateNextDirEntry";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "nameHashIsPresentInChildren";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "trySaveToIndex";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "stringHashCodeInsensitive";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 10: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class UnsyncDataOutputStream
    extends DataOutputStream {
        UnsyncDataOutputStream(@NotNull OutputStream out) {
            if (out == null) {
                UnsyncDataOutputStream.$$$reportNull$$$0(0);
            }
            super(out);
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/util/lang/FileLoader$UnsyncDataOutputStream", "<init>"));
        }
    }

    private static final class MyResource
    extends Resource {
        private final URL myUrl;
        private final File myFile;

        MyResource(@NotNull URL url, @NotNull File file) {
            if (url == null) {
                MyResource.$$$reportNull$$$0(0);
            }
            if (file == null) {
                MyResource.$$$reportNull$$$0(1);
            }
            this.myUrl = url;
            this.myFile = file;
        }

        @Override
        @NotNull
        public URL getURL() {
            URL uRL = this.myUrl;
            if (uRL == null) {
                MyResource.$$$reportNull$$$0(2);
            }
            return uRL;
        }

        @Override
        @NotNull
        public InputStream getInputStream() throws IOException {
            return new BufferedInputStream(new FileInputStream(this.myFile));
        }

        @Override
        @NotNull
        public byte[] getBytes() throws IOException {
            byte[] byArray;
            InputStream stream;
            block3: {
                stream = this.getInputStream();
                byArray = FileUtilRt.loadBytes(stream, (int)this.myFile.length());
                if (byArray != null) break block3;
                MyResource.$$$reportNull$$$0(3);
            }
            return byArray;
            finally {
                stream.close();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/lang/FileLoader$MyResource";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/lang/FileLoader$MyResource";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getURL";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBytes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DirEntry {
        static final int[] empty = new int[0];
        volatile int[] childrenNameHashes;
        volatile DirEntry[] childrenDirectories;
        final int nameHash;
        @NotNull
        final String name;

        DirEntry(int nameHash, @NotNull String name) {
            if (name == null) {
                DirEntry.$$$reportNull$$$0(0);
            }
            this.nameHash = nameHash;
            this.name = name;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/lang/FileLoader$DirEntry", "<init>"));
        }
    }
}

