/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

class ClassLoadingLocks {
    private final ConcurrentMap<String, WeakLockReference> myMap = new ConcurrentHashMap<String, WeakLockReference>();
    private final ReferenceQueue<Object> myQueue = new ReferenceQueue();

    ClassLoadingLocks() {
    }

    @NotNull
    Object getOrCreateLock(@NotNull String className) {
        WeakLockReference oldRef;
        Object lock;
        WeakLockReference lockReference;
        if (className == null) {
            ClassLoadingLocks.$$$reportNull$$$0(0);
        }
        if ((lockReference = (WeakLockReference)this.myMap.get(className)) != null && (lock = lockReference.get()) != null) {
            Object t = lock;
            if (t == null) {
                ClassLoadingLocks.$$$reportNull$$$0(1);
            }
            return t;
        }
        Object newLock = new Object();
        WeakLockReference newRef = new WeakLockReference(className, newLock, this.myQueue);
        do {
            this.processQueue();
            oldRef = this.myMap.putIfAbsent(className, newRef);
            if (oldRef == null) {
                Object object = newLock;
                if (object == null) {
                    ClassLoadingLocks.$$$reportNull$$$0(2);
                }
                return object;
            }
            Object oldLock = oldRef.get();
            if (oldLock == null) continue;
            Object t = oldLock;
            if (t == null) {
                ClassLoadingLocks.$$$reportNull$$$0(3);
            }
            return t;
        } while (!this.myMap.replace(className, oldRef, newRef));
        Object object = newLock;
        if (object == null) {
            ClassLoadingLocks.$$$reportNull$$$0(4);
        }
        return object;
    }

    private void processQueue() {
        WeakLockReference ref;
        while ((ref = (WeakLockReference)this.myQueue.poll()) != null) {
            this.myMap.remove(ref.myClassName, ref);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/lang/ClassLoadingLocks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/lang/ClassLoadingLocks";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateLock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateLock";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class WeakLockReference
    extends WeakReference<Object> {
        final String myClassName;

        private WeakLockReference(@NotNull String className, @NotNull Object lock, @NotNull ReferenceQueue<Object> q) {
            if (className == null) {
                WeakLockReference.$$$reportNull$$$0(0);
            }
            if (lock == null) {
                WeakLockReference.$$$reportNull$$$0(1);
            }
            if (q == null) {
                WeakLockReference.$$$reportNull$$$0(2);
            }
            super(lock, q);
            this.myClassName = className;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "className";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "lock";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "q";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/lang/ClassLoadingLocks$WeakLockReference";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

