/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.ValueKey;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ValueMatcherImpl<T, T1>
implements ValueKey.BeforeIf<T>,
ValueKey.BeforeThen<T, T1> {
    @NotNull
    private final String myKey;
    @NotNull
    private State myState;
    private T myValue;

    ValueMatcherImpl(@NotNull String key) {
        if (key == null) {
            ValueMatcherImpl.$$$reportNull$$$0(0);
        }
        this.myState = State.NOT_MATCHED;
        this.myKey = key;
    }

    @Override
    @NotNull
    public <TT> ValueKey.BeforeThen<T, TT> ifEq(@NotNull ValueKey<TT> key) {
        if (key == null) {
            ValueMatcherImpl.$$$reportNull$$$0(1);
        }
        switch (this.myState) {
            case FINISHED: {
                throw new IllegalStateException("Matching is already finished");
            }
            case IGNORING: 
            case MATCHING: 
            case SKIPPING: {
                throw new IllegalStateException("'then'/'thenGet'/'or' call is expected");
            }
            case MATCHED: {
                if (key.getName().equals(this.myKey)) {
                    throw new IllegalStateException("Key '" + key.getName() + "' already matched");
                }
                this.myState = State.SKIPPING;
                break;
            }
            case NOT_MATCHED: {
                this.myState = key.getName().equals(this.myKey) ? State.MATCHING : State.IGNORING;
            }
        }
        ValueMatcherImpl valueMatcherImpl = this;
        if (valueMatcherImpl == null) {
            ValueMatcherImpl.$$$reportNull$$$0(2);
        }
        return valueMatcherImpl;
    }

    @Override
    public T get() {
        switch (this.myState) {
            case FINISHED: {
                throw new IllegalStateException("Matching is already finished");
            }
            case NOT_MATCHED: {
                this.myState = State.FINISHED;
                throw new NoSuchElementException("Requested key '" + this.myKey + "' is not matched");
            }
            case MATCHED: {
                this.myState = State.FINISHED;
                return this.myValue;
            }
        }
        throw new IllegalStateException("'then'/'thenGet'/'or' call is expected");
    }

    @Override
    @Nullable
    public T orNull() {
        switch (this.myState) {
            case FINISHED: {
                throw new IllegalStateException("Matching is already finished");
            }
            case MATCHED: 
            case NOT_MATCHED: {
                this.myState = State.FINISHED;
                return this.myValue;
            }
        }
        throw new IllegalStateException("'then'/'thenGet'/'or' call is expected");
    }

    @Override
    @NotNull
    public ValueKey.BeforeThen<T, T1> or(@NotNull ValueKey<T1> key) {
        if (key == null) {
            ValueMatcherImpl.$$$reportNull$$$0(3);
        }
        switch (this.myState) {
            case FINISHED: {
                throw new IllegalStateException("Matching is already finished");
            }
            case MATCHED: 
            case NOT_MATCHED: {
                throw new IllegalStateException("'ifEq'/'get'/'orNull' call is expected");
            }
            case MATCHING: 
            case SKIPPING: {
                if (!key.getName().equals(this.myKey)) break;
                throw new IllegalStateException("Key '" + key.getName() + "' already matched");
            }
            case IGNORING: {
                if (!key.getName().equals(this.myKey)) break;
                this.myState = State.MATCHING;
            }
        }
        ValueMatcherImpl valueMatcherImpl = this;
        if (valueMatcherImpl == null) {
            ValueMatcherImpl.$$$reportNull$$$0(4);
        }
        return valueMatcherImpl;
    }

    @Override
    @NotNull
    public ValueKey.BeforeIf<T> then(T1 value) {
        switch (this.myState) {
            case FINISHED: {
                throw new IllegalStateException("Matching is already finished");
            }
            case MATCHED: 
            case NOT_MATCHED: {
                throw new IllegalStateException("'ifEq'/'get'/'orNull' call is expected");
            }
            case SKIPPING: {
                this.myState = State.MATCHED;
                break;
            }
            case IGNORING: {
                this.myState = State.NOT_MATCHED;
                break;
            }
            case MATCHING: {
                this.myState = State.MATCHED;
                this.myValue = value;
            }
        }
        ValueMatcherImpl valueMatcherImpl = this;
        if (valueMatcherImpl == null) {
            ValueMatcherImpl.$$$reportNull$$$0(5);
        }
        return valueMatcherImpl;
    }

    @Override
    @NotNull
    public ValueKey.BeforeIf<T> thenGet(@NotNull Supplier<? extends T1> fn) {
        if (fn == null) {
            ValueMatcherImpl.$$$reportNull$$$0(6);
        }
        switch (this.myState) {
            case FINISHED: {
                throw new IllegalStateException("Matching is already finished");
            }
            case MATCHED: 
            case NOT_MATCHED: {
                throw new IllegalStateException("'ifEq'/'get'/'orNull' call is expected");
            }
            case SKIPPING: {
                this.myState = State.MATCHED;
                break;
            }
            case IGNORING: {
                this.myState = State.NOT_MATCHED;
                break;
            }
            case MATCHING: {
                this.myState = State.MATCHED;
                this.myValue = fn.get();
            }
        }
        ValueMatcherImpl valueMatcherImpl = this;
        if (valueMatcherImpl == null) {
            ValueMatcherImpl.$$$reportNull$$$0(7);
        }
        return valueMatcherImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/ValueMatcherImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/ValueMatcherImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "ifEq";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "or";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "then";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "thenGet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "ifEq";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "or";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "thenGet";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum State {
        NOT_MATCHED,
        IGNORING,
        SKIPPING,
        MATCHING,
        MATCHED,
        FINISHED;

    }
}

