/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.validation;

import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.ContentManagerUtil;
import com.intellij.ui.content.MessageView;
import gnu.trove.THashSet;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import org.intellij.plugins.relaxNG.RelaxngBundle;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class MessageViewHelper {
    private static final Logger LOG = Logger.getInstance(MessageViewHelper.class);
    private final Project myProject;
    private final Set<String> myErrors = new THashSet();
    private final String myContentName;
    private final Key<NewErrorTreeViewPanel> myKey;
    private NewErrorTreeViewPanel myErrorsView;
    private NewErrorTreeViewPanel.ProcessController myProcessController = MyProcessController.INSTANCE;

    public MessageViewHelper(Project project, String contentName, Key<NewErrorTreeViewPanel> key) {
        this.myProject = project;
        this.myContentName = contentName;
        this.myKey = key;
    }

    public synchronized void setProcessController(NewErrorTreeViewPanel.ProcessController processController) {
        if (this.myErrorsView == null) {
            this.myProcessController = processController;
        } else {
            this.myErrorsView.setProcessController(processController);
        }
    }

    public synchronized void openMessageView(Runnable rerun) {
        assert (this.myErrorsView == null);
        this.myErrorsView = new NewErrorTreeViewPanel(this.myProject, null, true, true, rerun);
        this.openMessageViewImpl();
    }

    public synchronized void processError(SAXParseException ex, boolean warning) {
        String error;
        if (this.myErrors.size() == 0 && this.myErrorsView == null) {
            this.myErrorsView = new NewErrorTreeViewPanel(this.myProject, null, true, true, null);
            this.myErrorsView.setProcessController(this.myProcessController);
            this.openMessageViewImpl();
        }
        if (!this.myErrors.add(error = ex.getLineNumber() + "|" + ex.getColumnNumber() + "|" + ex.getSystemId() + "|" + ex.getLocalizedMessage())) {
            return;
        }
        VirtualFile file = null;
        String systemId = ex.getSystemId();
        if (systemId != null) {
            try {
                file = VfsUtil.findFileByURL((URL)new URL(systemId));
            }
            catch (MalformedURLException e) {
                LOG.warn("systemId = " + systemId);
                LOG.error((Throwable)e);
            }
        }
        VirtualFile file1 = file;
        ApplicationManager.getApplication().invokeLater(() -> this.myErrorsView.addMessage(warning ? 5 : 4, new String[]{ex.getLocalizedMessage()}, file1, ex.getLineNumber() - 1, ex.getColumnNumber() - 1, null));
    }

    public void close() {
        ContentManagerUtil.cleanupContents(null, (Project)this.myProject, (String)this.myContentName);
    }

    private void openMessageViewImpl() {
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.executeCommand(this.myProject, () -> {
            MessageView messageView = MessageView.SERVICE.getInstance((Project)this.myProject);
            Content content = ContentFactory.SERVICE.getInstance().createContent(this.myErrorsView.getComponent(), this.myContentName, true);
            content.putUserData(this.myKey, (Object)this.myErrorsView);
            messageView.getContentManager().addContent(content);
            messageView.getContentManager().setSelectedContent(content);
            messageView.getContentManager().addContentManagerListener((ContentManagerListener)new CloseListener(content, this.myContentName, this.myErrorsView));
            ContentManagerUtil.cleanupContents((Content)content, (Project)this.myProject, (String)this.myContentName);
            messageView.getContentManager().addContentManagerListener((ContentManagerListener)new MyContentDisposer(content, messageView, this.myKey));
        }, RelaxngBundle.message("open.message.view", new Object[0]), null);
        ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Messages").activate(null);
    }

    public class ErrorHandler
    extends DefaultHandler {
        private boolean myHadErrorOrWarning;

        @Override
        public void warning(SAXParseException e) {
            this.myHadErrorOrWarning = true;
            MessageViewHelper.this.processError(e, true);
        }

        @Override
        public void error(SAXParseException e) {
            this.myHadErrorOrWarning = true;
            MessageViewHelper.this.processError(e, false);
        }

        @Override
        public void fatalError(SAXParseException e) {
            this.myHadErrorOrWarning = true;
            MessageViewHelper.this.processError(e, false);
        }

        public boolean hadErrorOrWarning() {
            return this.myHadErrorOrWarning;
        }
    }

    private static class MyContentDisposer
    implements ContentManagerListener {
        private final Content myContent;
        private final MessageView myMessageView;
        private final Key<NewErrorTreeViewPanel> myKey;

        MyContentDisposer(Content content, MessageView messageView, Key<NewErrorTreeViewPanel> key) {
            this.myContent = content;
            this.myMessageView = messageView;
            this.myKey = key;
        }

        public void contentRemoved(@NotNull ContentManagerEvent event) {
            Content eventContent;
            if (event == null) {
                MyContentDisposer.$$$reportNull$$$0(0);
            }
            if (!(eventContent = event.getContent()).equals(this.myContent)) {
                return;
            }
            this.myMessageView.getContentManager().removeContentManagerListener((ContentManagerListener)this);
            NewErrorTreeViewPanel errorTreeView = (NewErrorTreeViewPanel)eventContent.getUserData(this.myKey);
            if (errorTreeView != null) {
                Disposer.dispose((Disposable)errorTreeView);
            }
            eventContent.putUserData(this.myKey, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/intellij/plugins/relaxNG/validation/MessageViewHelper$MyContentDisposer", "contentRemoved"));
        }
    }

    private static class CloseListener
    implements ContentManagerListener {
        private final String myContentName;
        private NewErrorTreeViewPanel myErrorsView;
        private Content myContent;

        CloseListener(Content content, String contentName, NewErrorTreeViewPanel errorsView) {
            this.myContent = content;
            this.myContentName = contentName;
            this.myErrorsView = errorsView;
        }

        public void contentRemoved(@NotNull ContentManagerEvent event) {
            if (event == null) {
                CloseListener.$$$reportNull$$$0(0);
            }
            if (event.getContent() == this.myContent) {
                if (this.myErrorsView.canControlProcess()) {
                    this.myErrorsView.stopProcess();
                }
                this.myErrorsView = null;
                Objects.requireNonNull(this.myContent.getManager()).removeContentManagerListener((ContentManagerListener)this);
                this.myContent.release();
                this.myContent = null;
            }
        }

        public void contentRemoveQuery(@NotNull ContentManagerEvent event) {
            int result;
            if (event == null) {
                CloseListener.$$$reportNull$$$0(1);
            }
            if (event.getContent() == this.myContent && this.myErrorsView != null && this.myErrorsView.canControlProcess() && !this.myErrorsView.isProcessStopped() && (result = Messages.showYesNoDialog((String)RelaxngBundle.message("0.running", this.myContentName), (String)RelaxngBundle.message("0.is.still.running.close.anyway", this.myContentName), (Icon)Messages.getQuestionIcon())) != 0) {
                event.consume();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "org/intellij/plugins/relaxNG/validation/MessageViewHelper$CloseListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentRemoved";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentRemoveQuery";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyProcessController
    implements NewErrorTreeViewPanel.ProcessController {
        public static final MyProcessController INSTANCE = new MyProcessController();

        private MyProcessController() {
        }

        public void stopProcess() {
        }

        public boolean isProcessStopped() {
            return true;
        }
    }
}

