/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.extensions.plantuml;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.extensions.MarkdownCodeFenceCacheableProvider;
import org.intellij.plugins.markdown.extensions.plantuml.PlantUMLCodeFenceLanguageProvider;
import org.intellij.plugins.markdown.extensions.plantuml.PlantUMLProvider;
import org.intellij.plugins.markdown.settings.MarkdownSettingsConfigurable;
import org.intellij.plugins.markdown.ui.preview.MarkdownCodeFencePluginCacheCollector;
import org.intellij.plugins.markdown.ui.preview.MarkdownUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tH\u0002J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tH\u0016J\u0018\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\tH\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/intellij/plugins/markdown/extensions/plantuml/PlantUMLProvider;", "Lorg/intellij/plugins/markdown/extensions/MarkdownCodeFenceCacheableProvider;", "()V", "cacheCollector", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownCodeFencePluginCacheCollector;", "(Lorg/intellij/plugins/markdown/ui/preview/MarkdownCodeFencePluginCacheCollector;)V", "cacheDiagram", "", "newDiagramPath", "", "text", "generateDiagram", "", "diagramPath", "generateHtml", "isApplicable", "", "language", "storeDiagram", "source", "fileName", "Companion", "intellij.markdown"})
public final class PlantUMLProvider
implements MarkdownCodeFenceCacheableProvider {
    private MarkdownCodeFencePluginCacheCollector cacheCollector;
    private static final Logger LOG;
    private static final Lazy sourceStringReader$delegate;
    private static final Lazy generateImageMethod$delegate;
    public static final Companion Companion;

    @Override
    @NotNull
    public String generateHtml(@NotNull String text) {
        File newDiagramFile;
        block0: {
            MarkdownCodeFencePluginCacheCollector markdownCodeFencePluginCacheCollector;
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            newDiagramFile = new File(this.getCacheRootPath() + File.separator + MarkdownUtil.INSTANCE.md5((markdownCodeFencePluginCacheCollector = this.cacheCollector) != null && (markdownCodeFencePluginCacheCollector = markdownCodeFencePluginCacheCollector.getFile()) != null ? markdownCodeFencePluginCacheCollector.getPath() : null, "markdown-md5-file-path") + File.separator + MarkdownUtil.INSTANCE.md5(text, "plantUML-diagram") + ".png");
            String string = newDiagramFile.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"newDiagramFile.absolutePath");
            this.cacheDiagram(string, text);
            MarkdownCodeFencePluginCacheCollector markdownCodeFencePluginCacheCollector2 = this.cacheCollector;
            if (markdownCodeFencePluginCacheCollector2 == null) break block0;
            markdownCodeFencePluginCacheCollector2.addAliveCachedFile(newDiagramFile);
        }
        return "<img src=\"" + newDiagramFile.toURI() + "\"/>";
    }

    private final void cacheDiagram(String newDiagramPath, String text) {
        if (!FileUtil.exists((String)newDiagramPath)) {
            this.generateDiagram(text, newDiagramPath);
        }
    }

    private final void generateDiagram(CharSequence text, String diagramPath) throws IOException {
        String string = ((Object)text).toString();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String innerText = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        if (!StringsKt.startsWith$default((String)innerText, (String)"@startuml", (boolean)false, (int)2, null)) {
            innerText = "@startuml\n" + innerText;
        }
        if (!StringsKt.endsWith$default((String)innerText, (String)"@enduml", (boolean)false, (int)2, null)) {
            innerText = innerText + "\n@enduml";
        }
        FileUtil.createParentDirs((File)new File(diagramPath));
        this.storeDiagram(innerText, diagramPath);
    }

    @Override
    public boolean isApplicable(@NotNull String language) {
        Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
        return (Intrinsics.areEqual((Object)language, (Object)"puml") || Intrinsics.areEqual((Object)language, (Object)"plantuml")) && MarkdownSettingsConfigurable.isPlantUMLAvailable();
    }

    private final void storeDiagram(String source, String fileName) throws IOException {
        try {
            Method method = PlantUMLProvider.Companion.getGenerateImageMethod();
            if (method != null) {
                GenericDeclaration genericDeclaration = PlantUMLProvider.Companion.getSourceStringReader();
                method.invoke(genericDeclaration != null && (genericDeclaration = ((Class)genericDeclaration).getConstructor(String.class)) != null ? ((Constructor)genericDeclaration).newInstance(source) : null, new File(fileName));
            }
        }
        catch (Exception e) {
            LOG.warn("Cannot save diagram PlantUML diagram. ", (Throwable)e);
        }
    }

    public PlantUMLProvider(@Nullable MarkdownCodeFencePluginCacheCollector cacheCollector) {
        this.cacheCollector = cacheCollector;
    }

    public PlantUMLProvider() {
        this(null);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(PlantUMLCodeFenceLanguageProvider.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Plant\u2026uageProvider::class.java)");
        LOG = logger;
        sourceStringReader$delegate = LazyKt.lazy((Function0)Companion.sourceStringReader.2.INSTANCE);
        generateImageMethod$delegate = LazyKt.lazy((Function0)Companion.generateImageMethod.2.INSTANCE);
    }

    @Override
    @NotNull
    public String getCacheRootPath() {
        return MarkdownCodeFenceCacheableProvider.DefaultImpls.getCacheRootPath(this);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0006\u001a\u0004\u0018\u00010\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR!\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u000b\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lorg/intellij/plugins/markdown/extensions/plantuml/PlantUMLProvider$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "generateImageMethod", "Ljava/lang/reflect/Method;", "getGenerateImageMethod", "()Ljava/lang/reflect/Method;", "generateImageMethod$delegate", "Lkotlin/Lazy;", "sourceStringReader", "Ljava/lang/Class;", "getSourceStringReader", "()Ljava/lang/Class;", "sourceStringReader$delegate", "intellij.markdown"})
    public static final class Companion {
        private final Class<?> getSourceStringReader() {
            Lazy lazy = sourceStringReader$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (Class)lazy.getValue();
        }

        private final Method getGenerateImageMethod() {
            Lazy lazy = generateImageMethod$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (Method)lazy.getValue();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

