/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.structureView;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.ResourceBundleImpl;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.SoftFactoryMap;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.XMap;
import gnu.trove.TIntLongHashMap;
import gnu.trove.TIntProcedure;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="PropertiesSeparatorManager")
public class PropertiesSeparatorManager
implements PersistentStateComponent<PropertiesSeparatorManagerState> {
    private final Project myProject;
    private PropertiesSeparatorManagerState myUserDefinedSeparators = new PropertiesSeparatorManagerState();
    private final SoftFactoryMap<ResourceBundleImpl, String> myGuessedSeparators = new SoftFactoryMap<ResourceBundleImpl, String>(){

        protected String create(ResourceBundleImpl resourceBundle) {
            return PropertiesSeparatorManager.guessSeparator(resourceBundle);
        }
    };

    public static PropertiesSeparatorManager getInstance(Project project) {
        return (PropertiesSeparatorManager)ServiceManager.getService((Project)project, PropertiesSeparatorManager.class);
    }

    public PropertiesSeparatorManager(Project project) {
        this.myProject = project;
    }

    @NotNull
    public String getSeparator(ResourceBundle resourceBundle) {
        if (!(resourceBundle instanceof ResourceBundleImpl)) {
            return ".";
        }
        ResourceBundleImpl resourceBundleImpl = (ResourceBundleImpl)resourceBundle;
        String separator = this.myUserDefinedSeparators.getSeparators().get(resourceBundleImpl.getUrl());
        String string = separator == null ? (String)this.myGuessedSeparators.get((Object)resourceBundleImpl) : separator;
        if (string == null) {
            PropertiesSeparatorManager.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static String guessSeparator(ResourceBundleImpl resourceBundle) {
        final TIntLongHashMap charCounts = new TIntLongHashMap();
        for (PropertiesFile propertiesFile : resourceBundle.getPropertiesFiles()) {
            if (propertiesFile == null) continue;
            List<IProperty> properties = propertiesFile.getProperties();
            for (IProperty property : properties) {
                String key = property.getUnescapedKey();
                if (key == null) continue;
                for (int i = 0; i < key.length(); ++i) {
                    char c = key.charAt(i);
                    if (Character.isLetterOrDigit(c)) continue;
                    charCounts.put((int)c, charCounts.get((int)c) + 1L);
                }
            }
        }
        final char[] mostProbableChar = new char[]{'.'};
        charCounts.forEachKey(new TIntProcedure(){
            long count = -1L;

            public boolean execute(int ch) {
                long charCount = charCounts.get(ch);
                if (charCount > this.count) {
                    this.count = charCount;
                    mostProbableChar[0] = (char)ch;
                }
                return true;
            }
        });
        if (mostProbableChar[0] == '\u0000') {
            mostProbableChar[0] = 46;
        }
        return Character.toString(mostProbableChar[0]);
    }

    public void setSeparator(ResourceBundle resourceBundle, String separator) {
        if (resourceBundle instanceof ResourceBundleImpl) {
            this.myUserDefinedSeparators.getSeparators().put(((ResourceBundleImpl)resourceBundle).getUrl(), separator);
        }
    }

    public void loadState(@NotNull PropertiesSeparatorManagerState state) {
        if (state == null) {
            PropertiesSeparatorManager.$$$reportNull$$$0(1);
        }
        this.myUserDefinedSeparators = state.decode(this.myProject);
    }

    @Nullable
    public PropertiesSeparatorManagerState getState() {
        return this.myUserDefinedSeparators.isEmpty() ? null : this.myUserDefinedSeparators.encode();
    }

    @Nullable
    private static String decodeSeparator(String separator) {
        if (separator.length() % 6 != 0) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (int pos = 0; pos < separator.length(); pos += 6) {
            String encodedCharacter = separator.substring(pos, pos + 6);
            if (!encodedCharacter.startsWith("\\u")) {
                return null;
            }
            char code = (char)Integer.parseInt(encodedCharacter.substring(2), 16);
            result.append(code);
        }
        return result.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/structureView/PropertiesSeparatorManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeparator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/structureView/PropertiesSeparatorManager";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PropertiesSeparatorManagerState {
        @Property(surroundWithTag=false)
        @XMap(keyAttributeName="url", valueAttributeName="separator", entryTagName="file")
        public Map<String, String> mySeparators = new HashMap<String, String>();

        public Map<String, String> getSeparators() {
            return this.mySeparators;
        }

        public boolean isEmpty() {
            return this.mySeparators.isEmpty();
        }

        public PropertiesSeparatorManagerState encode() {
            PropertiesSeparatorManagerState encodedState = new PropertiesSeparatorManagerState();
            for (Map.Entry<String, String> entry : this.mySeparators.entrySet()) {
                String separator = entry.getValue();
                StringBuilder encoded = new StringBuilder(separator.length());
                for (int i = 0; i < separator.length(); ++i) {
                    char c = separator.charAt(i);
                    encoded.append("\\u");
                    encoded.append(String.format("%04x", c));
                }
                encodedState.getSeparators().put(entry.getKey(), encoded.toString());
            }
            return encodedState;
        }

        public PropertiesSeparatorManagerState decode(Project project) {
            PropertiesSeparatorManagerState decoded = new PropertiesSeparatorManagerState();
            for (Map.Entry<String, String> entry : this.mySeparators.entrySet()) {
                String url;
                ResourceBundle resourceBundle;
                String separator = entry.getValue();
                if ((separator = PropertiesSeparatorManager.decodeSeparator(separator)) == null || (resourceBundle = PropertiesImplUtil.createByUrl(url = entry.getKey(), project)) == null) continue;
                decoded.getSeparators().put(url, separator);
            }
            return decoded;
        }
    }
}

