/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.mpp.FieldMap;
import net.sf.mpxj.mpp.MPPComponent;
import net.sf.mpxj.mpp.VarMeta;

abstract class AbstractVarMeta
extends MPPComponent
implements VarMeta {
    protected int m_itemCount;
    protected int m_dataSize;
    private int[] m_offsets;
    protected Map<Integer, Map<Integer, Integer>> m_table = new TreeMap<Integer, Map<Integer, Integer>>();

    AbstractVarMeta() {
    }

    @Override
    public int getItemCount() {
        return this.m_itemCount;
    }

    @Override
    public int getDataSize() {
        return this.m_dataSize;
    }

    @Override
    public Integer[] getUniqueIdentifierArray() {
        Integer[] integerArray = new Integer[this.m_table.size()];
        int n = 0;
        Iterator<Integer> iterator = this.m_table.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n2;
            integerArray[n] = n2 = iterator.next();
            ++n;
        }
        return integerArray;
    }

    @Override
    public Set<Integer> getUniqueIdentifierSet() {
        return this.m_table.keySet();
    }

    @Override
    public Integer getOffset(Integer n, Integer n2) {
        Integer n3 = null;
        Map<Integer, Integer> map = this.m_table.get(n);
        if (map != null && n2 != null) {
            n3 = map.get(n2);
        }
        return n3;
    }

    protected void setOffsets(int[] nArray) {
        this.m_offsets = nArray;
    }

    @Override
    public int[] getOffsets() {
        return this.m_offsets;
    }

    @Override
    public Set<Integer> getTypes(Integer n) {
        Map<Integer, Integer> map = this.m_table.get(n);
        Set<Integer> set = map != null ? map.keySet() : new HashSet<Integer>();
        return set;
    }

    @Override
    public boolean containsKey(Integer n) {
        return this.m_table.containsKey(n);
    }

    public String toString() {
        return this.toString(null);
    }

    @Override
    public String toString(FieldMap fieldMap) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("BEGIN: VarMeta");
        printWriter.println("   Item count: " + this.m_itemCount);
        printWriter.println("   Data size: " + this.m_dataSize);
        for (Map.Entry<Integer, Map<Integer, Integer>> entry : this.m_table.entrySet()) {
            Integer n = entry.getKey();
            printWriter.println("   Entries for Unique ID: " + n);
            Map<Integer, Integer> map = entry.getValue();
            for (Map.Entry<Integer, Integer> entry2 : map.entrySet()) {
                FieldType fieldType = fieldMap == null ? null : fieldMap.getFieldTypeFromVarDataKey(entry2.getKey());
                printWriter.println("      Type=" + (fieldType == null ? entry2.getKey() : fieldType) + " Offset=" + entry2.getValue());
            }
        }
        printWriter.println("END: VarMeta");
        printWriter.println();
        printWriter.close();
        return stringWriter.toString();
    }
}

