/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.dxf.reader;

import de.escape.quincunx.dxf.reader.Dxf14Converter;
import de.escape.quincunx.dxf.reader.DxfEntity;
import de.escape.quincunx.dxf.reader.DxfFile;
import de.escape.quincunx.trafo.Point3D;
import de.escape.quincunx.trafo.Vector3D;

public class DxfELLIPSE
extends DxfEntity {
    private Point3D center = new Point3D();
    private Vector3D axisDir = new Vector3D();
    private float aspectRatio;
    private float startAngle;
    private float endAngle = (float)Math.PI * 2;

    public boolean setGroup(short grpNr, float fval) {
        switch (grpNr) {
            case 10: 
            case 20: 
            case 30: {
                this.setCoord(this.center, grpNr / 10, fval);
                return true;
            }
            case 11: 
            case 21: 
            case 31: {
                this.setCoord(this.axisDir, grpNr / 10, fval);
                return true;
            }
            case 40: {
                this.aspectRatio = fval;
                break;
            }
            case 41: {
                this.startAngle = fval;
                break;
            }
            case 42: {
                this.endAngle = fval;
                break;
            }
            default: {
                return super.setGroup(grpNr, fval);
            }
        }
        return false;
    }

    public void convert(Dxf14Converter converter, DxfFile dxf, Object collector) {
        converter.convert(this, dxf, collector);
    }

    public Point3D getCenter() {
        return this.center;
    }

    public Vector3D getAxisDir() {
        return this.axisDir;
    }

    public float getAspectRatio() {
        return this.aspectRatio;
    }

    public float getStartAngle() {
        return this.startAngle;
    }

    public float getEndAngle() {
        return this.endAngle;
    }
}

