// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Units_Lexicon_HeaderFile
#define _Units_Lexicon_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_Units_Lexicon.hxx>

#include <Handle_TCollection_HAsciiString.hxx>
#include <Standard_Time.hxx>
#include <Handle_Units_TokensSequence.hxx>
#include <MMgt_TShared.hxx>
#include <Standard_CString.hxx>
#include <Standard_Boolean.hxx>
#include <Standard_Real.hxx>
class TCollection_HAsciiString;
class Units_TokensSequence;
class TCollection_AsciiString;


//! This class defines a lexicon useful to analyse and
//! recognize the  different key words  included  in a
//! sentence.  The lexicon is stored  in a sequence of
//! tokens.
class Units_Lexicon : public MMgt_TShared
{

public:

  
  //! Creates an empty instance of Lexicon.
  Standard_EXPORT Units_Lexicon();
  
  //! Reads the file <afilename> to create a sequence  of tokens
  //! stored in <thesequenceoftokens>.
  Standard_EXPORT   void Creates (const Standard_CString afilename) ;
  
  //! Returns the first item of the sequence of tokens.
      Handle(Units_TokensSequence) Sequence()  const;
  
  //! Returns in a AsciiString from TCollection the name of the file.
  Standard_EXPORT   TCollection_AsciiString FileName()  const;
  
  //! Returns true if  the  file has not  changed  since the
  //! creation   of   the  Lexicon   object.   Returns false
  //! otherwise.
  Standard_EXPORT virtual   Standard_Boolean UpToDate()  const;
  
  //! Adds to the lexicon a new token with <aword>, <amean>,
  //! <avalue>  as  arguments.  If there is  already a token
  //! with   the  field  <theword>  equal    to <aword>, the
  //! existing token is updated.
  Standard_EXPORT   void AddToken (const Standard_CString aword, const Standard_CString amean, const Standard_Real avalue) ;
  
  //! Useful for debugging.
    virtual   void Dump()  const;




  DEFINE_STANDARD_RTTI(Units_Lexicon)

protected:




private: 


  Handle(TCollection_HAsciiString) thefilename;
  Standard_Time thetime;
  Handle(Units_TokensSequence) thesequenceoftokens;


};


#include <Units_Lexicon.lxx>





#endif // _Units_Lexicon_HeaderFile
