import { __assign, __spreadArrays } from "tslib";
import { useState, useMemo, useCallback } from 'react';
var useSet = function (initialSet) {
    if (initialSet === void 0) { initialSet = new Set(); }
    var _a = useState(initialSet), set = _a[0], setSet = _a[1];
    var stableActions = useMemo(function () { return ({
        add: function (item) { return setSet(function (prevSet) { return new Set(__spreadArrays(Array.from(prevSet), [item])); }); },
        remove: function (item) { return setSet(function (prevSet) { return new Set(Array.from(prevSet).filter(function (i) { return i !== item; })); }); },
        reset: function () { return setSet(initialSet); },
    }); }, [setSet]);
    var utils = __assign({ has: useCallback(function (item) { return set.has(item); }, [set]) }, stableActions);
    return [set, utils];
};
export default useSet;
