"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var d3_scale_1 = require("d3-scale");
var commons_1 = require("../commons");
var scales_1 = require("./scales");
var ScaleBand = /** @class */ (function () {
    function ScaleBand(domain, range, overrideBandwidth, 
    /**
     * The proportion of the range that is reserved for blank space between bands
     * A number between 0 and 1.
     * @default 0
     */
    barsPadding) {
        if (barsPadding === void 0) { barsPadding = 0; }
        this.type = scales_1.ScaleType.Ordinal;
        this.d3Scale = d3_scale_1.scaleBand();
        this.d3Scale.domain(domain);
        this.d3Scale.range(range);
        var safeBarPadding = commons_1.clamp(barsPadding, 0, 1);
        this.barsPadding = safeBarPadding;
        this.d3Scale.paddingInner(safeBarPadding);
        this.d3Scale.paddingOuter(safeBarPadding / 2);
        this.bandwidth = this.d3Scale.bandwidth() || 0;
        this.step = this.d3Scale.step();
        this.domain = this.d3Scale.domain();
        this.range = range.slice();
        if (overrideBandwidth) {
            this.bandwidth = overrideBandwidth * (1 - safeBarPadding);
        }
        this.bandwidthPadding = this.bandwidth;
        // TO FIX: we are assiming that it's ordered
        this.isInverted = this.domain[0] > this.domain[1];
        this.invertedScale = d3_scale_1.scaleQuantize()
            .domain(range)
            .range(this.domain);
        this.minInterval = 0;
    }
    ScaleBand.prototype.scale = function (value) {
        return this.d3Scale(value);
    };
    ScaleBand.prototype.pureScale = function (value) {
        return this.d3Scale(value);
    };
    ScaleBand.prototype.ticks = function () {
        return this.domain;
    };
    ScaleBand.prototype.invert = function (value) {
        return this.invertedScale(value);
    };
    ScaleBand.prototype.invertWithStep = function (value) {
        return {
            value: this.invertedScale(value),
            withinBandwidth: true,
        };
    };
    ScaleBand.prototype.isSingleValue = function () {
        return this.domain.length < 2;
    };
    ScaleBand.prototype.isValueInDomain = function (value) {
        return this.domain.includes(value);
    };
    return ScaleBand;
}());
exports.ScaleBand = ScaleBand;
//# sourceMappingURL=scale_band.js.map