"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var interactions_1 = require("../../utils/interactions");
var get_settings_specs_1 = require("../../../../state/selectors/get_settings_specs");
var get_chart_id_1 = require("../../../../state/selectors/get_chart_id");
exports.getTooltipTypeSelector = re_reselect_1.default([get_settings_specs_1.getSettingsSpecSelector], getTooltipType)(get_chart_id_1.getChartIdSelector);
function getTooltipType(settings) {
    var tooltip = settings.tooltip;
    if (tooltip === undefined || tooltip === null) {
        return interactions_1.TooltipType.VerticalCursor;
    }
    if (interactions_1.isTooltipType(tooltip)) {
        return tooltip;
    }
    if (interactions_1.isTooltipProps(tooltip)) {
        return tooltip.type || interactions_1.TooltipType.VerticalCursor;
    }
    return interactions_1.TooltipType.VerticalCursor;
}
//# sourceMappingURL=get_tooltip_type.js.map