"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var react_redux_1 = require("react-redux");
var interactions_1 = require("../../utils/interactions");
var utils_1 = require("../../state/utils");
var is_initialized_1 = require("../../../../state/selectors/is_initialized");
var get_chart_rotation_1 = require("../../../../state/selectors/get_chart_rotation");
var get_cursor_band_1 = require("../../state/selectors/get_cursor_band");
var get_cursor_line_1 = require("../../state/selectors/get_cursor_line");
var get_tooltip_type_1 = require("../../state/selectors/get_tooltip_type");
var get_chart_theme_1 = require("../../../../state/selectors/get_chart_theme");
var light_theme_1 = require("../../../../utils/themes/light_theme");
function canRenderBand(type, visible) {
    return visible && (type === interactions_1.TooltipType.Crosshairs || type === interactions_1.TooltipType.VerticalCursor);
}
function canRenderHelpLine(type, visible) {
    return visible && type === interactions_1.TooltipType.Crosshairs;
}
var CrosshairComponent = /** @class */ (function (_super) {
    __extends(CrosshairComponent, _super);
    function CrosshairComponent() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    CrosshairComponent.prototype.render = function () {
        return (react_1.default.createElement("div", { className: "echCrosshair" },
            this.renderBand(),
            this.renderLine()));
    };
    CrosshairComponent.prototype.renderBand = function () {
        var _a = this.props, band = _a.theme.crosshair.band, cursorBandPosition = _a.cursorBandPosition, tooltipType = _a.tooltipType;
        if (!cursorBandPosition || !canRenderBand(tooltipType, band.visible)) {
            return null;
        }
        var style = __assign(__assign({}, cursorBandPosition), { background: band.fill });
        return react_1.default.createElement("div", { className: "echCrosshair__band", style: style });
    };
    CrosshairComponent.prototype.renderLine = function () {
        var _a = this.props, line = _a.theme.crosshair.line, cursorLinePosition = _a.cursorLinePosition, tooltipType = _a.tooltipType, chartRotation = _a.chartRotation;
        if (!cursorLinePosition || !canRenderHelpLine(tooltipType, line.visible)) {
            return null;
        }
        var isHorizontalRotated = utils_1.isHorizontalRotation(chartRotation);
        var style;
        if (isHorizontalRotated) {
            style = __assign(__assign({}, cursorLinePosition), { borderTopWidth: line.strokeWidth, borderTopColor: line.stroke, borderTopStyle: line.dash ? 'dashed' : 'solid' });
        }
        else {
            style = __assign(__assign({}, cursorLinePosition), { borderLeftWidth: line.strokeWidth, borderLeftColor: line.stroke, borderLeftStyle: line.dash ? 'dashed' : 'solid' });
        }
        return react_1.default.createElement("div", { className: "echCrosshair__line", style: style });
    };
    CrosshairComponent.displayName = 'Crosshair';
    return CrosshairComponent;
}(react_1.default.Component));
var mapStateToProps = function (state) {
    if (!is_initialized_1.isInitialized(state)) {
        return {
            theme: light_theme_1.LIGHT_THEME,
            chartRotation: 0,
            tooltipType: interactions_1.TooltipType.None,
        };
    }
    return {
        theme: get_chart_theme_1.getChartThemeSelector(state),
        chartRotation: get_chart_rotation_1.getChartRotationSelector(state),
        cursorBandPosition: get_cursor_band_1.getCursorBandPositionSelector(state),
        cursorLinePosition: get_cursor_line_1.getCursorLinePositionSelector(state),
        tooltipType: get_tooltip_type_1.getTooltipTypeSelector(state),
    };
};
exports.Crosshair = react_redux_1.connect(mapStateToProps)(CrosshairComponent);
//# sourceMappingURL=crosshair.js.map