"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var specs_1 = require("../../utils/specs");
var react_redux_1 = require("react-redux");
var is_initialized_1 = require("../../../../state/selectors/is_initialized");
var compute_annotations_1 = require("../../state/selectors/compute_annotations");
var get_specs_1 = require("../../state/selectors/get_specs");
var get_annotation_tooltip_state_1 = require("../../state/selectors/get_annotation_tooltip_state");
var is_chart_empty_1 = require("../../state/selectors/is_chart_empty");
var compute_chart_dimensions_1 = require("../../state/selectors/compute_chart_dimensions");
var react_dom_1 = require("react-dom");
var annotation_tooltip_1 = require("../../annotations/annotation_tooltip");
var utils_1 = require("../../state/utils");
var ANNOTATION_CONTAINER_ID = 'echAnnotationContainerPortal';
var AnnotationTooltipComponent = /** @class */ (function (_super) {
    __extends(AnnotationTooltipComponent, _super);
    function AnnotationTooltipComponent(props) {
        var _this = _super.call(this, props) || this;
        _this.portalNode = null;
        _this.renderTooltip = function () {
            var tooltipState = _this.props.tooltipState;
            if (!_this.portalNode) {
                return null;
            }
            if (!tooltipState || !tooltipState.isVisible) {
                return react_1.default.createElement("div", { className: "echAnnotation__tooltip echAnnotation__tooltip--hidden" });
            }
            var details = tooltipState.details, header = tooltipState.header;
            switch (tooltipState.annotationType) {
                case specs_1.AnnotationTypes.Line: {
                    var props = { details: details, header: header };
                    return react_dom_1.createPortal(react_1.default.createElement(LineAnnotationTooltip, __assign({}, props, { ref: _this.tooltipRef })), _this.portalNode);
                }
                case specs_1.AnnotationTypes.Rectangle: {
                    var props = { details: details, customTooltip: tooltipState.renderTooltip };
                    return react_dom_1.createPortal(react_1.default.createElement(RectAnnotationTooltip, __assign({}, props, { ref: _this.tooltipRef })), _this.portalNode);
                }
                default:
                    return null;
            }
        };
        _this.tooltipRef = react_1.default.createRef();
        return _this;
    }
    AnnotationTooltipComponent.prototype.createPortalNode = function () {
        var container = document.getElementById(ANNOTATION_CONTAINER_ID);
        if (container) {
            this.portalNode = container;
        }
        else {
            this.portalNode = document.createElement('div');
            this.portalNode.id = ANNOTATION_CONTAINER_ID;
            document.body.appendChild(this.portalNode);
        }
    };
    AnnotationTooltipComponent.prototype.componentDidMount = function () {
        this.createPortalNode();
    };
    AnnotationTooltipComponent.prototype.componentDidUpdate = function () {
        // calling on componentDidUpdate because the annotation container can be
        // removed by another chart on the same page
        this.createPortalNode();
        if (!this.tooltipRef.current) {
            return;
        }
        var getChartContainerRef = this.props.getChartContainerRef;
        var chartContainerRef = getChartContainerRef();
        if (!chartContainerRef.current) {
            return;
        }
        var _a = this.props, tooltipState = _a.tooltipState, chartDimensions = _a.chartDimensions;
        if (!tooltipState || !tooltipState.isVisible || !this.portalNode) {
            return null;
        }
        var chartContainerBBox = chartContainerRef.current.getBoundingClientRect();
        var tooltipBBox = this.tooltipRef.current.getBoundingClientRect();
        var tooltipStyle = annotation_tooltip_1.getFinalAnnotationTooltipPosition(chartContainerBBox, chartDimensions, tooltipBBox, tooltipState.anchor);
        if (tooltipStyle.left) {
            this.portalNode.style.left = tooltipStyle.left;
        }
        if (tooltipStyle.top) {
            this.portalNode.style.top = tooltipStyle.top;
        }
    };
    AnnotationTooltipComponent.prototype.componentWillUnmount = function () {
        if (this.portalNode && this.portalNode.parentNode) {
            this.portalNode.parentNode.removeChild(this.portalNode);
        }
    };
    AnnotationTooltipComponent.prototype.renderAnnotationLineMarkers = function (annotationLines, id) {
        var chartDimensions = this.props.chartDimensions;
        var markers = [];
        annotationLines.forEach(function (line, index) {
            if (!line.marker) {
                return;
            }
            var _a = line.marker, icon = _a.icon, color = _a.color, position = _a.position;
            var style = {
                color: color,
                top: chartDimensions.top + position.top,
                left: chartDimensions.left + position.left,
            };
            var markerElement = (react_1.default.createElement("div", { className: "echAnnotation", style: __assign({}, style), key: "annotation-" + id + "-" + index }, icon));
            markers.push(markerElement);
        });
        return markers;
    };
    AnnotationTooltipComponent.prototype.renderAnnotationMarkers = function () {
        var _this = this;
        var _a = this.props, annotationDimensions = _a.annotationDimensions, annotationSpecs = _a.annotationSpecs;
        var markers = [];
        annotationDimensions.forEach(function (dimensions, id) {
            var annotationSpec = utils_1.getSpecsById(annotationSpecs, id);
            if (!annotationSpec) {
                return;
            }
            if (specs_1.isLineAnnotation(annotationSpec)) {
                var annotationLines = dimensions;
                var lineMarkers = _this.renderAnnotationLineMarkers(annotationLines, id);
                markers.push.apply(markers, __spread(lineMarkers));
            }
        });
        return markers;
    };
    AnnotationTooltipComponent.prototype.render = function () {
        var isChartEmpty = this.props.isChartEmpty;
        if (isChartEmpty) {
            return null;
        }
        return (react_1.default.createElement(react_1.default.Fragment, null,
            this.renderAnnotationMarkers(),
            this.renderTooltip()));
    };
    AnnotationTooltipComponent.displayName = 'AnnotationTooltip';
    return AnnotationTooltipComponent;
}(react_1.default.Component));
function RectAnnotationTooltipRender(props, ref) {
    var details = props.details, customTooltip = props.customTooltip;
    var tooltipContent = customTooltip ? customTooltip(details) : details;
    if (!tooltipContent) {
        return null;
    }
    return (react_1.default.createElement("div", { className: "echAnnotation__tooltip", ref: ref },
        react_1.default.createElement("div", { className: "echAnnotation__details" },
            react_1.default.createElement("div", { className: "echAnnotation__detailsText" }, tooltipContent))));
}
var RectAnnotationTooltip = react_1.default.forwardRef(RectAnnotationTooltipRender);
function LineAnnotationTooltipRender(props, ref) {
    var details = props.details, header = props.header;
    return (react_1.default.createElement("div", { className: "echAnnotation__tooltip", ref: ref },
        react_1.default.createElement("p", { className: "echAnnotation__header" }, header),
        react_1.default.createElement("div", { className: "echAnnotation__details" }, details)));
}
var LineAnnotationTooltip = react_1.default.forwardRef(LineAnnotationTooltipRender);
var mapStateToProps = function (state) {
    if (!is_initialized_1.isInitialized(state)) {
        return {
            isChartEmpty: true,
            chartDimensions: { top: 0, left: 0, width: 0, height: 0 },
            annotationDimensions: new Map(),
            annotationSpecs: [],
            tooltipState: null,
        };
    }
    return {
        isChartEmpty: is_chart_empty_1.isChartEmptySelector(state),
        chartDimensions: compute_chart_dimensions_1.computeChartDimensionsSelector(state).chartDimensions,
        annotationDimensions: compute_annotations_1.computeAnnotationDimensionsSelector(state),
        annotationSpecs: get_specs_1.getAnnotationSpecsSelector(state),
        tooltipState: get_annotation_tooltip_state_1.getAnnotationTooltipStateSelector(state),
    };
};
exports.AnnotationTooltip = react_redux_1.connect(mapStateToProps)(AnnotationTooltipComponent);
//# sourceMappingURL=annotation_tooltips.js.map