/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.naming;

import com.ca.commons.cbutil.CBBase64;
import com.ca.commons.cbutil.CBParse;
import com.ca.commons.naming.DN;
import com.ca.commons.naming.DXAttribute;
import com.ca.commons.naming.DXEntry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;

public class LdifUtility {
    private static boolean debug = false;
    private static boolean handleXML = false;
    private Hashtable params = null;
    private String filedir = null;
    private String cr = System.getProperty("line.separator", "\n");
    private static final Logger log = Logger.getLogger(LdifUtility.class.getName());

    public LdifUtility() {
    }

    public static void setSupportXML_LDIF_RFC(boolean state) {
        handleXML = state;
    }

    public LdifUtility(Hashtable params, String filedir) {
        this.params = params;
        this.filedir = filedir;
    }

    public void setFileDir(String filedir) {
        this.filedir = filedir + "\\";
    }

    public void setParams(Hashtable params) {
        this.params = params;
    }

    public String ldifEncode(Object o, int offset, boolean forceBase64Encoding) {
        if (!forceBase64Encoding) {
            return this.ldifEncode(o, offset);
        }
        String ret = ":: ";
        if (o.getClass().isArray()) {
            try {
                byte[] b = (byte[])o;
                ret = ret + CBBase64.binaryToString(b, offset + 3);
                return ret;
            }
            catch (ClassCastException e) {
                System.out.println("unable to cast array to byte array.");
            }
        }
        ret = ret + CBBase64.binaryToString(o.toString().getBytes(), offset + 3);
        return ret;
    }

    public String ldifEncode(Object o, int offset) {
        boolean base64Encode = false;
        boolean xmlEncode = false;
        if (!(o instanceof String)) {
            block17: {
                if (debug) {
                    System.out.println("found a " + o.getClass().toString());
                }
                if (o.getClass().isArray()) {
                    try {
                        byte[] b = (byte[])o;
                        String ret = ":: " + CBBase64.binaryToString(b, offset + 3);
                        if (debug) {
                            System.out.println("phenomenal - identified and wrote '" + ret + "'");
                        }
                        return ret;
                    }
                    catch (ClassCastException e) {
                        if (!debug) break block17;
                        System.out.println("unable to cast array to byte array.");
                    }
                }
            }
            return o.toString();
        }
        String s = o.toString();
        int len = s.length();
        if (len == 0) {
            return ": ";
        }
        char startChar = s.charAt(0);
        if ("\n\r :".indexOf(startChar) != -1) {
            base64Encode = true;
        } else if (startChar == '<') {
            if (handleXML && s.startsWith("<?xml ")) {
                xmlEncode = true;
            } else {
                base64Encode = true;
            }
        } else {
            char[] test = new char[len];
            s.getChars(0, len, test, 0);
            for (int i = 0; i < len; ++i) {
                if (test[i] <= '~' && test[i] >= ' ') continue;
                base64Encode = true;
                break;
            }
        }
        if (s.charAt(s.length() - 1) == ' ') {
            base64Encode = true;
        }
        if (base64Encode) {
            return this.translateToLdifBase64(s, offset);
        }
        if (xmlEncode) {
            return this.translateToLdifXML(s);
        }
        return ": " + s;
    }

    private String translateToLdifBase64(String s, int offset) {
        try {
            s = CBBase64.binaryToString(s.getBytes("UTF8"), offset + 3);
        }
        catch (UnsupportedEncodingException e) {
            log.log(Level.WARNING, "error utf8 encoding strings...", e);
            s = CBBase64.binaryToString(s.getBytes(), offset + 3);
        }
        return ":: " + s;
    }

    private String translateToLdifXML(String s) {
        StringBuffer xml = new StringBuffer(";transfer-rxer>:").append(this.cr).append(s);
        if (s.indexOf("\r") != -1) {
            CBParse.replaceAllBufferString(xml, "\r", "\r>");
        }
        if (s.indexOf("\n") != -1) {
            CBParse.replaceAllBufferString(xml, "\n", "\n>");
        }
        return xml.toString();
    }

    public void writeLdifEntry(String dn, FileWriter saveFile, String originalPrefix, String replacementPrefix, Attributes atts) throws NamingException, IOException {
        Attribute oc;
        if (atts == null) {
            log.info("no attributes available for " + dn);
            return;
        }
        if (originalPrefix != null && dn.endsWith(originalPrefix)) {
            if (debug) {
                System.out.println("original DN = '" + dn + "'");
            }
            dn = dn.substring(0, dn.length() - originalPrefix.length()) + replacementPrefix;
            if (debug) {
                System.out.println("after replacement DN = '" + dn + "'");
            }
        }
        if ((oc = atts.get("oc")) != null) {
            if (oc instanceof DXAttribute) {
                ((DXAttribute)oc).setName("objectClass");
            }
        } else {
            oc = atts.get("objectclass");
        }
        if (oc == null) {
            oc = atts.get("objectClass");
        }
        if (oc == null && dn.endsWith("cn=schema")) {
            oc = new BasicAttribute("oc", "schema");
        }
        if (oc == null) {
            log.info("unable to identify object class for " + dn + " - skipping entry");
            return;
        }
        if (debug) {
            System.out.println("dn" + this.ldifEncode(dn, 2));
        } else {
            saveFile.write("dn" + this.ldifEncode(dn, 2) + "\n");
        }
        NamingEnumeration<?> ocs = oc.getAll();
        while (ocs.hasMore()) {
            if (debug) {
                System.out.println(oc.getID() + ": " + ocs.next());
                continue;
            }
            saveFile.write(oc.getID() + this.ldifEncode(ocs.next(), oc.getID().length()) + "\n");
        }
        NamingEnumeration<? extends Attribute> allAtts = atts.getAll();
        while (allAtts.hasMore()) {
            String attName;
            Attribute currentAtt = allAtts.next();
            boolean binary = false;
            if (currentAtt instanceof DXAttribute) {
                boolean bl = binary = !((DXAttribute)currentAtt).isString();
            }
            if ((attName = currentAtt.getID()).equals("dn") || attName.equals(oc.getID())) continue;
            NamingEnumeration<?> values = currentAtt.getAll();
            while (values.hasMore()) {
                Object value = values.next();
                if (value == null) continue;
                if (debug) {
                    System.out.println("value class = " + value.getClass().toString() + "   : " + value);
                    System.out.println(attName + ": " + value.toString());
                    continue;
                }
                if (binary) {
                    saveFile.write(attName + this.ldifEncode(value, attName.length(), true) + "\n");
                    continue;
                }
                saveFile.write(attName + this.ldifEncode(value, attName.length()) + "\n");
            }
        }
        if (!debug) {
            saveFile.write("\n");
            saveFile.flush();
        }
    }

    public void ldifDecode(String parseableLine, DXEntry newEntry) {
        block20: {
            boolean isBinary = false;
            int breakpos = parseableLine.indexOf(58);
            if (breakpos < 0) {
                log.warning("Error - illegal line in ldif file\n" + parseableLine);
                return;
            }
            String attribute = parseableLine.substring(0, breakpos);
            Object value = null;
            int attLen = attribute.length();
            if (attribute.equals("oc")) {
                attribute = "objectClass";
            }
            int startpos = 2;
            if (parseableLine.length() <= breakpos + 1) {
                value = "";
            } else if (parseableLine.charAt(breakpos + 1) == ':') {
                value = this.getBase64Value(parseableLine, attLen, startpos, attribute);
                if (!(value instanceof String)) {
                    isBinary = true;
                }
            } else {
                if (parseableLine.charAt(attLen + 1) != ' ') {
                    startpos = 1;
                }
                value = parseableLine.substring(attLen + startpos);
                value = this.expandValueParams(value);
            }
            if ("dn".equalsIgnoreCase(attribute)) {
                if (value instanceof String) {
                    DN dn = new DN((String)value);
                    if (dn.error()) {
                        log.warning("Error trying to initialise ldif DN: \n" + dn.getError());
                    } else {
                        newEntry.putDN(dn);
                    }
                } else {
                    try {
                        DN dn = new DN(new String((byte[])value, "UTF8"));
                        if (dn.error()) {
                            log.log(Level.WARNING, "Error trying to initialise ldif DN: \n", dn.getError());
                            break block20;
                        }
                        newEntry.putDN(dn);
                    }
                    catch (UnsupportedEncodingException e) {}
                }
            } else if (attribute != null) {
                Attribute existing = newEntry.get(attribute);
                if (existing == null) {
                    DXAttribute att = new DXAttribute(attribute, value);
                    att.setString(!isBinary);
                    newEntry.put(att);
                } else {
                    existing.add(value);
                    newEntry.put(existing);
                }
            }
        }
    }

    private Object getBase64Value(String parseableLine, int attLen, int startpos, String attribute) {
        byte[] testBytes;
        byte[] rawBinaryData;
        if (parseableLine.charAt(attLen + 2) == ' ') {
            startpos = 3;
        }
        if ((rawBinaryData = CBBase64.stringToBinary(parseableLine.substring(attribute.length() + startpos))).length > 256) {
            testBytes = new byte[256];
            System.arraycopy(rawBinaryData, 0, testBytes, 0, 256);
        } else {
            testBytes = rawBinaryData;
        }
        if (CBParse.isUTF8(testBytes)) {
            try {
                return new String(rawBinaryData, "UTF-8");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return rawBinaryData;
    }

    public DXEntry readLdifEntry(BufferedReader textReader) throws IOException {
        DXEntry entry = new DXEntry();
        String line = "";
        String firstLine = "";
        StringBuffer multiLineText = null;
        while ((line = textReader.readLine()) != null) {
            if (line.length() > 0 && line.charAt(0) == ' ') {
                if (multiLineText == null) {
                    multiLineText = new StringBuffer(firstLine);
                }
                multiLineText.append(line.substring(1));
            } else if (line.length() > 0 && line.charAt(0) == '>') {
                if (multiLineText == null) {
                    multiLineText = new StringBuffer(firstLine);
                }
                multiLineText.append(line.substring(1)).append(this.cr);
            } else if (!(firstLine.length() > 1 && firstLine.charAt(0) == '#' || firstLine.length() <= 2 && multiLineText == null)) {
                if (multiLineText != null) {
                    this.ldifDecode(multiLineText.toString(), entry);
                } else {
                    this.ldifDecode(firstLine, entry);
                }
                multiLineText = null;
            }
            if (line == null || line.equals("")) {
                return entry;
            }
            firstLine = line;
        }
        if (entry.getDN().size() > 0) {
            if (firstLine != null && firstLine.trim().length() > 0) {
                this.ldifDecode(firstLine, entry);
            }
            return entry;
        }
        return null;
    }

    public Object expandValueParams(Object value) {
        if (this.params != null) {
            Enumeration keys = this.params.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String keyvalue = (String)this.params.get(key);
                String oldValue = (String)value;
                int index = oldValue.indexOf(key);
                if (index <= -1) continue;
                String newValue = oldValue.substring(0, index) + keyvalue + oldValue.substring(index + key.length(), oldValue.length());
                System.out.println(newValue);
                value = newValue;
            }
        }
        if (this.filedir != null) {
            String oldValue = (String)value;
            String match = "< file://";
            int index = oldValue.toLowerCase().indexOf(match);
            if (index > -1) {
                String filename = this.filedir + oldValue.substring(index + 9, oldValue.length());
                File file = new File(filename);
                try {
                    byte[] bytes;
                    int read;
                    FileInputStream input = new FileInputStream(file);
                    int length = (int)file.length();
                    if (length > 0 && (read = input.read(bytes = new byte[length])) > 0) {
                        value = bytes;
                    }
                    input.close();
                }
                catch (IOException e) {
                    System.out.println("Error opening the file!" + e);
                }
            }
        }
        return value;
    }
}

