/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.session;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.data.StructUtils;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.OffsetBookmark;
import org.openstreetmap.josm.gui.layer.AbstractTileSourceLayer;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.imagery.ImageryFilterSettings;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.session.SessionAwareReadApply;
import org.openstreetmap.josm.io.session.SessionLayerImporter;
import org.openstreetmap.josm.io.session.SessionReader;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImagerySessionImporter
implements SessionLayerImporter {
    @Override
    public Layer load(Element elem, SessionReader.ImportSupport support, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
        ImageryFilterSettings filterSettings;
        String version = elem.getAttribute("version");
        if (!"0.1".equals(version)) {
            throw new IllegalDataException(I18n.tr("Version ''{0}'' of meta data for imagery layer is not supported. Expected: 0.1", version));
        }
        Map<String, String> attributes = ImagerySessionImporter.readProperties(elem);
        ImageryInfo.ImageryPreferenceEntry prefEntry = StructUtils.deserializeStruct(attributes, ImageryInfo.ImageryPreferenceEntry.class);
        ImageryInfo info = new ImageryInfo(prefEntry);
        ImageryLayer layer = ImageryLayer.create(info);
        Utils.instanceOfThen(layer, AbstractTileSourceLayer.class, tsLayer -> {
            Element offsetEl;
            String zoomStr;
            tsLayer.getDisplaySettings().applyFromPropertiesMap(attributes);
            if (!tsLayer.getDisplaySettings().isAutoZoom() && (zoomStr = (String)attributes.get("zoom-level")) != null) {
                support.addPostLayersTask(() -> {
                    try {
                        tsLayer.setZoomLevel(Integer.parseInt(zoomStr));
                    }
                    catch (NumberFormatException e) {
                        Logging.warn(e);
                    }
                });
            }
            if ((offsetEl = ImagerySessionImporter.getFirstElementByTagName(elem, "offset")) != null) {
                Map<String, String> offsetAttributes = ImagerySessionImporter.readProperties(offsetEl);
                OffsetBookmark offset = OffsetBookmark.fromPropertiesMap(offsetAttributes);
                tsLayer.getDisplaySettings().setOffsetBookmark(offset);
            }
        });
        Element filtersEl = ImagerySessionImporter.getFirstElementByTagName(elem, "filters");
        if (filtersEl != null && (filterSettings = layer.getFilterSettings()) != null) {
            Map<String, String> filtersProps = ImagerySessionImporter.readProperties(filtersEl);
            filterSettings.getProcessors().stream().flatMap(Utils.castToStream(SessionAwareReadApply.class)).forEach(proc -> proc.applyFromPropertiesMap(filtersProps));
        }
        return layer;
    }

    private static Element getFirstElementByTagName(Element el, String name) {
        NodeList nl = el.getElementsByTagName(name);
        if (nl.getLength() == 0) {
            return null;
        }
        return (Element)nl.item(0);
    }

    private static Map<String, String> readProperties(Element elem) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        NodeList nodes = elem.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || node.getChildNodes().getLength() > 1) continue;
            Element e = (Element)node;
            attributes.put(e.getTagName(), e.getTextContent());
        }
        return attributes;
    }
}

