/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.ParametrizedEnumProperty;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.ShowHideButtonListener;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.DialogsPanel;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.help.Helpful;
import org.openstreetmap.josm.gui.preferences.PreferenceDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.SubPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.WindowGeometry;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.spi.preferences.PreferenceChangeEvent;
import org.openstreetmap.josm.spi.preferences.PreferenceChangedListener;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;

public class ToggleDialog
extends JPanel
implements ShowHideButtonListener,
Helpful,
AWTEventListener,
Destroyable,
PreferenceChangedListener {
    public static final BooleanProperty PROP_DYNAMIC_BUTTONS = new BooleanProperty("dialog.dynamic.buttons", false);
    private final transient ParametrizedEnumProperty<ButtonHidingType> propButtonHiding = new ParametrizedEnumProperty<ButtonHidingType>(ButtonHidingType.class, ButtonHidingType.DYNAMIC){

        @Override
        protected String getKey(String ... params) {
            return ToggleDialog.this.preferencePrefix + ".buttonhiding";
        }

        @Override
        protected ButtonHidingType parse(String s) {
            try {
                return (ButtonHidingType)((Object)super.parse(s));
            }
            catch (IllegalArgumentException e) {
                Logging.trace(e);
                return Boolean.parseBoolean(s) ? ButtonHidingType.DYNAMIC : ButtonHidingType.ALWAYS_SHOWN;
            }
        }
    };
    protected final ToggleDialogAction toggleAction;
    protected String preferencePrefix;
    protected final String name;
    protected DialogsPanel dialogsPanel;
    protected TitleBar titleBar;
    protected boolean isShowing;
    protected boolean isDocked;
    protected boolean isCollapsed;
    protected ButtonHidingType buttonHiding;
    private int preferredHeight;
    protected JDialog detachedDialog;
    protected JToggleButton button;
    private JPanel buttonsPanel;
    private final transient List<Action> buttonActions = new ArrayList<Action>();
    protected JCheckBoxMenuItem windowMenuItem;
    private final JRadioButtonMenuItem alwaysShown = new JRadioButtonMenuItem(new AbstractAction(I18n.tr("Always shown", new Object[0])){

        @Override
        public void actionPerformed(ActionEvent e) {
            ToggleDialog.this.setIsButtonHiding(ButtonHidingType.ALWAYS_SHOWN);
        }
    });
    private final JRadioButtonMenuItem dynamic = new JRadioButtonMenuItem(new AbstractAction(I18n.tr("Dynamic", new Object[0])){

        @Override
        public void actionPerformed(ActionEvent e) {
            ToggleDialog.this.setIsButtonHiding(ButtonHidingType.DYNAMIC);
        }
    });
    private final JRadioButtonMenuItem alwaysHidden = new JRadioButtonMenuItem(new AbstractAction(I18n.tr("Always hidden", new Object[0])){

        @Override
        public void actionPerformed(ActionEvent e) {
            ToggleDialog.this.setIsButtonHiding(ButtonHidingType.ALWAYS_HIDDEN);
        }
    });
    protected Class<? extends PreferenceSetting> preferenceClass;

    public ToggleDialog(String name, String iconName, String tooltip, Shortcut shortcut, int preferredHeight) {
        this(name, iconName, tooltip, shortcut, preferredHeight, false);
    }

    public ToggleDialog(String name, String iconName, String tooltip, Shortcut shortcut, int preferredHeight, boolean defShow) {
        this(name, iconName, tooltip, shortcut, preferredHeight, defShow, null);
    }

    public ToggleDialog(String name, String iconName, String tooltip, Shortcut shortcut, int preferredHeight, boolean defShow, Class<? extends PreferenceSetting> prefClass) {
        super(new BorderLayout());
        this.preferencePrefix = iconName;
        this.name = name;
        this.preferenceClass = prefClass;
        this.setPreferredSize(new Dimension(0, preferredHeight));
        this.setMinimumSize(new Dimension(0, 0));
        this.preferredHeight = Config.getPref().getInt(this.preferencePrefix + ".preferredHeight", preferredHeight);
        this.toggleAction = new ToggleDialogAction(name, "dialogs/" + iconName, tooltip, shortcut, this.helpTopic());
        this.isShowing = Config.getPref().getBoolean(this.preferencePrefix + ".visible", defShow);
        this.isDocked = Config.getPref().getBoolean(this.preferencePrefix + ".docked", true);
        this.isCollapsed = Config.getPref().getBoolean(this.preferencePrefix + ".minimized", false);
        this.buttonHiding = this.propButtonHiding.get(new String[0]);
        this.titleBar = new TitleBar(name, iconName);
        this.add((Component)this.titleBar, "North");
        this.setBorder(BorderFactory.createEtchedBorder());
        MainApplication.redirectToMainContentPane(this);
        Config.getPref().addPreferenceChangeListener(this);
        this.registerInWindowMenu();
    }

    protected void registerInWindowMenu() {
        this.windowMenuItem = MainMenu.addWithCheckbox(MainApplication.getMenu().windowMenu, (JosmAction)this.getToggleAction(), MainMenu.WINDOW_MENU_GROUP.TOGGLE_DIALOG);
    }

    public void showDialog() {
        this.setIsShowing(true);
        if (!this.isDocked) {
            this.detach();
        } else {
            this.dock();
            this.setVisible(true);
        }
        this.setIsShowing(true);
        if (this.windowMenuItem != null) {
            this.windowMenuItem.setState(true);
        }
        this.toggleAction.putValue("selected", Boolean.FALSE);
        this.toggleAction.putValue("selected", Boolean.TRUE);
    }

    public void unfurlDialog() {
        if (this.isDialogInDefaultView()) {
            return;
        }
        if (this.isDialogInCollapsedView()) {
            this.expand();
            this.dialogsPanel.reconstruct(DialogsPanel.Action.COLLAPSED_TO_DEFAULT, this);
        } else if (!this.isDialogShowing()) {
            this.showDialog();
            if (this.isDocked && this.isCollapsed) {
                this.expand();
            }
            if (this.isDocked) {
                this.dialogsPanel.reconstruct(DialogsPanel.Action.INVISIBLE_TO_DEFAULT, this);
            }
            this.showNotify();
        }
    }

    @Override
    public void buttonHidden() {
        if (((Boolean)this.toggleAction.getValue("selected")).booleanValue()) {
            this.toggleAction.actionPerformed(null);
        }
    }

    @Override
    public void buttonShown() {
        this.unfurlDialog();
    }

    public void hideDialog() {
        this.closeDetachedDialog();
        this.setVisible(false);
        if (this.windowMenuItem != null) {
            this.windowMenuItem.setState(false);
        }
        this.setIsShowing(false);
        this.toggleAction.putValue("selected", Boolean.FALSE);
    }

    protected void dock() {
        this.detachedDialog = null;
        this.titleBar.setVisible(true);
        this.setIsDocked(true);
    }

    protected void detach() {
        this.setContentVisible(true);
        this.setVisible(true);
        this.titleBar.setVisible(false);
        if (!GraphicsEnvironment.isHeadless()) {
            this.detachedDialog = new DetachedDialog();
            this.detachedDialog.setVisible(true);
        }
        this.setIsShowing(true);
        this.setIsDocked(false);
    }

    public void collapse() {
        if (!this.isDialogInDefaultView()) {
            throw new IllegalStateException();
        }
        this.setContentVisible(false);
        this.setIsCollapsed(true);
        this.setPreferredSize(new Dimension(0, 20));
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.setMinimumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.titleBar.lblMinimized.setIcon(ImageProvider.get("misc", "minimized"));
    }

    protected void expand() {
        if (!this.isDialogInCollapsedView()) {
            throw new IllegalStateException();
        }
        this.setContentVisible(true);
        this.setIsCollapsed(false);
        this.setPreferredSize(new Dimension(0, this.preferredHeight));
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.titleBar.lblMinimized.setIcon(ImageProvider.get("misc", "normal"));
    }

    protected void setContentVisible(boolean visible) {
        Component[] comps;
        for (Component comp : comps = this.getComponents()) {
            if (comp == this.titleBar || visible && comp == this.buttonsPanel && this.buttonHiding == ButtonHidingType.ALWAYS_HIDDEN) continue;
            comp.setVisible(visible);
        }
    }

    @Override
    public void destroy() {
        this.dialogsPanel = null;
        this.rememberHeight();
        this.closeDetachedDialog();
        if (this.isShowing) {
            this.hideNotify();
        }
        MainApplication.getMenu().windowMenu.remove(this.windowMenuItem);
        try {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }
        catch (SecurityException e) {
            Logging.log(Logging.LEVEL_ERROR, "Unable to remove AWT event listener", e);
        }
        Config.getPref().removePreferenceChangeListener(this);
        GuiHelper.destroyComponents(this, false);
        this.titleBar.destroy();
        this.titleBar = null;
        this.buttonActions.clear();
    }

    public void closeDetachedDialog() {
        if (this.detachedDialog != null) {
            this.detachedDialog.setVisible(false);
            this.detachedDialog.getContentPane().removeAll();
            this.detachedDialog.dispose();
        }
    }

    public void showNotify() {
    }

    public void hideNotify() {
    }

    public AbstractAction getToggleAction() {
        return this.toggleAction;
    }

    public String getPreferencePrefix() {
        return this.preferencePrefix;
    }

    public void setDialogsPanel(DialogsPanel dialogsPanel) {
        this.dialogsPanel = dialogsPanel;
    }

    @Override
    public String getName() {
        return "toggleDialog." + this.preferencePrefix;
    }

    public void setTitle(String title) {
        if (this.titleBar != null) {
            this.titleBar.setTitle(title);
        }
        if (this.detachedDialog != null) {
            this.detachedDialog.setTitle(title);
        }
    }

    protected void setIsShowing(boolean val) {
        this.isShowing = val;
        Config.getPref().putBoolean(this.preferencePrefix + ".visible", val);
        this.stateChanged();
    }

    protected void setIsDocked(boolean val) {
        if (this.buttonsPanel != null) {
            this.buttonsPanel.setVisible(!val || this.buttonHiding != ButtonHidingType.ALWAYS_HIDDEN);
        }
        this.isDocked = val;
        Config.getPref().putBoolean(this.preferencePrefix + ".docked", val);
        this.stateChanged();
    }

    protected void setIsCollapsed(boolean val) {
        this.isCollapsed = val;
        Config.getPref().putBoolean(this.preferencePrefix + ".minimized", val);
        this.stateChanged();
    }

    protected void setIsButtonHiding(ButtonHidingType val) {
        this.buttonHiding = val;
        this.propButtonHiding.put(val, new String[0]);
        this.refreshHidingButtons();
    }

    public int getPreferredHeight() {
        return this.preferredHeight;
    }

    @Override
    public String helpTopic() {
        String help = this.getClass().getName();
        help = help.substring(help.lastIndexOf(46) + 1, help.length() - 6);
        return "Dialog/" + help;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public boolean isDialogShowing() {
        return this.isShowing;
    }

    public boolean isDialogInDefaultView() {
        return this.isShowing && this.isDocked && !this.isCollapsed;
    }

    public boolean isDialogInCollapsedView() {
        return this.isShowing && this.isDocked && this.isCollapsed;
    }

    public void setButton(JToggleButton button) {
        this.button = button;
    }

    public JToggleButton getButton() {
        return this.button;
    }

    protected Dimension getDefaultDetachedSize() {
        return new Dimension(this.dialogsPanel.getWidth(), this.preferredHeight);
    }

    protected void toggleButtonHook() {
    }

    protected boolean dockWhenClosingDetachedDlg() {
        return true;
    }

    protected void stateChanged() {
    }

    protected Component createLayout(Component data, boolean scroll, Collection<SideButton> buttons) {
        return this.createLayout(data, scroll, buttons, null);
    }

    @SafeVarargs
    protected final Component createLayout(Component data, boolean scroll, Collection<SideButton> firstButtons, Collection<SideButton> ... nextButtons) {
        if (scroll) {
            JScrollPane sp = new JScrollPane(data);
            if (!(data instanceof Scrollable)) {
                GuiHelper.setDefaultIncrement(sp);
            }
            data = sp;
        }
        LinkedList<Collection<SideButton>> buttons = new LinkedList<Collection<SideButton>>();
        buttons.addFirst(firstButtons);
        if (nextButtons != null) {
            buttons.addAll(Arrays.asList(nextButtons));
        }
        this.add(data, "Center");
        if (!buttons.isEmpty() && buttons.get(0) != null && !((Collection)buttons.get(0)).isEmpty()) {
            this.buttonsPanel = new JPanel(new GridLayout(buttons.size(), 1));
            for (Collection collection : buttons) {
                if (collection == null) continue;
                JPanel buttonRowPanel = new JPanel(Config.getPref().getBoolean("dialog.align.left", false) ? new FlowLayout(0) : new GridLayout(1, collection.size()));
                this.buttonsPanel.add(buttonRowPanel);
                for (SideButton button : collection) {
                    buttonRowPanel.add(button);
                    Action action = button.getAction();
                    if (action != null) {
                        this.buttonActions.add(action);
                        continue;
                    }
                    Logging.warn("Button " + button + " doesn't have action defined");
                    Logging.error(new Exception());
                }
            }
            this.add((Component)this.buttonsPanel, "South");
            this.dynamicButtonsPropertyChanged();
        } else {
            this.titleBar.buttonsHide.setVisible(false);
        }
        this.titleBar.registerMouseListener();
        return data;
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        if (event instanceof MouseEvent && this.isShowing() && !this.isCollapsed && this.isDocked && this.buttonHiding == ButtonHidingType.DYNAMIC && this.buttonsPanel != null) {
            Rectangle b = this.getBounds();
            b.setLocation(this.getLocationOnScreen());
            if (b.contains(((MouseEvent)event).getLocationOnScreen())) {
                if (!this.buttonsPanel.isVisible()) {
                    this.buttonsPanel.setVisible(true);
                }
            } else if (this.buttonsPanel.isVisible()) {
                this.buttonsPanel.setVisible(false);
            }
        }
    }

    @Override
    public void preferenceChanged(PreferenceChangeEvent e) {
        if (e.getKey().equals(PROP_DYNAMIC_BUTTONS.getKey())) {
            this.dynamicButtonsPropertyChanged();
        }
    }

    private void dynamicButtonsPropertyChanged() {
        boolean propEnabled = PROP_DYNAMIC_BUTTONS.get();
        try {
            if (propEnabled) {
                Toolkit.getDefaultToolkit().addAWTEventListener(this, 32L);
            } else {
                Toolkit.getDefaultToolkit().removeAWTEventListener(this);
            }
        }
        catch (SecurityException e) {
            Logging.log(Logging.LEVEL_ERROR, "Unable to add/remove AWT event listener", e);
        }
        this.titleBar.buttonsHide.setVisible(propEnabled);
        this.refreshHidingButtons();
    }

    private void refreshHidingButtons() {
        this.titleBar.buttonsHide.setIcon(ImageProvider.get("misc", this.buttonHiding != ButtonHidingType.ALWAYS_SHOWN ? "buttonhide" : "buttonshow"));
        this.titleBar.buttonsHide.setEnabled(this.buttonHiding != ButtonHidingType.ALWAYS_HIDDEN);
        if (this.buttonsPanel != null) {
            this.buttonsPanel.setVisible(this.buttonHiding != ButtonHidingType.ALWAYS_HIDDEN || !this.isDocked);
        }
        this.stateChanged();
    }

    public int getLastHeight() {
        return Config.getPref().getInt(this.preferencePrefix + ".lastHeight", this.preferredHeight);
    }

    public void rememberHeight() {
        int h = this.getHeight();
        Config.getPref().put(this.preferencePrefix + ".lastHeight", Integer.toString(h));
    }

    private class DetachedDialog
    extends JDialog {
        DetachedDialog() {
            super(GuiHelper.getFrameForComponent(MainApplication.getMainFrame()));
            this.getContentPane().add(ToggleDialog.this);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    DetachedDialog.this.rememberGeometry();
                    DetachedDialog.this.getContentPane().removeAll();
                    DetachedDialog.this.dispose();
                    if (ToggleDialog.this.dockWhenClosingDetachedDlg()) {
                        ToggleDialog.this.dock();
                        if (ToggleDialog.this.isDialogInCollapsedView()) {
                            ToggleDialog.this.setContentVisible(false);
                            ToggleDialog.this.dialogsPanel.reconstruct(DialogsPanel.Action.ELEMENT_SHRINKS, null);
                        } else {
                            ToggleDialog.this.dialogsPanel.reconstruct(DialogsPanel.Action.INVISIBLE_TO_DEFAULT, ToggleDialog.this);
                        }
                    } else {
                        ToggleDialog.this.hideDialog();
                        ToggleDialog.this.hideNotify();
                    }
                }
            });
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentMoved(ComponentEvent e) {
                    DetachedDialog.this.rememberGeometry();
                }

                @Override
                public void componentResized(ComponentEvent e) {
                    DetachedDialog.this.rememberGeometry();
                }
            });
            try {
                new WindowGeometry(ToggleDialog.this.preferencePrefix + ".geometry").applySafe(this);
            }
            catch (WindowGeometry.WindowGeometryException e) {
                Logging.debug(e);
                ToggleDialog.this.setPreferredSize(ToggleDialog.this.getDefaultDetachedSize());
                this.pack();
                this.setLocationRelativeTo(MainApplication.getMainFrame());
            }
            super.setTitle(ToggleDialog.this.titleBar.getTitle());
            HelpUtil.setHelpContext(this.getRootPane(), ToggleDialog.this.helpTopic());
        }

        protected void rememberGeometry() {
            if (ToggleDialog.this.detachedDialog != null && ToggleDialog.this.detachedDialog.isShowing()) {
                new WindowGeometry(ToggleDialog.this.detachedDialog).remember(ToggleDialog.this.preferencePrefix + ".geometry");
            }
        }
    }

    protected class TitleBar
    extends JPanel
    implements Destroyable {
        private final JLabel lblMinimized;
        private final JLabel lblTitle;
        private final JComponent lblTitleWeak;
        private final JButton buttonsHide;
        private DialogPopupMenu popupMenu;
        private MouseEventHandler mouseEventHandler;

        public TitleBar(String toggleDialogName, String iconName) {
            this.setLayout(new GridBagLayout());
            this.lblMinimized = new JLabel(ImageProvider.get("misc", "normal"));
            this.add(this.lblMinimized);
            ImageIcon icon = ImageProvider.get("dialogs", iconName, ImageProvider.ImageSizes.SMALLICON);
            this.lblTitle = new JLabel("", icon, 11);
            this.lblTitle.setIconTextGap(8);
            JPanel conceal = new JPanel();
            conceal.add(this.lblTitle);
            conceal.setVisible(false);
            this.add((Component)conceal, GBC.std());
            this.lblTitleWeak = new JComponent(){

                @Override
                public void paintComponent(Graphics g) {
                    TitleBar.this.lblTitle.paint(g);
                }
            };
            this.lblTitleWeak.setPreferredSize(new Dimension(Integer.MAX_VALUE, 20));
            this.lblTitleWeak.setMinimumSize(new Dimension(0, 20));
            this.add((Component)this.lblTitleWeak, GBC.std().fill(2));
            this.buttonsHide = new JButton(ImageProvider.get("misc", ToggleDialog.this.buttonHiding != ButtonHidingType.ALWAYS_SHOWN ? "buttonhide" : "buttonshow"));
            this.buttonsHide.setToolTipText(I18n.tr("Toggle dynamic buttons", new Object[0]));
            this.buttonsHide.setBorder(BorderFactory.createEmptyBorder());
            this.buttonsHide.addActionListener(e -> {
                JRadioButtonMenuItem item = ToggleDialog.this.buttonHiding == ButtonHidingType.DYNAMIC ? ToggleDialog.this.alwaysShown : ToggleDialog.this.dynamic;
                item.setSelected(true);
                item.getAction().actionPerformed(null);
            });
            this.add(this.buttonsHide);
            if (ToggleDialog.this.preferenceClass != null) {
                JButton pref = new JButton(ImageProvider.get("preference", ImageProvider.ImageSizes.SMALLICON));
                pref.setToolTipText(I18n.tr("Open preferences for this panel", new Object[0]));
                pref.setBorder(BorderFactory.createEmptyBorder());
                pref.addActionListener(e -> {
                    PreferenceDialog p = new PreferenceDialog((Component)MainApplication.getMainFrame());
                    if (TabPreferenceSetting.class.isAssignableFrom(ToggleDialog.this.preferenceClass)) {
                        p.selectPreferencesTabByClass(ToggleDialog.this.preferenceClass);
                    } else if (SubPreferenceSetting.class.isAssignableFrom(ToggleDialog.this.preferenceClass)) {
                        p.selectSubPreferencesTabByClass(ToggleDialog.this.preferenceClass);
                    }
                    p.setVisible(true);
                });
                this.add(pref);
            }
            JButton sticky = new JButton(ImageProvider.get("misc", "sticky"));
            sticky.setToolTipText(I18n.tr("Undock the panel", new Object[0]));
            sticky.setBorder(BorderFactory.createEmptyBorder());
            sticky.addActionListener(e -> {
                ToggleDialog.this.detach();
                ToggleDialog.this.dialogsPanel.reconstruct(DialogsPanel.Action.ELEMENT_SHRINKS, null);
            });
            this.add(sticky);
            JButton close = new JButton(ImageProvider.get("misc", "close"));
            close.setToolTipText(I18n.tr("Close this panel. You can reopen it with the buttons in the left toolbar.", new Object[0]));
            close.setBorder(BorderFactory.createEmptyBorder());
            close.addActionListener(e -> {
                ToggleDialog.this.hideDialog();
                ToggleDialog.this.dialogsPanel.reconstruct(DialogsPanel.Action.ELEMENT_SHRINKS, null);
                ToggleDialog.this.hideNotify();
            });
            this.add(close);
            this.setToolTipText(I18n.tr("Click to minimize/maximize the panel content", new Object[0]));
            this.setTitle(toggleDialogName);
        }

        public void setTitle(String title) {
            this.lblTitle.setText(title);
            this.lblTitleWeak.repaint();
        }

        public String getTitle() {
            return this.lblTitle.getText();
        }

        public final void registerMouseListener() {
            this.popupMenu = new DialogPopupMenu();
            this.mouseEventHandler = new MouseEventHandler();
            this.addMouseListener(this.mouseEventHandler);
        }

        @Override
        public void destroy() {
            this.removeMouseListener(this.mouseEventHandler);
            this.mouseEventHandler = null;
            this.popupMenu = null;
        }

        class MouseEventHandler
        extends PopupMenuLauncher {
            MouseEventHandler() {
                super(TitleBar.this.popupMenu);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    if (ToggleDialog.this.isCollapsed) {
                        ToggleDialog.this.expand();
                        ToggleDialog.this.dialogsPanel.reconstruct(DialogsPanel.Action.COLLAPSED_TO_DEFAULT, ToggleDialog.this);
                    } else {
                        ToggleDialog.this.collapse();
                        ToggleDialog.this.dialogsPanel.reconstruct(DialogsPanel.Action.ELEMENT_SHRINKS, null);
                    }
                }
            }
        }

        public class DialogPopupMenu
        extends JPopupMenu {
            DialogPopupMenu() {
                ToggleDialog.this.alwaysShown.setSelected(ToggleDialog.this.buttonHiding == ButtonHidingType.ALWAYS_SHOWN);
                ToggleDialog.this.dynamic.setSelected(ToggleDialog.this.buttonHiding == ButtonHidingType.DYNAMIC);
                ToggleDialog.this.alwaysHidden.setSelected(ToggleDialog.this.buttonHiding == ButtonHidingType.ALWAYS_HIDDEN);
                ButtonGroup buttonHidingGroup = new ButtonGroup();
                JMenu buttonHidingMenu = new JMenu(I18n.tr("Side buttons", new Object[0]));
                for (JRadioButtonMenuItem rb : new JRadioButtonMenuItem[]{ToggleDialog.this.alwaysShown, ToggleDialog.this.dynamic, ToggleDialog.this.alwaysHidden}) {
                    buttonHidingGroup.add(rb);
                    buttonHidingMenu.add(rb);
                }
                this.add(buttonHidingMenu);
                for (Action action : ToggleDialog.this.buttonActions) {
                    this.add(action);
                }
            }
        }
    }

    public final class ToggleDialogAction
    extends JosmAction {
        private ToggleDialogAction(String name, String iconName, String tooltip, Shortcut shortcut, String helpId) {
            super(name, iconName, tooltip, shortcut, false, false);
            this.setHelpId(helpId);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ToggleDialog.this.toggleButtonHook();
            if (this.getValue("toolbarbutton") instanceof JButton) {
                ((JButton)this.getValue("toolbarbutton")).setSelected(!ToggleDialog.this.isShowing);
            }
            if (ToggleDialog.this.isShowing) {
                ToggleDialog.this.hideDialog();
                if (ToggleDialog.this.dialogsPanel != null) {
                    ToggleDialog.this.dialogsPanel.reconstruct(DialogsPanel.Action.ELEMENT_SHRINKS, null);
                }
                ToggleDialog.this.hideNotify();
            } else {
                ToggleDialog.this.showDialog();
                if (ToggleDialog.this.isDocked && ToggleDialog.this.isCollapsed) {
                    ToggleDialog.this.expand();
                }
                if (ToggleDialog.this.isDocked && ToggleDialog.this.dialogsPanel != null) {
                    ToggleDialog.this.dialogsPanel.reconstruct(DialogsPanel.Action.INVISIBLE_TO_DEFAULT, ToggleDialog.this);
                }
                ToggleDialog.this.showNotify();
            }
        }

        public String toString() {
            return "ToggleDialogAction [" + ToggleDialog.this + ']';
        }
    }

    public static enum ButtonHidingType {
        ALWAYS_SHOWN,
        ALWAYS_HIDDEN,
        DYNAMIC;

    }
}

