/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine.memory;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.control.CompositeCache;
import org.apache.commons.jcs.engine.control.group.GroupAttrName;
import org.apache.commons.jcs.engine.memory.AbstractMemoryCache;
import org.apache.commons.jcs.engine.memory.util.MemoryElementDescriptor;
import org.apache.commons.jcs.engine.stats.StatElement;
import org.apache.commons.jcs.engine.stats.behavior.IStatElement;
import org.apache.commons.jcs.engine.stats.behavior.IStats;
import org.apache.commons.jcs.utils.struct.DoubleLinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractDoubleLinkedListMemoryCache<K, V>
extends AbstractMemoryCache<K, V> {
    private static final Log log = LogFactory.getLog(AbstractDoubleLinkedListMemoryCache.class);
    protected DoubleLinkedList<MemoryElementDescriptor<K, V>> list;

    @Override
    public void initialize(CompositeCache<K, V> hub) {
        super.initialize(hub);
        this.list = new DoubleLinkedList();
        log.info("initialized MemoryCache for " + this.getCacheName());
    }

    @Override
    public ConcurrentMap<K, MemoryElementDescriptor<K, V>> createMap() {
        return new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void update(ICacheElement<K, V> ce) throws IOException {
        this.putCnt.incrementAndGet();
        this.lock.lock();
        try {
            MemoryElementDescriptor<K, V> newNode = this.adjustListForUpdate(ce);
            K key = newNode.getCacheElement().getKey();
            MemoryElementDescriptor<K, V> oldNode = this.map.put(key, newNode);
            if (oldNode != null && key.equals(oldNode.getCacheElement().getKey())) {
                this.list.remove(oldNode);
            }
        }
        finally {
            this.lock.unlock();
        }
        this.spoolIfNeeded();
    }

    protected abstract MemoryElementDescriptor<K, V> adjustListForUpdate(ICacheElement<K, V> var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spoolIfNeeded() throws Error {
        int size = this.map.size();
        if (size <= this.getCacheAttributes().getMaxObjects()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("In memory limit reached, spooling");
        }
        int chunkSizeCorrected = Math.min(size, this.chunkSize);
        if (log.isDebugEnabled()) {
            log.debug("About to spool to disk cache, map size: " + size + ", max objects: " + this.getCacheAttributes().getMaxObjects() + ", maximum items to spool: " + chunkSizeCorrected);
        }
        this.lock.lock();
        try {
            ICacheElement<K, V> lastElement;
            for (int i = 0; i < chunkSizeCorrected && (lastElement = this.spoolLastElement()) != null; ++i) {
            }
            if (log.isDebugEnabled() && this.map.size() != this.list.size()) {
                log.debug("update: After spool, size mismatch: map.size() = " + this.map.size() + ", linked list size = " + this.list.size());
            }
        }
        finally {
            this.lock.unlock();
        }
        if (log.isDebugEnabled()) {
            log.debug("update: After spool map size: " + this.map.size() + " linked list size = " + this.list.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int freeElements(int numberToFree) throws IOException {
        int freed;
        this.lock.lock();
        try {
            for (freed = 0; freed < numberToFree; ++freed) {
                ICacheElement<K, V> element = this.spoolLastElement();
                if (element != null) continue;
                break;
            }
        }
        finally {
            this.lock.unlock();
        }
        return freed;
    }

    private ICacheElement<K, V> spoolLastElement() throws Error {
        ICacheElement<K, V> toSpool = null;
        MemoryElementDescriptor<K, V> last = this.list.getLast();
        if (last != null) {
            toSpool = last.getCacheElement();
            if (toSpool != null) {
                this.getCompositeCache().spoolToDisk(toSpool);
                if (this.map.remove(toSpool.getKey()) == null) {
                    log.warn("update: remove failed for key: " + toSpool.getKey());
                    if (log.isDebugEnabled()) {
                        this.verifyCache();
                    }
                }
            } else {
                throw new Error("update: last.ce is null!");
            }
            this.list.remove(last);
        }
        return toSpool;
    }

    @Override
    public ICacheElement<K, V> get(K key) throws IOException {
        ICacheElement ce = super.get(key);
        if (log.isDebugEnabled()) {
            this.verifyCache();
        }
        return ce;
    }

    protected abstract void adjustListForGet(MemoryElementDescriptor<K, V> var1);

    @Override
    protected void lockedGetElement(MemoryElementDescriptor<K, V> me) {
        this.adjustListForGet(me);
    }

    @Override
    protected void lockedRemoveElement(MemoryElementDescriptor<K, V> me) {
        this.list.remove(me);
    }

    @Override
    protected void lockedRemoveAll() {
        this.list.removeAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MemoryElementDescriptor<K, V> addFirst(ICacheElement<K, V> ce) {
        this.lock.lock();
        try {
            MemoryElementDescriptor<K, V> me = new MemoryElementDescriptor<K, V>(ce);
            this.list.addFirst(me);
            if (log.isDebugEnabled()) {
                this.verifyCache(ce.getKey());
            }
            MemoryElementDescriptor<K, V> memoryElementDescriptor = me;
            return memoryElementDescriptor;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MemoryElementDescriptor<K, V> addLast(ICacheElement<K, V> ce) {
        this.lock.lock();
        try {
            MemoryElementDescriptor<K, V> me = new MemoryElementDescriptor<K, V>(ce);
            this.list.addLast(me);
            if (log.isDebugEnabled()) {
                this.verifyCache(ce.getKey());
            }
            MemoryElementDescriptor<K, V> memoryElementDescriptor = me;
            return memoryElementDescriptor;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void dumpCacheEntries() {
        log.debug("dumpingCacheEntries");
        MemoryElementDescriptor me = this.list.getFirst();
        while (me != null) {
            log.debug("dumpCacheEntries> key=" + me.getCacheElement().getKey() + ", val=" + me.getCacheElement().getVal());
            me = (MemoryElementDescriptor)me.next;
        }
    }

    private void verifyCache() {
        boolean found = false;
        log.debug("verifycache[" + this.getCacheName() + "]: mapContains " + this.map.size() + " elements, linked list contains " + this.list.size() + " elements");
        log.debug("verifycache: checking linked list by key ");
        MemoryElementDescriptor li = this.list.getFirst();
        while (li != null) {
            K key = li.getCacheElement().getKey();
            if (!this.map.containsKey(key)) {
                log.error("verifycache[" + this.getCacheName() + "]: map does not contain key : " + key);
                log.error("key class=" + key.getClass());
                log.error("key hashcode=" + key.hashCode());
                log.error("key toString=" + key.toString());
                if (key instanceof GroupAttrName) {
                    GroupAttrName name = (GroupAttrName)key;
                    log.error("GroupID hashcode=" + name.groupId.hashCode());
                    log.error("GroupID.class=" + name.groupId.getClass());
                    log.error("AttrName hashcode=" + name.attrName.hashCode());
                    log.error("AttrName.class=" + name.attrName.getClass());
                }
                this.dumpMap();
            } else if (this.map.get(key) == null) {
                log.error("verifycache[" + this.getCacheName() + "]: linked list retrieval returned null for key: " + key);
            }
            li = (MemoryElementDescriptor)li.next;
        }
        log.debug("verifycache: checking linked list by value ");
        MemoryElementDescriptor li3 = this.list.getFirst();
        while (li3 != null) {
            if (!this.map.containsValue(li3)) {
                log.error("verifycache[" + this.getCacheName() + "]: map does not contain value : " + li3);
                this.dumpMap();
            }
            li3 = (MemoryElementDescriptor)li3.next;
        }
        log.debug("verifycache: checking via keysets!");
        for (Object val : this.map.keySet()) {
            found = false;
            MemoryElementDescriptor li2 = this.list.getFirst();
            while (li2 != null) {
                if (val.equals(li2.getCacheElement().getKey())) {
                    found = true;
                    break;
                }
                li2 = (MemoryElementDescriptor)li2.next;
            }
            if (found) continue;
            log.error("verifycache[" + this.getCacheName() + "]: key not found in list : " + val);
            this.dumpCacheEntries();
            if (this.map.containsKey(val)) {
                log.error("verifycache: map contains key");
                continue;
            }
            log.error("verifycache: map does NOT contain key, what the HECK!");
        }
    }

    private void verifyCache(K key) {
        boolean found = false;
        MemoryElementDescriptor li = this.list.getFirst();
        while (li != null) {
            if (li.getCacheElement().getKey() == key) {
                found = true;
                log.debug("verifycache(key) key match: " + key);
                break;
            }
            li = (MemoryElementDescriptor)li.next;
        }
        if (!found) {
            log.error("verifycache(key)[" + this.getCacheName() + "], couldn't find key! : " + key);
        }
    }

    @Override
    public IStats getStatistics() {
        IStats stats = super.getStatistics();
        stats.setTypeName("Memory Cache");
        List<IStatElement<?>> elems = stats.getStatElements();
        elems.add(new StatElement<Integer>("List Size", this.list.size()));
        return stats;
    }
}

