/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg.xml;

import com.kitfox.svg.xml.NumberWithUnits;
import com.kitfox.svg.xml.StyleAttribute;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XMLParseUtil {
    static final Matcher fpMatch = Pattern.compile("([-+]?((\\d*\\.\\d+)|(\\d+))([eE][+-]?\\d+)?)(\\%|in|cm|mm|pt|pc|px|em|ex)?").matcher("");
    static final Matcher intMatch = Pattern.compile("[-+]?\\d+").matcher("");
    static final Matcher quoteMatch = Pattern.compile("^'|'$").matcher("");

    private XMLParseUtil() {
    }

    public static String[] parseStringList(String list) {
        Matcher matchWs = Pattern.compile("[^\\s]+").matcher("");
        matchWs.reset(list);
        LinkedList<String> matchList = new LinkedList<String>();
        while (matchWs.find()) {
            matchList.add(matchWs.group());
        }
        String[] retArr = new String[matchList.size()];
        return matchList.toArray(retArr);
    }

    public static double parseDouble(String val) {
        return XMLParseUtil.findDouble(val);
    }

    public static synchronized double findDouble(String val) {
        if (val == null) {
            return 0.0;
        }
        fpMatch.reset(val);
        try {
            if (!fpMatch.find()) {
                return 0.0;
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            Logger.getLogger("svgSalamandeLogger").log(Level.WARNING, "XMLParseUtil: regex parse problem: '" + val + "'", e);
        }
        val = fpMatch.group(1);
        double retVal = 0.0;
        try {
            float pixPerInch;
            retVal = Double.parseDouble(val);
            try {
                pixPerInch = Toolkit.getDefaultToolkit().getScreenResolution();
            }
            catch (NoClassDefFoundError err) {
                pixPerInch = 72.0f;
            }
            float inchesPerCm = 0.3936f;
            String units = fpMatch.group(6);
            if ("%".equals(units)) {
                retVal /= 100.0;
            } else if ("in".equals(units)) {
                retVal *= (double)pixPerInch;
            } else if ("cm".equals(units)) {
                retVal *= (double)(0.3936f * pixPerInch);
            } else if ("mm".equals(units)) {
                retVal *= (double)(0.3936f * pixPerInch * 0.1f);
            } else if ("pt".equals(units)) {
                retVal *= (double)(0.013888889f * pixPerInch);
            } else if ("pc".equals(units)) {
                retVal *= (double)(0.16666667f * pixPerInch);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    public static synchronized double[] parseDoubleList(String list) {
        if (list == null) {
            return null;
        }
        fpMatch.reset(list);
        LinkedList<Double> doubList = new LinkedList<Double>();
        while (fpMatch.find()) {
            String val = fpMatch.group(1);
            doubList.add(Double.valueOf(val));
        }
        double[] retArr = new double[doubList.size()];
        Iterator it = doubList.iterator();
        int idx = 0;
        while (it.hasNext()) {
            retArr[idx++] = (Double)it.next();
        }
        return retArr;
    }

    public static synchronized float findFloat(String val) {
        if (val == null) {
            return 0.0f;
        }
        fpMatch.reset(val);
        if (!fpMatch.find()) {
            return 0.0f;
        }
        val = fpMatch.group(1);
        float retVal = 0.0f;
        try {
            retVal = Float.parseFloat(val);
            String units = fpMatch.group(6);
            if ("%".equals(units)) {
                retVal /= 100.0f;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    public static synchronized float[] parseFloatList(String list) {
        if (list == null) {
            return null;
        }
        fpMatch.reset(list);
        LinkedList<Float> floatList = new LinkedList<Float>();
        while (fpMatch.find()) {
            String val = fpMatch.group(1);
            floatList.add(Float.valueOf(val));
        }
        float[] retArr = new float[floatList.size()];
        Iterator it = floatList.iterator();
        int idx = 0;
        while (it.hasNext()) {
            retArr[idx++] = ((Float)it.next()).floatValue();
        }
        return retArr;
    }

    public static int findInt(String val) {
        if (val == null) {
            return 0;
        }
        intMatch.reset(val);
        if (!intMatch.find()) {
            return 0;
        }
        val = intMatch.group();
        int retVal = 0;
        try {
            retVal = Integer.parseInt(val);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    public static int[] parseIntList(String list) {
        if (list == null) {
            return null;
        }
        intMatch.reset(list);
        LinkedList<Integer> intList = new LinkedList<Integer>();
        while (intMatch.find()) {
            String val = intMatch.group();
            intList.add(Integer.valueOf(val));
        }
        int[] retArr = new int[intList.size()];
        Iterator it = intList.iterator();
        int idx = 0;
        while (it.hasNext()) {
            retArr[idx++] = (Integer)it.next();
        }
        return retArr;
    }

    public static double parseRatio(String val) {
        if (val == null || val.equals("")) {
            return 0.0;
        }
        if (val.charAt(val.length() - 1) == '%') {
            XMLParseUtil.parseDouble(val.substring(0, val.length() - 1));
        }
        return XMLParseUtil.parseDouble(val);
    }

    public static NumberWithUnits parseNumberWithUnits(String val) {
        if (val == null) {
            return null;
        }
        return new NumberWithUnits(val);
    }

    public static HashMap<String, StyleAttribute> parseStyle(String styleString, HashMap<String, StyleAttribute> map) {
        Pattern patSemi = Pattern.compile(";");
        String[] styles = patSemi.split(styleString);
        for (int i = 0; i < styles.length; ++i) {
            int colon;
            if (styles[i].length() == 0 || (colon = styles[i].indexOf(58)) == -1) continue;
            String key = styles[i].substring(0, colon).trim().intern();
            String value = quoteMatch.reset(styles[i].substring(colon + 1).trim()).replaceAll("").intern();
            map.put(key, new StyleAttribute(key, value));
        }
        return map;
    }
}

