/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.container;

import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.model.container.JavaModuleContainer;
import org.jd.gui.spi.ContainerFactory;
import org.jd.gui.util.exception.ExceptionUtil;

public class JavaModuleContainerFactoryProvider
implements ContainerFactory {
    @Override
    public String getType() {
        return "jmod";
    }

    @Override
    public boolean accept(API api, Path rootPath) {
        if (rootPath.toUri().toString().toLowerCase().endsWith(".jmod!/")) {
            return true;
        }
        try {
            return rootPath.getFileSystem().provider().getScheme().equals("file") && Files.exists(rootPath.resolve("classes"), new LinkOption[0]);
        }
        catch (InvalidPathException e) {
            assert (ExceptionUtil.printStackTrace(e));
            return false;
        }
    }

    @Override
    public Container make(API api, Container.Entry parentEntry, Path rootPath) {
        return new JavaModuleContainer(api, parentEntry, rootPath);
    }
}

