/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.fragmenter.javasyntaxtojavafragment.visitor;

import java.util.HashSet;
import org.jd.core.v1.model.javafragment.ImportsFragment;
import org.jd.core.v1.model.javasyntax.AbstractJavaSyntaxVisitor;
import org.jd.core.v1.model.javasyntax.declaration.AnnotationDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.BodyDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.ClassDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.ConstructorDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.EnumDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.FieldDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.InterfaceDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.MethodDeclaration;
import org.jd.core.v1.model.javasyntax.expression.ArrayExpression;
import org.jd.core.v1.model.javasyntax.expression.BinaryOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.BooleanExpression;
import org.jd.core.v1.model.javasyntax.expression.CastExpression;
import org.jd.core.v1.model.javasyntax.expression.ConstructorInvocationExpression;
import org.jd.core.v1.model.javasyntax.expression.ConstructorReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.DoubleConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.FieldReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.FloatConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.InstanceOfExpression;
import org.jd.core.v1.model.javasyntax.expression.IntegerConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.LambdaFormalParametersExpression;
import org.jd.core.v1.model.javasyntax.expression.LambdaIdentifiersExpression;
import org.jd.core.v1.model.javasyntax.expression.LengthExpression;
import org.jd.core.v1.model.javasyntax.expression.LocalVariableReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.LongConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.MethodInvocationExpression;
import org.jd.core.v1.model.javasyntax.expression.MethodReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.NewArray;
import org.jd.core.v1.model.javasyntax.expression.NewExpression;
import org.jd.core.v1.model.javasyntax.expression.NewInitializedArray;
import org.jd.core.v1.model.javasyntax.expression.NullExpression;
import org.jd.core.v1.model.javasyntax.expression.ObjectTypeReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.ParenthesesExpression;
import org.jd.core.v1.model.javasyntax.expression.PostOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.PreOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.StringConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.SuperExpression;
import org.jd.core.v1.model.javasyntax.expression.TernaryOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.ThisExpression;
import org.jd.core.v1.model.javasyntax.expression.TypeReferenceDotClassExpression;
import org.jd.core.v1.model.javasyntax.reference.AnnotationElementValue;
import org.jd.core.v1.model.javasyntax.reference.AnnotationReference;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.service.fragmenter.javasyntaxtojavafragment.util.JavaFragmentFactory;

public class SearchImportsVisitor
extends AbstractJavaSyntaxVisitor {
    protected String internalPackagePrefix;
    protected ImportsFragment importsFragment = JavaFragmentFactory.newImportsFragment();
    protected int maxLineNumber = 0;
    protected HashSet<String> mainTypeNames = new HashSet();
    protected HashSet<String> internalTypeNames = new HashSet();

    public SearchImportsVisitor(String mainInternalName) {
        int index = mainInternalName.lastIndexOf(47);
        this.internalPackagePrefix = index == -1 ? "" : mainInternalName.substring(0, index + 1);
    }

    @Override
    public void visit(AnnotationReference reference) {
        super.visit(reference);
        this.add(reference.getType());
    }

    @Override
    public void visit(AnnotationElementValue reference) {
        super.visit(reference);
        this.add(reference.getType());
    }

    @Override
    public void visit(BodyDeclaration declaration) {
        if (this.mainTypeNames.isEmpty()) {
            this.mainTypeNames.add(SearchImportsVisitor.getTypeName(declaration.getInternalTypeName()));
            declaration.accept(new MainTypeVisitor(this.mainTypeNames));
        }
        if (!this.internalTypeNames.contains(declaration.getInternalTypeName())) {
            this.safeAccept(declaration.getMemberDeclarations());
        }
    }

    protected static String getTypeName(String internalTypeName) {
        int index = internalTypeName.lastIndexOf(36);
        if (index != -1) {
            return internalTypeName.substring(index + 1);
        }
        index = internalTypeName.lastIndexOf(47);
        if (index != -1) {
            return internalTypeName.substring(index + 1);
        }
        return internalTypeName;
    }

    public ImportsFragment getImportsFragment() {
        this.importsFragment.initLineCounts();
        return this.importsFragment;
    }

    public int getMaxLineNumber() {
        return this.maxLineNumber;
    }

    @Override
    public void visit(ObjectType type) {
        this.add(type);
        this.safeAccept(type.getTypeArguments());
    }

    @Override
    public void visit(ArrayExpression expression) {
        if (this.maxLineNumber < expression.getLineNumber()) {
            this.maxLineNumber = expression.getLineNumber();
        }
        expression.getExpression().accept(this);
        expression.getIndex().accept(this);
    }

    @Override
    public void visit(BinaryOperatorExpression expression) {
        if (this.maxLineNumber < expression.getLineNumber()) {
            this.maxLineNumber = expression.getLineNumber();
        }
        super.visit(expression);
    }

    @Override
    public void visit(BooleanExpression expression) {
        if (this.maxLineNumber < expression.getLineNumber()) {
            this.maxLineNumber = expression.getLineNumber();
        }
        super.visit(expression);
    }

    @Override
    public void visit(CastExpression expression) {
        if (this.maxLineNumber < expression.getLineNumber()) {
            this.maxLineNumber = expression.getLineNumber();
        }
        super.visit(expression);
    }

    @Override
    public void visit(ConstructorInvocationExpression expression) {
        if (this.maxLineNumber < expression.getLineNumber()) {
            this.maxLineNumber = expression.getLineNumber();
        }
        super.visit(expression);
    }

    @Override
    public void visit(ConstructorReferenceExpression expression) {
        if (this.maxLineNumber < expression.getLineNumber()) {
            this.maxLineNumber = expression.getLineNumber();
        }
        super.visit(expression);
    }

    @Override
    public void visit(DoubleConstantExpression expression) {
        if (this.maxLineNumber < expression.getLineNumber()) {
            this.maxLineNumber = expression.getLineNumber();
        }
    }

    @Override
    public void visit(EnumDeclaration declaration) {
        this.safeAccept(declaration.getInterfaces());
        this.safeAccept(declaration.getAnnotationReferences());
        this.safeAccept(declaration.getBodyDeclaration());
    }

    @Override
    public void visit(FieldReferenceExpression expression) {
        if (this.maxLineNumber < expression.getLineNumber()) {
            this.maxLineNumber = expression.getLineNumber();
        }
        this.safeAccept(expression.getExpression());
    }

    @Override
    public void visit(FloatConstantExpression expression) {
        if (this.maxLineNumber < expression.getLineNumber()) {
            this.maxLineNumber = expression.getLineNumber();
        }
    }

    @Override
    public void visit(IntegerConstantExpression expression) {
        if (this.maxLineNumber < expression.getLineNumber()) {
            this.maxLineNumber = expression.getLineNumber();
        }
    }

    @Override
    public void visit(InstanceOfExpression expression) {
        if (this.maxLineNumber < expression.getLineNumber()) {
            this.maxLineNumber = expression.getLineNumber();
        }
        super.visit(expression);
    }

    @Override
    public void visit(LambdaFormalParametersExpression expression) {
        if (this.maxLineNumber < expression.getLineNumber()) {
            this.maxLineNumber = expression.getLineNumber();
        }
        super.visit(expression);
    }

    @Override
    public void visit(LambdaIdentifiersExpression expression) {
        if (this.maxLineNumber < expression.getLineNumber()) {
            this.maxLineNumber = expression.getLineNumber();
        }
        super.visit(expression);
    }

    @Override
    public void visit(LengthExpression expression) {
        if (this.maxLineNumber < expression.getLineNumber()) {
            this.maxLineNumber = expression.getLineNumber();
        }
        super.visit(expression);
    }

    @Override
    public void visit(LocalVariableReferenceExpression expression) {
        if (this.maxLineNumber < expression.getLineNumber()) {
            this.maxLineNumber = expression.getLineNumber();
        }
        super.visit(expression);
    }

    @Override
    public void visit(LongConstantExpression expression) {
        if (this.maxLineNumber < expression.getLineNumber()) {
            this.maxLineNumber = expression.getLineNumber();
        }
    }

    @Override
    public void visit(MethodInvocationExpression expression) {
        if (this.maxLineNumber < expression.getLineNumber()) {
            this.maxLineNumber = expression.getLineNumber();
        }
        super.visit(expression);
    }

    @Override
    public void visit(MethodReferenceExpression expression) {
        if (this.maxLineNumber < expression.getLineNumber()) {
            this.maxLineNumber = expression.getLineNumber();
        }
        expression.getExpression().accept(this);
    }

    @Override
    public void visit(NewArray expression) {
        if (this.maxLineNumber < expression.getLineNumber()) {
            this.maxLineNumber = expression.getLineNumber();
        }
        this.safeAccept(expression.getDimensionExpressionList());
    }

    @Override
    public void visit(NewExpression expression) {
        if (this.maxLineNumber < expression.getLineNumber()) {
            this.maxLineNumber = expression.getLineNumber();
        }
        Type type = expression.getType();
        type.accept(this);
        this.safeAccept(expression.getParameters());
        this.safeAccept(expression.getBodyDeclaration());
    }

    @Override
    public void visit(NewInitializedArray expression) {
        if (this.maxLineNumber < expression.getLineNumber()) {
            this.maxLineNumber = expression.getLineNumber();
        }
        super.visit(expression);
    }

    @Override
    public void visit(NullExpression expression) {
        if (this.maxLineNumber < expression.getLineNumber()) {
            this.maxLineNumber = expression.getLineNumber();
        }
    }

    @Override
    public void visit(ObjectTypeReferenceExpression expression) {
        if (this.maxLineNumber < expression.getLineNumber()) {
            this.maxLineNumber = expression.getLineNumber();
        }
        super.visit(expression);
    }

    @Override
    public void visit(ParenthesesExpression expression) {
        if (this.maxLineNumber < expression.getLineNumber()) {
            this.maxLineNumber = expression.getLineNumber();
        }
        super.visit(expression);
    }

    @Override
    public void visit(PostOperatorExpression expression) {
        if (this.maxLineNumber < expression.getLineNumber()) {
            this.maxLineNumber = expression.getLineNumber();
        }
        super.visit(expression);
    }

    @Override
    public void visit(PreOperatorExpression expression) {
        if (this.maxLineNumber < expression.getLineNumber()) {
            this.maxLineNumber = expression.getLineNumber();
        }
        super.visit(expression);
    }

    @Override
    public void visit(StringConstantExpression expression) {
        if (this.maxLineNumber < expression.getLineNumber()) {
            this.maxLineNumber = expression.getLineNumber();
        }
        super.visit(expression);
    }

    @Override
    public void visit(SuperExpression expression) {
        if (this.maxLineNumber < expression.getLineNumber()) {
            this.maxLineNumber = expression.getLineNumber();
        }
        super.visit(expression);
    }

    @Override
    public void visit(TernaryOperatorExpression expression) {
        if (this.maxLineNumber < expression.getLineNumber()) {
            this.maxLineNumber = expression.getLineNumber();
        }
        super.visit(expression);
    }

    @Override
    public void visit(ThisExpression expression) {
        if (this.maxLineNumber < expression.getLineNumber()) {
            this.maxLineNumber = expression.getLineNumber();
        }
        super.visit(expression);
    }

    @Override
    public void visit(TypeReferenceDotClassExpression expression) {
        if (this.maxLineNumber < expression.getLineNumber()) {
            this.maxLineNumber = expression.getLineNumber();
        }
        super.visit(expression);
    }

    protected void add(ObjectType type) {
        String descriptor = type.getDescriptor();
        if (descriptor.charAt(descriptor.length() - 1) == ';') {
            String internalName = type.getInternalName();
            String qualifiedName = type.getQualifiedName();
            if (internalName.startsWith("java/lang/")) {
                if (internalName.indexOf(47, 10) != -1) {
                    this.importsFragment.addImport(internalName, qualifiedName);
                }
            } else if (internalName.startsWith(this.internalPackagePrefix)) {
                if (internalName.indexOf(47, this.internalPackagePrefix.length()) != -1) {
                    this.importsFragment.addImport(internalName, qualifiedName);
                }
            } else if (!this.mainTypeNames.contains(SearchImportsVisitor.getTypeName(internalName))) {
                this.importsFragment.addImport(internalName, qualifiedName);
            }
        }
    }

    protected static class MainTypeVisitor
    extends AbstractJavaSyntaxVisitor {
        HashSet<String> mainTypeNames;

        public MainTypeVisitor(HashSet<String> mainTypeNames) {
            this.mainTypeNames = mainTypeNames;
        }

        @Override
        public void visit(AnnotationDeclaration declaration) {
            this.mainTypeNames.add(SearchImportsVisitor.getTypeName(declaration.getInternalTypeName()));
            this.safeAccept(declaration.getBodyDeclaration());
        }

        @Override
        public void visit(ClassDeclaration declaration) {
            this.mainTypeNames.add(SearchImportsVisitor.getTypeName(declaration.getInternalTypeName()));
            this.safeAccept(declaration.getBodyDeclaration());
        }

        @Override
        public void visit(EnumDeclaration declaration) {
            this.mainTypeNames.add(SearchImportsVisitor.getTypeName(declaration.getInternalTypeName()));
            this.safeAccept(declaration.getBodyDeclaration());
        }

        @Override
        public void visit(InterfaceDeclaration declaration) {
            this.mainTypeNames.add(SearchImportsVisitor.getTypeName(declaration.getInternalTypeName()));
            this.safeAccept(declaration.getBodyDeclaration());
        }

        @Override
        public void visit(FieldDeclaration declaration) {
        }

        @Override
        public void visit(ConstructorDeclaration declaration) {
        }

        @Override
        public void visit(MethodDeclaration declaration) {
        }
    }
}

