/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.typeinference;

import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.visitors.typeinference.ITypeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class TypeUpdateRegistry {
    private final Map<InsnType, List<ITypeListener>> listenersMap = new EnumMap<InsnType, List<ITypeListener>>(InsnType.class);

    public void add(InsnType insnType, ITypeListener listener) {
        this.listenersMap.computeIfAbsent(insnType, k -> new ArrayList(3)).add(listener);
    }

    @NotNull
    public List<ITypeListener> getListenersForInsn(InsnType insnType) {
        List<ITypeListener> list = this.listenersMap.get((Object)insnType);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }
}

