import*as Common from'../common/common.js';import*as Host from'../host/host.js';import{ActionDelegate as ActionDelegateInterface}from'./ActionDelegate.js';import{Context}from'./Context.js';import{Dialog}from'./Dialog.js';import{GlassPane}from'./GlassPane.js';import{Icon}from'./Icon.js';import{KeyboardShortcut}from'./KeyboardShortcut.js';import{Panel}from'./Panel.js';import{SplitWidget}from'./SplitWidget.js';import{Events as TabbedPaneEvents}from'./TabbedPane.js';import{ToolbarButton}from'./Toolbar.js';import{View,ViewLocation,ViewLocationResolver}from'./View.js';import{VBox,WidgetFocusRestorer}from'./Widget.js';export class InspectorView extends VBox{constructor(){super();GlassPane.setContainer(this.element);this.setMinimumSize(240,72);this._drawerSplitWidget=new SplitWidget(false,true,'Inspector.drawerSplitViewState',200,200);this._drawerSplitWidget.hideSidebar();this._drawerSplitWidget.hideDefaultResizer();this._drawerSplitWidget.enableShowModeSaving();this._drawerSplitWidget.show(this.element);this._drawerTabbedLocation=self.UI.viewManager.createTabbedLocation(this._showDrawer.bind(this,false),'drawer-view',true,true);const moreTabsButton=this._drawerTabbedLocation.enableMoreTabsButton();moreTabsButton.setTitle(ls`More Tools`);this._drawerTabbedPane=this._drawerTabbedLocation.tabbedPane();this._drawerTabbedPane.setMinimumSize(0,27);const closeDrawerButton=new ToolbarButton(Common.UIString.UIString('Close drawer'),'largeicon-delete');closeDrawerButton.addEventListener(ToolbarButton.Events.Click,this._closeDrawer,this);this._drawerSplitWidget.installResizer(this._drawerTabbedPane.headerElement());this._drawerTabbedPane.addEventListener(TabbedPaneEvents.TabSelected,this._drawerTabSelected,this);this._drawerSplitWidget.setSidebarWidget(this._drawerTabbedPane);this._drawerTabbedPane.rightToolbar().appendToolbarItem(closeDrawerButton);this._tabbedLocation=self.UI.viewManager.createTabbedLocation(Host.InspectorFrontendHost.InspectorFrontendHostInstance.bringToFront.bind(Host.InspectorFrontendHost.InspectorFrontendHostInstance),'panel',true,true,Root.Runtime.queryParam('panel'));this._tabbedPane=this._tabbedLocation.tabbedPane();this._tabbedPane.registerRequiredCSS('ui/inspectorViewTabbedPane.css');this._tabbedPane.addEventListener(TabbedPaneEvents.TabSelected,this._tabSelected,this);this._tabbedPane.setAccessibleName(Common.UIString.UIString('Panels'));Host.userMetrics.setLaunchPanel(this._tabbedPane.selectedTabId);if(Host.InspectorFrontendHost.isUnderTest()){this._tabbedPane.setAutoSelectFirstItemOnShow(false);}
this._drawerSplitWidget.setMainWidget(this._tabbedPane);this._keyDownBound=this._keyDown.bind(this);Host.InspectorFrontendHost.InspectorFrontendHostInstance.events.addEventListener(Host.InspectorFrontendHostAPI.Events.ShowPanel,showPanel.bind(this));function showPanel(event){const panelName=(event.data);this.showPanel(panelName);}}
static instance(){return(self.runtime.sharedInstance(InspectorView));}
wasShown(){this.element.ownerDocument.addEventListener('keydown',this._keyDownBound,false);}
willHide(){this.element.ownerDocument.removeEventListener('keydown',this._keyDownBound,false);}
resolveLocation(locationName){if(locationName==='drawer-view'){return this._drawerTabbedLocation;}
if(locationName==='panel'){return this._tabbedLocation;}
return null;}
createToolbars(){this._tabbedPane.leftToolbar().appendItemsAtLocation('main-toolbar-left');this._tabbedPane.rightToolbar().appendItemsAtLocation('main-toolbar-right');}
addPanel(view){this._tabbedLocation.appendView(view);}
hasPanel(panelName){return this._tabbedPane.hasTab(panelName);}
panel(panelName){return((self.UI.viewManager.view(panelName).widget()));}
onSuspendStateChanged(allTargetsSuspended){this._currentPanelLocked=allTargetsSuspended;this._tabbedPane.setCurrentTabLocked(this._currentPanelLocked);this._tabbedPane.leftToolbar().setEnabled(!this._currentPanelLocked);this._tabbedPane.rightToolbar().setEnabled(!this._currentPanelLocked);}
canSelectPanel(panelName){return!this._currentPanelLocked||this._tabbedPane.selectedTabId===panelName;}
showPanel(panelName){return self.UI.viewManager.showView(panelName);}
setPanelIcon(panelName,icon){this._tabbedPane.setTabIcon(panelName,icon);}
currentPanelDeprecated(){return((self.UI.viewManager.materializedWidget(this._tabbedPane.selectedTabId||'')));}
_showDrawer(focus){if(this._drawerTabbedPane.isShowing()){return;}
this._drawerSplitWidget.showBoth();if(focus){this._focusRestorer=new WidgetFocusRestorer(this._drawerTabbedPane);}else{this._focusRestorer=null;}}
drawerVisible(){return this._drawerTabbedPane.isShowing();}
_closeDrawer(){if(!this._drawerTabbedPane.isShowing()){return;}
if(this._focusRestorer){this._focusRestorer.restore();}
this._drawerSplitWidget.hideSidebar(true);}
setDrawerMinimized(minimized){this._drawerSplitWidget.setSidebarMinimized(minimized);this._drawerSplitWidget.setResizable(!minimized);}
isDrawerMinimized(){return this._drawerSplitWidget.isSidebarMinimized();}
closeDrawerTab(id,userGesture){this._drawerTabbedPane.closeTab(id,userGesture);}
_keyDown(event){const keyboardEvent=(event);if(!KeyboardShortcut.eventHasCtrlOrMeta(keyboardEvent)||event.altKey||event.shiftKey){return;}
const panelShortcutEnabled=Common.Settings.moduleSetting('shortcutPanelSwitch').get();if(panelShortcutEnabled){let panelIndex=-1;if(event.keyCode>0x30&&event.keyCode<0x3A){panelIndex=event.keyCode-0x31;}else if(event.keyCode>0x60&&event.keyCode<0x6A&&keyboardEvent.location===KeyboardEvent.DOM_KEY_LOCATION_NUMPAD){panelIndex=event.keyCode-0x61;}
if(panelIndex!==-1){const panelName=this._tabbedPane.tabIds()[panelIndex];if(panelName){if(!Dialog.hasInstance()&&!this._currentPanelLocked){this.showPanel(panelName);}
event.consume(true);}}}}
onResize(){GlassPane.containerMoved(this.element);}
topResizerElement(){return this._tabbedPane.headerElement();}
toolbarItemResized(){this._tabbedPane.headerResized();}
_tabSelected(event){const tabId=(event.data['tabId']);Host.userMetrics.panelShown(tabId);}
_drawerTabSelected(event){const tabId=(event.data['tabId']);Host.userMetrics.drawerShown(tabId);}
setOwnerSplit(splitWidget){this._ownerSplitWidget=splitWidget;}
ownerSplit(){return this._ownerSplitWidget;}
minimize(){if(this._ownerSplitWidget){this._ownerSplitWidget.setSidebarMinimized(true);}}
restore(){if(this._ownerSplitWidget){this._ownerSplitWidget.setSidebarMinimized(false);}}}
export class ActionDelegate{handleAction(context,actionId){switch(actionId){case'main.toggle-drawer':if(self.UI.inspectorView.drawerVisible()){self.UI.inspectorView._closeDrawer();}else{self.UI.inspectorView._showDrawer(true);}
return true;case'main.next-tab':self.UI.inspectorView._tabbedPane.selectNextTab();self.UI.inspectorView._tabbedPane.focus();return true;case'main.previous-tab':self.UI.inspectorView._tabbedPane.selectPrevTab();self.UI.inspectorView._tabbedPane.focus();return true;}
return false;}}