/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.DefaultErrorReporter;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

class NativeScript
extends BaseFunction {
    static final long serialVersionUID = -6795101161980121700L;
    private static final Object SCRIPT_TAG = "Script";
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_compile = 3;
    private static final int Id_exec = 4;
    private static final int MAX_PROTOTYPE_ID = 4;
    private Script script;

    static void init(Scriptable scriptable, boolean bl) {
        NativeScript nativeScript = new NativeScript(null);
        nativeScript.exportAsJSClass(4, scriptable, bl);
    }

    private NativeScript(Script script) {
        this.script = script;
    }

    public String getClassName() {
        return "Script";
    }

    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (this.script != null) {
            return this.script.exec(context, scriptable);
        }
        return Undefined.instance;
    }

    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) {
        throw Context.reportRuntimeError0("msg.script.is.not.constructor");
    }

    public int getLength() {
        return 0;
    }

    public int getArity() {
        return 0;
    }

    String decompile(int n, int n2) {
        if (this.script instanceof NativeFunction) {
            return ((NativeFunction)((Object)this.script)).decompile(n, n2);
        }
        return super.decompile(n, n2);
    }

    protected void initPrototypeId(int n) {
        String string;
        int n2;
        switch (n) {
            case 1: {
                n2 = 1;
                string = "constructor";
                break;
            }
            case 2: {
                n2 = 0;
                string = "toString";
                break;
            }
            case 4: {
                n2 = 0;
                string = "exec";
                break;
            }
            case 3: {
                n2 = 1;
                string = "compile";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.initPrototypeMethod(SCRIPT_TAG, n, string, n2);
    }

    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(SCRIPT_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        switch (n) {
            case 1: {
                String string = objectArray.length == 0 ? "" : ScriptRuntime.toString(objectArray[0]);
                Script script = NativeScript.compile(context, string);
                NativeScript nativeScript = new NativeScript(script);
                ScriptRuntime.setObjectProtoAndParent(nativeScript, scriptable);
                return nativeScript;
            }
            case 2: {
                NativeScript nativeScript = NativeScript.realThis(scriptable2, idFunctionObject);
                Script script = nativeScript.script;
                if (script == null) {
                    return "";
                }
                return context.decompileScript(script, 0);
            }
            case 4: {
                throw Context.reportRuntimeError1("msg.cant.call.indirect", "exec");
            }
            case 3: {
                NativeScript nativeScript = NativeScript.realThis(scriptable2, idFunctionObject);
                String string = ScriptRuntime.toString(objectArray, 0);
                nativeScript.script = NativeScript.compile(context, string);
                return nativeScript;
            }
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    private static NativeScript realThis(Scriptable scriptable, IdFunctionObject idFunctionObject) {
        if (!(scriptable instanceof NativeScript)) {
            throw NativeScript.incompatibleCallError(idFunctionObject);
        }
        return (NativeScript)scriptable;
    }

    private static Script compile(Context context, String string) {
        int[] nArray = new int[1];
        String string2 = Context.getSourcePositionFromStack(nArray);
        if (string2 == null) {
            string2 = "<Script object>";
            nArray[0] = 1;
        }
        ErrorReporter errorReporter = DefaultErrorReporter.forEval(context.getErrorReporter());
        return context.compileString(string, null, errorReporter, string2, nArray[0], null);
    }

    protected int findPrototypeId(String string) {
        int n = 0;
        String string2 = null;
        switch (string.length()) {
            case 4: {
                string2 = "exec";
                n = 4;
                break;
            }
            case 7: {
                string2 = "compile";
                n = 3;
                break;
            }
            case 8: {
                string2 = "toString";
                n = 2;
                break;
            }
            case 11: {
                string2 = "constructor";
                n = 1;
            }
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n = 0;
        }
        return n;
    }
}

