/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.IdFunctionCall;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.UniqueTag;

public abstract class IdScriptableObject
extends ScriptableObject
implements IdFunctionCall {
    private volatile transient PrototypeValues prototypeValues;

    public IdScriptableObject() {
    }

    public IdScriptableObject(Scriptable scriptable, Scriptable scriptable2) {
        super(scriptable, scriptable2);
    }

    protected final Object defaultGet(String string) {
        return super.get(string, (Scriptable)this);
    }

    protected final void defaultPut(String string, Object object) {
        super.put(string, (Scriptable)this, object);
    }

    public boolean has(String string, Scriptable scriptable) {
        int n;
        int n2 = this.findInstanceIdInfo(string);
        if (n2 != 0) {
            int n3 = n2 >>> 16;
            if ((n3 & 4) != 0) {
                return true;
            }
            int n4 = n2 & 0xFFFF;
            return NOT_FOUND != this.getInstanceIdValue(n4);
        }
        if (this.prototypeValues != null && (n = this.prototypeValues.findId(string)) != 0) {
            return this.prototypeValues.has(n);
        }
        return super.has(string, scriptable);
    }

    public Object get(String string, Scriptable scriptable) {
        int n;
        int n2 = this.findInstanceIdInfo(string);
        if (n2 != 0) {
            int n3 = n2 & 0xFFFF;
            return this.getInstanceIdValue(n3);
        }
        if (this.prototypeValues != null && (n = this.prototypeValues.findId(string)) != 0) {
            return this.prototypeValues.get(n);
        }
        return super.get(string, scriptable);
    }

    public void put(String string, Scriptable scriptable, Object object) {
        int n;
        int n2 = this.findInstanceIdInfo(string);
        if (n2 != 0) {
            if (scriptable == this && this.isSealed()) {
                throw Context.reportRuntimeError1("msg.modify.sealed", string);
            }
            int n3 = n2 >>> 16;
            if ((n3 & 1) == 0) {
                if (scriptable == this) {
                    int n4 = n2 & 0xFFFF;
                    this.setInstanceIdValue(n4, object);
                } else {
                    scriptable.put(string, scriptable, object);
                }
            }
            return;
        }
        if (this.prototypeValues != null && (n = this.prototypeValues.findId(string)) != 0) {
            if (scriptable == this && this.isSealed()) {
                throw Context.reportRuntimeError1("msg.modify.sealed", string);
            }
            this.prototypeValues.set(n, scriptable, object);
            return;
        }
        super.put(string, scriptable, object);
    }

    public void delete(String string) {
        int n;
        int n2 = this.findInstanceIdInfo(string);
        if (n2 != 0 && !this.isSealed()) {
            int n3 = n2 >>> 16;
            if ((n3 & 4) == 0) {
                int n4 = n2 & 0xFFFF;
                this.setInstanceIdValue(n4, NOT_FOUND);
            }
            return;
        }
        if (this.prototypeValues != null && (n = this.prototypeValues.findId(string)) != 0) {
            if (!this.isSealed()) {
                this.prototypeValues.delete(n);
            }
            return;
        }
        super.delete(string);
    }

    public int getAttributes(String string) {
        int n;
        int n2 = this.findInstanceIdInfo(string);
        if (n2 != 0) {
            int n3 = n2 >>> 16;
            return n3;
        }
        if (this.prototypeValues != null && (n = this.prototypeValues.findId(string)) != 0) {
            return this.prototypeValues.getAttributes(n);
        }
        return super.getAttributes(string);
    }

    public void setAttributes(String string, int n) {
        int n2;
        ScriptableObject.checkValidAttributes(n);
        int n3 = this.findInstanceIdInfo(string);
        if (n3 != 0) {
            int n4 = n3 >>> 16;
            if (n != n4) {
                throw new RuntimeException("Change of attributes for this id is not supported");
            }
            return;
        }
        if (this.prototypeValues != null && (n2 = this.prototypeValues.findId(string)) != 0) {
            this.prototypeValues.setAttributes(n2, n);
            return;
        }
        super.setAttributes(string, n);
    }

    Object[] getIds(boolean bl) {
        int n;
        Object[] objectArray = super.getIds(bl);
        if (this.prototypeValues != null) {
            objectArray = this.prototypeValues.getNames(bl, objectArray);
        }
        if ((n = this.getMaxInstanceId()) != 0) {
            Object[] objectArray2 = null;
            int n2 = 0;
            int n3 = n;
            while (n3 != 0) {
                int n4;
                String string = this.getInstanceIdName(n3);
                int n5 = this.findInstanceIdInfo(string);
                if (!(n5 == 0 || ((n4 = n5 >>> 16) & 4) == 0 && NOT_FOUND == this.getInstanceIdValue(n3) || !bl && (n4 & 2) != 0)) {
                    if (n2 == 0) {
                        objectArray2 = new Object[n3];
                    }
                    objectArray2[n2++] = string;
                }
                --n3;
            }
            if (n2 != 0) {
                if (objectArray.length == 0 && objectArray2.length == n2) {
                    objectArray = objectArray2;
                } else {
                    Object[] objectArray3 = new Object[objectArray.length + n2];
                    System.arraycopy(objectArray, 0, objectArray3, 0, objectArray.length);
                    System.arraycopy(objectArray2, 0, objectArray3, objectArray.length, n2);
                    objectArray = objectArray3;
                }
            }
        }
        return objectArray;
    }

    protected int getMaxInstanceId() {
        return 0;
    }

    protected static int instanceIdInfo(int n, int n2) {
        return n << 16 | n2;
    }

    protected int findInstanceIdInfo(String string) {
        return 0;
    }

    protected String getInstanceIdName(int n) {
        throw new IllegalArgumentException(String.valueOf(n));
    }

    protected Object getInstanceIdValue(int n) {
        throw new IllegalStateException(String.valueOf(n));
    }

    protected void setInstanceIdValue(int n, Object object) {
        throw new IllegalStateException(String.valueOf(n));
    }

    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        throw idFunctionObject.unknown();
    }

    public final IdFunctionObject exportAsJSClass(int n, Scriptable scriptable, boolean bl) {
        if (scriptable != this && scriptable != null) {
            this.setParentScope(scriptable);
            this.setPrototype(IdScriptableObject.getObjectPrototype(scriptable));
        }
        this.activatePrototypeMap(n);
        IdFunctionObject idFunctionObject = this.prototypeValues.createPrecachedConstructor();
        if (bl) {
            this.sealObject();
        }
        this.fillConstructorProperties(idFunctionObject);
        if (bl) {
            idFunctionObject.sealObject();
        }
        idFunctionObject.exportAsScopeProperty();
        return idFunctionObject;
    }

    public final boolean hasPrototypeMap() {
        return this.prototypeValues != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void activatePrototypeMap(int n) {
        PrototypeValues prototypeValues = new PrototypeValues(this, n);
        IdScriptableObject idScriptableObject = this;
        synchronized (idScriptableObject) {
            if (this.prototypeValues != null) {
                throw new IllegalStateException();
            }
            this.prototypeValues = prototypeValues;
        }
    }

    public final void initPrototypeMethod(Object object, int n, String string, int n2) {
        Scriptable scriptable = ScriptableObject.getTopLevelScope(this);
        IdFunctionObject idFunctionObject = this.newIdFunction(object, n, string, n2, scriptable);
        this.prototypeValues.initValue(n, string, idFunctionObject, 2);
    }

    public final void initPrototypeConstructor(IdFunctionObject idFunctionObject) {
        int n = this.prototypeValues.constructorId;
        if (n == 0) {
            throw new IllegalStateException();
        }
        if (idFunctionObject.methodId() != n) {
            throw new IllegalArgumentException();
        }
        if (this.isSealed()) {
            idFunctionObject.sealObject();
        }
        this.prototypeValues.initValue(n, "constructor", idFunctionObject, 2);
    }

    public final void initPrototypeValue(int n, String string, Object object, int n2) {
        this.prototypeValues.initValue(n, string, object, n2);
    }

    protected void initPrototypeId(int n) {
        throw new IllegalStateException(String.valueOf(n));
    }

    protected int findPrototypeId(String string) {
        throw new IllegalStateException(string);
    }

    protected void fillConstructorProperties(IdFunctionObject idFunctionObject) {
    }

    protected void addIdFunctionProperty(Scriptable scriptable, Object object, int n, String string, int n2) {
        Scriptable scriptable2 = ScriptableObject.getTopLevelScope(scriptable);
        IdFunctionObject idFunctionObject = this.newIdFunction(object, n, string, n2, scriptable2);
        idFunctionObject.addAsProperty(scriptable);
    }

    protected static EcmaError incompatibleCallError(IdFunctionObject idFunctionObject) {
        throw ScriptRuntime.typeError1("msg.incompat.call", idFunctionObject.getFunctionName());
    }

    private IdFunctionObject newIdFunction(Object object, int n, String string, int n2, Scriptable scriptable) {
        IdFunctionObject idFunctionObject = new IdFunctionObject(this, object, n, string, n2, scriptable);
        if (this.isSealed()) {
            idFunctionObject.sealObject();
        }
        return idFunctionObject;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        if (n != 0) {
            this.activatePrototypeMap(n);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        int n = 0;
        if (this.prototypeValues != null) {
            n = this.prototypeValues.getMaxId();
        }
        objectOutputStream.writeInt(n);
    }

    private static final class PrototypeValues
    implements Serializable {
        static final long serialVersionUID = 3038645279153854371L;
        private static final int VALUE_SLOT = 0;
        private static final int NAME_SLOT = 1;
        private static final int SLOT_SPAN = 2;
        private IdScriptableObject obj;
        private int maxId;
        private volatile Object[] valueArray;
        private volatile short[] attributeArray;
        private volatile int lastFoundId = 1;
        int constructorId;
        private IdFunctionObject constructor;
        private short constructorAttrs;

        PrototypeValues(IdScriptableObject idScriptableObject, int n) {
            if (idScriptableObject == null) {
                throw new IllegalArgumentException();
            }
            if (n < 1) {
                throw new IllegalArgumentException();
            }
            this.obj = idScriptableObject;
            this.maxId = n;
        }

        final int getMaxId() {
            return this.maxId;
        }

        final void initValue(int n, String string, Object object, int n2) {
            if (1 > n || n > this.maxId) {
                throw new IllegalArgumentException();
            }
            if (string == null) {
                throw new IllegalArgumentException();
            }
            if (object == NOT_FOUND) {
                throw new IllegalArgumentException();
            }
            ScriptableObject.checkValidAttributes(n2);
            if (this.obj.findPrototypeId(string) != n) {
                throw new IllegalArgumentException(string);
            }
            if (n == this.constructorId) {
                if (!(object instanceof IdFunctionObject)) {
                    throw new IllegalArgumentException("consructor should be initialized with IdFunctionObject");
                }
                this.constructor = (IdFunctionObject)object;
                this.constructorAttrs = (short)n2;
                return;
            }
            this.initSlot(n, string, object, n2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initSlot(int n, String string, Object object, int n2) {
            Object[] objectArray = this.valueArray;
            if (objectArray == null) {
                throw new IllegalStateException();
            }
            if (object == null) {
                object = UniqueTag.NULL_VALUE;
            }
            int n3 = (n - 1) * 2;
            PrototypeValues prototypeValues = this;
            synchronized (prototypeValues) {
                Object object2 = objectArray[n3 + 0];
                if (object2 == null) {
                    objectArray[n3 + 0] = object;
                    objectArray[n3 + 1] = string;
                    this.attributeArray[n - 1] = (short)n2;
                } else if (!string.equals(objectArray[n3 + 1])) {
                    throw new IllegalStateException();
                }
            }
        }

        final IdFunctionObject createPrecachedConstructor() {
            if (this.constructorId != 0) {
                throw new IllegalStateException();
            }
            this.constructorId = this.obj.findPrototypeId("constructor");
            if (this.constructorId == 0) {
                throw new IllegalStateException("No id for constructor property");
            }
            this.obj.initPrototypeId(this.constructorId);
            if (this.constructor == null) {
                throw new IllegalStateException(String.valueOf(this.obj.getClass().getName()) + ".initPrototypeId() did not " + "initialize id=" + this.constructorId);
            }
            this.constructor.initFunction(this.obj.getClassName(), ScriptableObject.getTopLevelScope(this.obj));
            this.constructor.markAsConstructor(this.obj);
            return this.constructor;
        }

        final int findId(String string) {
            Object[] objectArray = this.valueArray;
            if (objectArray == null) {
                return this.obj.findPrototypeId(string);
            }
            int n = this.lastFoundId;
            if (string == objectArray[(n - 1) * 2 + 1]) {
                return n;
            }
            n = this.obj.findPrototypeId(string);
            if (n != 0) {
                int n2 = (n - 1) * 2 + 1;
                objectArray[n2] = string;
                this.lastFoundId = n;
            }
            return n;
        }

        final boolean has(int n) {
            Object[] objectArray = this.valueArray;
            if (objectArray == null) {
                return true;
            }
            int n2 = (n - 1) * 2 + 0;
            Object object = objectArray[n2];
            if (object == null) {
                return true;
            }
            return object != NOT_FOUND;
        }

        final Object get(int n) {
            Object object = this.ensureId(n);
            if (object == UniqueTag.NULL_VALUE) {
                object = null;
            }
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void set(int n, Scriptable scriptable, Object object) {
            if (object == NOT_FOUND) {
                throw new IllegalArgumentException();
            }
            this.ensureId(n);
            short s = this.attributeArray[n - 1];
            if ((s & 1) == 0) {
                if (scriptable == this.obj) {
                    if (object == null) {
                        object = UniqueTag.NULL_VALUE;
                    }
                    int n2 = (n - 1) * 2 + 0;
                    PrototypeValues prototypeValues = this;
                    synchronized (prototypeValues) {
                        this.valueArray[n2] = object;
                    }
                } else {
                    int n3 = (n - 1) * 2 + 1;
                    String string = (String)this.valueArray[n3];
                    scriptable.put(string, scriptable, object);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void delete(int n) {
            this.ensureId(n);
            short s = this.attributeArray[n - 1];
            if ((s & 4) == 0) {
                int n2 = (n - 1) * 2 + 0;
                PrototypeValues prototypeValues = this;
                synchronized (prototypeValues) {
                    this.valueArray[n2] = NOT_FOUND;
                    this.attributeArray[n - 1] = 0;
                }
            }
        }

        final int getAttributes(int n) {
            this.ensureId(n);
            return this.attributeArray[n - 1];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void setAttributes(int n, int n2) {
            ScriptableObject.checkValidAttributes(n2);
            this.ensureId(n);
            PrototypeValues prototypeValues = this;
            synchronized (prototypeValues) {
                this.attributeArray[n - 1] = (short)n2;
            }
        }

        final Object[] getNames(boolean bl, Object[] objectArray) {
            Object[] objectArray2;
            Object[] objectArray3 = null;
            int n = 0;
            int n2 = 1;
            while (n2 <= this.maxId) {
                objectArray2 = this.ensureId(n2);
                if ((bl || (this.attributeArray[n2 - 1] & 2) == 0) && objectArray2 != NOT_FOUND) {
                    int n3 = (n2 - 1) * 2 + 1;
                    String string = (String)this.valueArray[n3];
                    if (objectArray3 == null) {
                        objectArray3 = new Object[this.maxId];
                    }
                    objectArray3[n++] = string;
                }
                ++n2;
            }
            if (n == 0) {
                return objectArray;
            }
            if (objectArray == null || objectArray.length == 0) {
                if (n != objectArray3.length) {
                    Object[] objectArray4 = new Object[n];
                    System.arraycopy(objectArray3, 0, objectArray4, 0, n);
                    objectArray3 = objectArray4;
                }
                return objectArray3;
            }
            n2 = objectArray.length;
            objectArray2 = new Object[n2 + n];
            System.arraycopy(objectArray, 0, objectArray2, 0, n2);
            System.arraycopy(objectArray3, 0, objectArray2, n2, n);
            return objectArray2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object ensureId(int n) {
            int n2;
            Object object;
            Object[] objectArray = this.valueArray;
            if (objectArray == null) {
                PrototypeValues prototypeValues = this;
                synchronized (prototypeValues) {
                    objectArray = this.valueArray;
                    if (objectArray == null) {
                        this.valueArray = objectArray = new Object[this.maxId * 2];
                        this.attributeArray = new short[this.maxId];
                    }
                }
            }
            if ((object = objectArray[n2 = (n - 1) * 2 + 0]) == null) {
                if (n == this.constructorId) {
                    this.initSlot(this.constructorId, "constructor", this.constructor, this.constructorAttrs);
                    this.constructor = null;
                } else {
                    this.obj.initPrototypeId(n);
                }
                object = objectArray[n2];
                if (object == null) {
                    throw new IllegalStateException(String.valueOf(this.obj.getClass().getName()) + ".initPrototypeId(int id) " + "did not initialize id=" + n);
                }
            }
            return object;
        }
    }
}

