/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.tools;

import com.googlecode.d2j.dex.ClassVisitorFactory;
import com.googlecode.d2j.dex.DexExceptionHandler;
import com.googlecode.d2j.dex.ExDex2Asm;
import com.googlecode.d2j.node.DexClassNode;
import com.googlecode.d2j.node.DexFileNode;
import com.googlecode.d2j.reader.DexFileReader;
import com.googlecode.d2j.reader.zip.ZipUtil;
import com.googlecode.d2j.visitors.DexFileVisitor;
import com.googlecode.dex2jar.tools.BaksmaliBaseDexExceptionHandler;
import com.googlecode.dex2jar.tools.BaseCmd;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

@BaseCmd.Syntax(cmd="d2j-mt-dex2jar", syntax="[options] <file0> [file1 ... fileN]", desc="convert dex to jar")
public class Dex2jarMultiThreadCmd
extends BaseCmd {
    @BaseCmd.Opt(opt="mt", longOpt="multi-thread", description="concurrent process, default is 4 thread")
    private int multiThread = 4;
    @BaseCmd.Opt(opt="fl", longOpt="file-list", description="a file contains a list of dex to process")
    private Path fileList;

    public static void main(String ... args) {
        new Dex2jarMultiThreadCmd().doMain(args);
    }

    protected void doCommandLine() throws Exception {
        ArrayList<String> f = new ArrayList<String>();
        f.addAll(Arrays.asList(this.remainingArgs));
        if (this.fileList != null) {
            f.addAll(Files.readAllLines(this.fileList, StandardCharsets.UTF_8));
        }
        if (f.size() < 1) {
            throw new BaseCmd.HelpException();
        }
        final ExecutorService executorService = Executors.newFixedThreadPool(this.multiThread);
        final Iterator fileIt = f.iterator();
        executorService.submit(new Runnable(){

            @Override
            public void run() {
                if (fileIt.hasNext()) {
                    String fileName = (String)fileIt.next();
                    try {
                        try {
                            Dex2jarMultiThreadCmd.this.run0(fileName, executorService);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            executorService.submit(this);
                        }
                    }
                    finally {
                        executorService.submit(this);
                    }
                } else {
                    executorService.shutdown();
                }
            }
        });
        executorService.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
    }

    private void run0(String fileName, final ExecutorService executorService) throws IOException {
        String baseName = Dex2jarMultiThreadCmd.getBaseName((Path)new File(fileName).toPath());
        Path currentDir = new File(".").toPath();
        Path file = currentDir.resolve(String.valueOf(baseName) + "-dex2jar.jar");
        final Path errorFile = currentDir.resolve(String.valueOf(baseName) + "-error.zip");
        System.err.println("dex2jar " + fileName + " -> " + file);
        final BaksmaliBaseDexExceptionHandler exceptionHandler = new BaksmaliBaseDexExceptionHandler();
        DexFileReader reader = new DexFileReader(ZipUtil.readDex((File)new File(fileName)));
        DexFileNode fileNode = new DexFileNode();
        try {
            reader.accept((DexFileVisitor)fileNode, 33);
        }
        catch (Exception ex) {
            exceptionHandler.handleFileException(ex);
            throw ex;
        }
        final FileSystem fs = Dex2jarMultiThreadCmd.createZip((Path)file);
        final Path dist = fs.getPath("/", new String[0]);
        ClassVisitorFactory cvf = new ClassVisitorFactory(){

            public ClassVisitor create(final String name) {
                return new ClassVisitor(262144, (ClassVisitor)new ClassWriter(1)){

                    public void visitEnd() {
                        byte[] data;
                        super.visitEnd();
                        ClassWriter cw = (ClassWriter)this.cv;
                        try {
                            data = cw.toByteArray();
                        }
                        catch (Exception ex) {
                            System.err.println(String.format("ASM fail to generate .class file: %s", name));
                            exceptionHandler.handleFileException(ex);
                            return;
                        }
                        try {
                            Path dist1 = dist.resolve(String.valueOf(name) + ".class");
                            BaseCmd.createParentDirectories((Path)dist1);
                            Files.write(dist1, data, new OpenOption[0]);
                        }
                        catch (IOException e) {
                            exceptionHandler.handleFileException(e);
                        }
                    }
                };
            }
        };
        new ExDex2Asm((DexExceptionHandler)exceptionHandler){

            public void convertDex(DexFileNode fileNode, final ClassVisitorFactory cvf) {
                if (fileNode.clzs != null) {
                    final Map classes = 3.collectClzInfo((DexFileNode)fileNode);
                    final ArrayList results = new ArrayList(fileNode.clzs.size());
                    for (final DexClassNode classNode : fileNode.clzs) {
                        results.add(executorService.submit(new Runnable(){

                            @Override
                            public void run() {
                                this.convertClass(classNode, cvf, classes);
                            }
                        }));
                    }
                    executorService.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (Future result : results) {
                                try {
                                    result.get();
                                }
                                catch (InterruptedException | ExecutionException e) {
                                    e.printStackTrace();
                                }
                            }
                            BaksmaliBaseDexExceptionHandler exceptionHandler1 = (BaksmaliBaseDexExceptionHandler)exceptionHandler;
                            if (exceptionHandler1.hasException()) {
                                exceptionHandler1.dump(errorFile, new String[0]);
                            }
                            try {
                                fs.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
            }
        }.convertDex(fileNode, cvf);
    }
}

