/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.popup;

import com.almworks.dup.util.EventListener;
import com.almworks.dup.util.ValueEvent;
import com.almworks.dup.util.ValueModel;
import com.almworks.tracker.eapi.alpha.ArtifactInfo;
import com.almworks.tracker.eapi.alpha.ArtifactInfoStatus;
import com.almworks.tracker.eapi.alpha.TrackerConnector;
import com.almworks.tracklink.codelinks.cache.ArtifactInfoCache;
import com.almworks.tracklink.popup.ArtifactInfoList;
import com.almworks.tracklink.popup.ChangeListAdapter;
import com.almworks.tracklink.popup.DragAdapter;
import com.almworks.tracklink.popup.HTMLPane;
import com.almworks.tracklink.popup.LiveDialog;
import com.almworks.tracklink.popup.ToolbarPanel;
import com.almworks.util.Log;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Pair;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ListDataEvent;
import org.almworks.util.detach.DetachComposite;
import org.almworks.util.detach.Lifespan;
import org.jetbrains.annotations.Nullable;

public class ArtifactInfoDialogWrapper
extends DialogWrapper
implements LiveDialog {
    private static final int MAX_WIDTH = 500;
    private static final int MAX_HEIGHT = 400;
    private static final int MIN_WIDTH = 500;
    private static final int MIN_HEIGHT = 70;
    private final ArtifactInfoList myModel;
    @Nullable
    private final TrackerConnector myConnector;
    private HTMLPane myHtmlPane;
    private Point myPreferredLocation;
    private final DetachComposite myLifespan = new DetachComposite();
    private static final Action[] EMPTY_ACTIONS = new Action[0];
    private String myHighLightPattern;

    public ArtifactInfoDialogWrapper(Component parent, ArtifactInfoCache cache, String url, Project project, String highlightPattern) {
        super(parent, true);
        this.myModel = cache.getListModel((Object)this, project, (Lifespan)this.myLifespan, url);
        this.myConnector = cache.getConnector(project);
        this.myHighLightPattern = highlightPattern;
        this.init();
        this.setModal(false);
        this.setUndecorated(true);
        this.initClosingListeners();
        this.checkPreferredSize();
    }

    public Point getInitialLocation() {
        return this.myPreferredLocation;
    }

    public void centerRelativeToParent() {
    }

    private void initClosingListeners() {
        this.getWindow().addWindowListener(new WindowAdapter(){

            public void windowDeactivated(WindowEvent e) {
                ArtifactInfoDialogWrapper.this.myLifespan.detach();
                Log.debug("Window's lifespan detached [deactivated]");
            }
        });
        this.getWindow().addWindowFocusListener(new WindowAdapter(){

            public void windowLostFocus(WindowEvent e) {
                ArtifactInfoDialogWrapper.this.close(1);
            }
        });
        KeyAdapter listener = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27 || e.getKeyCode() == 10) {
                    ArtifactInfoDialogWrapper.this.close(1);
                }
            }
        };
        this.getWindow().addKeyListener(listener);
        this.myHtmlPane.addKeyListener(listener);
    }

    private boolean checkPreferredSize() {
        if (this.myHtmlPane == null) {
            return false;
        }
        Dimension size = this.myHtmlPane.getViewport().getPreferredSize();
        int width = (int)size.getWidth();
        int height = (int)size.getHeight();
        boolean needSetPreferredSize = false;
        if (size.getWidth() < 500.0) {
            needSetPreferredSize = true;
            width = 500;
        }
        if (size.getWidth() > 500.0) {
            needSetPreferredSize = true;
            width = 500;
        }
        if (size.getHeight() < 70.0) {
            needSetPreferredSize = true;
            height = 70;
        }
        if (size.getHeight() > 400.0) {
            needSetPreferredSize = true;
            height = 400;
        }
        if (needSetPreferredSize) {
            Dimension preferredSize = new Dimension(width, height);
            this.myHtmlPane.setPreferredSize(preferredSize);
        }
        return needSetPreferredSize;
    }

    public void checkSizeAndLocation() {
        if (this.checkPreferredSize()) {
            Dimension preferredSize = this.getPreferredSize();
            if (!this.getSize().equals(preferredSize)) {
                this.setSize(preferredSize.width, preferredSize.height);
            }
        }
    }

    public void show() {
        super.show();
        if (this.myPreferredLocation != null) {
            this.setLocation(this.myPreferredLocation);
        }
    }

    public void setLocation(@Nullable Point p) {
        if (p != null) {
            this.myPreferredLocation = p.getLocation();
            GraphicsConfiguration defaultConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(defaultConfiguration);
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            p.x = Math.max(p.x, screenInsets.left);
            p.y = Math.max(p.y, screenInsets.top);
            p.x = Math.min(p.x, screenSize.width - screenInsets.right - this.getWindow().getWidth());
            p.y = Math.min(p.y, screenSize.height - screenInsets.bottom - this.getWindow().getHeight());
            super.setLocation(p);
        }
    }

    protected Border createContentPaneBorder() {
        return new LineBorder(Color.BLACK);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myHtmlPane.getPreferredFocusedComponent();
    }

    protected JComponent createCenterPanel() {
        ProvidingPanel p = new ProvidingPanel(new BorderLayout());
        final ToolbarPanel toolbarPanel = new ToolbarPanel();
        this.myModel.addListDataListener(new ChangeListAdapter(){

            public void contentsChanged(ListDataEvent e) {
                toolbarPanel.updateLabels(ArtifactInfoDialogWrapper.this.myModel);
            }
        });
        if (this.myConnector != null) {
            ValueModel connectionStatus = this.myConnector.getTrackerStarter().getConnectionStatus();
            connectionStatus.events().addListener((Lifespan)this.myLifespan, ValueEvent.class, (EventListener)new EventListener<ValueEvent>(){

                public void onEvent(ValueEvent event) {
                    toolbarPanel.updateLabels(ArtifactInfoDialogWrapper.this.myModel);
                }
            });
        }
        toolbarPanel.setMaximumSize(new Dimension(500, 27));
        toolbarPanel.setMinimumSize(new Dimension(500, 27));
        toolbarPanel.setPreferredSize(new Dimension(500, 27));
        toolbarPanel.updateLabels(this.myModel);
        DragAdapter.attachToComponent(toolbarPanel, this.getWindow(), (Lifespan)this.myLifespan);
        this.myHtmlPane = new HTMLPane(this, this.myModel, this.myHighLightPattern);
        p.add((Component)toolbarPanel, "North");
        p.add((Component)this.myHtmlPane, "Center");
        return p;
    }

    protected Action[] createActions() {
        return EMPTY_ACTIONS;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProvidingPanel
    extends JPanel
    implements DataProvider {
        public ProvidingPanel(LayoutManager layout) {
            super(layout);
        }

        @Nullable
        public Object getData(String dataId) {
            if ("ArtifactInfoList".equals(dataId)) {
                return ArtifactInfoDialogWrapper.this.myModel;
            }
            if ("PopupLifespan".equals(dataId)) {
                return ArtifactInfoDialogWrapper.this.myLifespan;
            }
            if ("NeedDownloadIssues".equals(dataId)) {
                return this.checkModel().getFirst();
            }
            if ("NeedMakeConnection".equals(dataId)) {
                return this.checkModel().getSecond();
            }
            return null;
        }

        private Pair<Boolean, Boolean> checkModel() {
            boolean noArtifact = false;
            boolean noConnection = false;
            for (ArtifactInfo artifactInfo : ArtifactInfoDialogWrapper.this.myModel.getValuesSnapshot()) {
                ArtifactInfoStatus status = artifactInfo.getStatus();
                if (status == ArtifactInfoStatus.NO_ARTIFACT) {
                    noArtifact = true;
                }
                if (status != ArtifactInfoStatus.NO_CONNECTION) continue;
                noConnection = true;
            }
            return Pair.create((Object)noArtifact, (Object)noConnection);
        }
    }
}

